/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.chunk;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NibbleArray3d {
    private final byte @lombok.NonNull [] data;

    public NibbleArray3d(int size) {
        this(new byte[size >> 1]);
    }

    public int get(int x, int y, int z) {
        int key = y << 8 | z << 4 | x;
        int index = key >> 1;
        int part = key & 1;
        return part == 0 ? this.data[index] & 0xF : this.data[index] >> 4 & 0xF;
    }

    public void set(int x, int y, int z, int val) {
        int key = y << 8 | z << 4 | x;
        int index = key >> 1;
        int part = key & 1;
        this.data[index] = part == 0 ? (byte)(this.data[index] & 0xF0 | val & 0xF) : (byte)(this.data[index] & 0xF | (val & 0xF) << 4);
    }

    public void fill(int val) {
        for (int index = 0; index < this.data.length << 1; ++index) {
            int ind = index >> 1;
            int part = index & 1;
            this.data[ind] = part == 0 ? (byte)(this.data[ind] & 0xF0 | val & 0xF) : (byte)(this.data[ind] & 0xF | (val & 0xF) << 4);
        }
    }

    public byte @lombok.NonNull [] getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NibbleArray3d)) {
            return false;
        }
        NibbleArray3d other = (NibbleArray3d)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof NibbleArray3d;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public @NonNull String toString() {
        return "NibbleArray3d(data=" + Arrays.toString(this.getData()) + ")";
    }

    public NibbleArray3d(byte @lombok.NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
    }
}

