/*
 * Decompiled with CFR 0.152.
 */
package net.ypresto.androidtranscoder.engine;

import java.nio.ShortBuffer;

public interface AudioRemixer {
    public static final AudioRemixer DOWNMIX = new AudioRemixer(){
        private static final int SIGNED_SHORT_LIMIT = 32768;
        private static final int UNSIGNED_SHORT_MAX = 65535;

        @Override
        public void remix(ShortBuffer inSBuff, ShortBuffer outSBuff) {
            int inRemaining = inSBuff.remaining() / 2;
            int outSpace = outSBuff.remaining();
            int samplesToBeProcessed = Math.min(inRemaining, outSpace);
            for (int i = 0; i < samplesToBeProcessed; ++i) {
                int a = inSBuff.get() + 32768;
                int b = inSBuff.get() + 32768;
                int m = a < 32768 || b < 32768 ? a * b / 32768 : 2 * (a + b) - a * b / 32768 - 65535;
                if (m == 65536) {
                    m = 65535;
                }
                outSBuff.put((short)(m - 32768));
            }
        }
    };
    public static final AudioRemixer UPMIX = new AudioRemixer(){

        @Override
        public void remix(ShortBuffer inSBuff, ShortBuffer outSBuff) {
            int inRemaining = inSBuff.remaining();
            int outSpace = outSBuff.remaining() / 2;
            int samplesToBeProcessed = Math.min(inRemaining, outSpace);
            for (int i = 0; i < samplesToBeProcessed; ++i) {
                short inSample = inSBuff.get();
                outSBuff.put(inSample);
                outSBuff.put(inSample);
            }
        }
    };
    public static final AudioRemixer PASSTHROUGH = new AudioRemixer(){

        @Override
        public void remix(ShortBuffer inSBuff, ShortBuffer outSBuff) {
            outSBuff.put(inSBuff);
        }
    };

    public void remix(ShortBuffer var1, ShortBuffer var2);
}

