/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.versionchecklib.v2.net;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.allenliu.versionchecklib.core.http.AllenHttp;
import com.allenliu.versionchecklib.core.http.HttpRequestMethod;
import com.allenliu.versionchecklib.utils.ALog;
import com.allenliu.versionchecklib.v2.AllenVersionChecker;
import com.allenliu.versionchecklib.v2.builder.DownloadBuilder;
import com.allenliu.versionchecklib.v2.builder.RequestVersionBuilder;
import com.allenliu.versionchecklib.v2.builder.UIData;
import com.allenliu.versionchecklib.v2.callback.RequestVersionListener;
import java.io.IOException;
import java.util.concurrent.Executors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class RequestVersionManager {
    private final Handler handler = new Handler(Looper.getMainLooper());

    public static RequestVersionManager getInstance() {
        return Holder.instance;
    }

    public void requestVersion(final DownloadBuilder builder, final Context context) {
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                block10: {
                    RequestVersionBuilder requestVersionBuilder = builder.getRequestVersionBuilder();
                    OkHttpClient client = AllenHttp.getHttpClient();
                    HttpRequestMethod requestMethod = requestVersionBuilder.getRequestMethod();
                    Request request = null;
                    switch (requestMethod) {
                        case GET: {
                            request = AllenHttp.get(requestVersionBuilder).build();
                            break;
                        }
                        case POST: {
                            request = AllenHttp.post(requestVersionBuilder).build();
                            break;
                        }
                        case POSTJSON: {
                            request = AllenHttp.postJson(requestVersionBuilder).build();
                        }
                    }
                    final RequestVersionListener requestVersionListener = requestVersionBuilder.getRequestVersionListener();
                    if (requestVersionListener != null) {
                        try {
                            final Response response = client.newCall(request).execute();
                            if (response.isSuccessful()) {
                                final String result = response.body() != null ? response.body().string() : null;
                                RequestVersionManager.this.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        UIData versionBundle = requestVersionListener.onRequestVersionSuccess(builder, result);
                                        if (versionBundle != null) {
                                            builder.setVersionBundle(versionBundle);
                                            builder.download(context);
                                        }
                                    }
                                });
                                break block10;
                            }
                            RequestVersionManager.this.post(new Runnable(){

                                @Override
                                public void run() {
                                    requestVersionListener.onRequestVersionFailure(response.message());
                                    AllenVersionChecker.getInstance().cancelAllMission();
                                }
                            });
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            RequestVersionManager.this.post(new Runnable(){

                                @Override
                                public void run() {
                                    requestVersionListener.onRequestVersionFailure(e.getMessage());
                                    AllenVersionChecker.getInstance().cancelAllMission();
                                }
                            });
                        }
                    } else {
                        ALog.e("using request version function,you must set a requestVersionListener");
                    }
                }
            }
        });
    }

    private void post(Runnable r) {
        this.handler.post(r);
    }

    public static class Holder {
        static RequestVersionManager instance = new RequestVersionManager();
    }
}

