/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.versionchecklib.core.http;

import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public abstract class FileCallBack
implements Callback {
    private String path;
    private String name;
    private Handler handler;

    public FileCallBack(String path, String name) {
        this.path = path;
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
    }

    public void onFailure(Call call, IOException e) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                FileCallBack.this.onDownloadFailed();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(final Call call, final Response response) {
        if (!response.isSuccessful()) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    FileCallBack.this.onDownloadFailed();
                }
            });
            return;
        }
        InputStream is = null;
        byte[] buf = new byte[2048];
        int len = 0;
        FileOutputStream fos = null;
        File pathFile = new File(this.path);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        try {
            is = response.body().byteStream();
            final File file = new File(this.path, this.name);
            if (file.exists()) {
                file.delete();
            } else {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            long sum = 0L;
            while ((len = is.read(buf)) != -1) {
                long total = response.body().contentLength();
                fos.write(buf, 0, len);
                final int progress = (int)((double)(sum += (long)len) / (double)total * 100.0);
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        FileCallBack.this.onDownloading(progress);
                    }
                });
            }
            fos.flush();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    FileCallBack.this.onSuccess(file, call, response);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    FileCallBack.this.onDownloadFailed();
                }
            });
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract void onSuccess(File var1, Call var2, Response var3);

    public abstract void onDownloading(int var1);

    public abstract void onDownloadFailed();
}

