/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.versionchecklib.core;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.allenliu.versionchecklib.R;
import com.allenliu.versionchecklib.callback.APKDownloadListener;
import com.allenliu.versionchecklib.callback.CommitClickListener;
import com.allenliu.versionchecklib.callback.DialogDismissListener;
import com.allenliu.versionchecklib.callback.DownloadListener;
import com.allenliu.versionchecklib.core.AllenChecker;
import com.allenliu.versionchecklib.core.DownloadManager;
import com.allenliu.versionchecklib.core.VersionParams;
import com.allenliu.versionchecklib.core.http.AllenHttp;
import com.allenliu.versionchecklib.utils.ALog;
import com.allenliu.versionchecklib.utils.AppUtils;
import com.allenliu.versionchecklib.v2.ui.AllenBaseActivity;
import java.io.File;

public class VersionDialogActivity
extends AllenBaseActivity
implements DownloadListener,
DialogInterface.OnDismissListener {
    public static final int MY_PERMISSIONS_REQUEST_WRITE_EXTERNAL_STORAGE = 291;
    protected Dialog versionDialog;
    protected Dialog loadingDialog;
    protected Dialog failDialog;
    private String downloadUrl;
    private VersionParams versionParams;
    private String title;
    private String updateMsg;
    private CommitClickListener commitListener;
    private DialogDismissListener cancelListener;
    private APKDownloadListener apkDownloadListener;
    private View loadingView;
    public static VersionDialogActivity instance;
    boolean isDestroy = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        instance = this;
        boolean isRetry = this.getIntent().getBooleanExtra("isRetry", false);
        Log.e((String)"isRetry", (String)(isRetry + ""));
        if (isRetry) {
            this.retryDownload(this.getIntent());
        } else {
            this.initialize();
        }
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public VersionParams getVersionParams() {
        return this.versionParams;
    }

    public String getVersionTitle() {
        return this.title;
    }

    public String getVersionUpdateMsg() {
        return this.updateMsg;
    }

    public Bundle getVersionParamBundle() {
        return this.versionParams.getParamBundle();
    }

    private void initialize() {
        this.title = this.getIntent().getStringExtra("title");
        this.updateMsg = this.getIntent().getStringExtra("text");
        this.versionParams = (VersionParams)this.getIntent().getParcelableExtra("VERSION_PARAMS_KEY");
        this.downloadUrl = this.getIntent().getStringExtra("downloadUrl");
        if (this.title != null && this.updateMsg != null && this.downloadUrl != null && this.versionParams != null) {
            this.showVersionDialog();
        }
    }

    protected void showVersionDialog() {
        if (!this.isDestroy) {
            this.versionDialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.title).setMessage((CharSequence)this.updateMsg).setPositiveButton((CharSequence)this.getString(R.string.versionchecklib_confirm), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (VersionDialogActivity.this.commitListener != null) {
                        VersionDialogActivity.this.commitListener.onCommitClick();
                    }
                    VersionDialogActivity.this.dealAPK();
                }
            }).setNegativeButton((CharSequence)this.getString(R.string.versionchecklib_cancel), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    VersionDialogActivity.this.finish();
                }
            }).create();
            this.versionDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
            this.versionDialog.setCanceledOnTouchOutside(false);
            this.versionDialog.setCancelable(false);
            this.versionDialog.show();
        }
    }

    public void showLoadingDialog(int currentProgress) {
        ALog.e("show default downloading dialog");
        if (!this.isDestroy) {
            if (this.loadingDialog == null) {
                this.loadingView = LayoutInflater.from((Context)this).inflate(R.layout.downloading_layout, null);
                this.loadingDialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)"").setView(this.loadingView).create();
                this.loadingDialog.setCancelable(true);
                this.loadingDialog.setCanceledOnTouchOutside(false);
                this.loadingDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        AllenHttp.getHttpClient().dispatcher().cancelAll();
                    }
                });
            }
            ProgressBar pb = (ProgressBar)this.loadingView.findViewById(R.id.pb);
            TextView tvProgress = (TextView)this.loadingView.findViewById(R.id.tv_progress);
            tvProgress.setText((CharSequence)String.format(this.getString(R.string.versionchecklib_progress), currentProgress));
            pb.setProgress(currentProgress);
            this.loadingDialog.show();
        }
    }

    public void showFailDialog() {
        if (!this.isDestroy) {
            if (this.versionParams != null && this.versionParams.isShowDownloadFailDialog()) {
                if (this.failDialog == null) {
                    this.failDialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)this.getString(R.string.versionchecklib_download_fail_retry)).setPositiveButton((CharSequence)this.getString(R.string.versionchecklib_confirm), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            if (VersionDialogActivity.this.commitListener != null) {
                                VersionDialogActivity.this.commitListener.onCommitClick();
                            }
                            VersionDialogActivity.this.dealAPK();
                        }
                    }).setNegativeButton((CharSequence)this.getString(R.string.versionchecklib_cancel), null).create();
                    this.failDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
                    this.failDialog.setCanceledOnTouchOutside(false);
                    this.failDialog.setCancelable(false);
                }
                this.failDialog.show();
            } else {
                this.onDismiss(null);
            }
        }
    }

    protected void onNewIntent(Intent intent) {
        boolean isRetry = intent.getBooleanExtra("isRetry", false);
        Log.e((String)"isRetry", (String)(isRetry + ""));
        if (isRetry) {
            this.retryDownload(intent);
        }
    }

    private void retryDownload(Intent intent) {
        this.dismissAllDialog();
        this.versionParams = (VersionParams)intent.getParcelableExtra("VERSION_PARAMS_KEY");
        this.downloadUrl = intent.getStringExtra("downloadUrl");
        this.requestPermissionAndDownloadFile();
    }

    public void setApkDownloadListener(APKDownloadListener apkDownloadListener) {
        this.apkDownloadListener = apkDownloadListener;
    }

    public void setCommitClickListener(CommitClickListener commitListner) {
        this.commitListener = commitListner;
    }

    public void setDialogDimissListener(DialogDismissListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    public void dealAPK() {
        if (this.versionParams.isSilentDownload()) {
            String downloadPath = this.versionParams.getDownloadAPKPath() + this.getString(R.string.versionchecklib_download_apkname, new Object[]{this.getPackageName()});
            AppUtils.installApk((Context)this, new File(downloadPath));
            this.finish();
        } else {
            if (this.versionParams.isShowDownloadingDialog()) {
                this.showLoadingDialog(0);
            }
            this.requestPermissionAndDownloadFile();
        }
    }

    protected void downloadFile() {
        if (this.versionParams.isShowDownloadingDialog()) {
            this.showLoadingDialog(0);
        }
        DownloadManager.downloadAPK(this.downloadUrl, this.versionParams, this);
    }

    protected void requestPermissionAndDownloadFile() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)291);
            } else {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)291);
            }
        } else {
            this.downloadFile();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 291: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.downloadFile();
                } else {
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.versionchecklib_write_permission_deny), (int)1).show();
                    this.finish();
                }
                return;
            }
        }
    }

    @Override
    public void onCheckerDownloading(int progress) {
        if (this.versionParams.isShowDownloadingDialog()) {
            this.showLoadingDialog(progress);
        } else {
            if (this.loadingDialog != null) {
                this.loadingDialog.dismiss();
            }
            this.finish();
        }
        if (this.apkDownloadListener != null) {
            this.apkDownloadListener.onDownloading(progress);
        }
    }

    @Override
    public void onCheckerDownloadSuccess(File file) {
        if (this.apkDownloadListener != null) {
            this.apkDownloadListener.onDownloadSuccess(file);
        }
        this.dismissAllDialog();
    }

    @Override
    public void onCheckerDownloadFail() {
        if (this.apkDownloadListener != null) {
            this.apkDownloadListener.onDownloadFail();
        }
        this.dismissAllDialog();
        this.showFailDialog();
    }

    @Override
    public void onCheckerStartDownload() {
        if (!this.versionParams.isShowDownloadingDialog()) {
            this.finish();
        }
    }

    @Override
    protected void onDestroy() {
        this.isDestroy = true;
        instance = null;
        super.onDestroy();
    }

    private void dismissAllDialog() {
        if (!this.isDestroy) {
            ALog.e("dismiss all dialog");
            if (this.loadingDialog != null && this.loadingDialog.isShowing()) {
                this.loadingDialog.dismiss();
            }
            if (this.versionDialog != null && this.versionDialog.isShowing()) {
                this.versionDialog.dismiss();
            }
            if (this.failDialog != null && this.failDialog.isShowing()) {
                this.failDialog.dismiss();
            }
        }
    }

    public void onDismiss(DialogInterface dialogInterface) {
        if (this.versionParams.isSilentDownload() || !this.versionParams.isSilentDownload() && this.loadingDialog == null && this.versionParams.isShowDownloadingDialog() || !this.versionParams.isSilentDownload() && this.loadingDialog != null && !this.loadingDialog.isShowing() && this.versionParams.isShowDownloadingDialog()) {
            if (this.cancelListener != null) {
                this.cancelListener.dialogDismiss(dialogInterface);
            }
            this.finish();
            AllenChecker.cancelMission();
        }
    }

    @Override
    public void showDefaultDialog() {
    }

    @Override
    public void showCustomDialog() {
    }
}

