/*
 * Decompiled with CFR 0.152.
 */
package com.visa;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;

class Trapezoid
extends View {
    private double mAngle;
    private int mColor;

    public Trapezoid(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    void setAngle(double angle) {
        this.mAngle = angle;
    }

    void setColor(int color2) {
        this.mColor = color2;
        this.invalidate();
        this.requestLayout();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int topLeftX = this.topLeftX();
        Path path = new Path();
        path.moveTo((float)this.getWidth(), 0.0f);
        path.lineTo((float)topLeftX, 0.0f);
        path.lineTo(0.0f, (float)this.getHeight());
        path.lineTo((float)this.getWidth(), (float)this.getHeight());
        path.lineTo((float)this.getWidth(), 0.0f);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(this.mColor);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawPath(path, paint);
    }

    private int topLeftX() {
        double angleRadians = Math.toRadians(this.mAngle);
        double x = (double)this.getHeight() / Math.tan(angleRadians);
        return (int)x;
    }
}

