/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary.utils;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.util.Log;
import com.abedelazizshe.lightcompressorlibrary.VideoQuality;
import com.abedelazizshe.lightcompressorlibrary.video.Mp4Movie;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u0012\u0010$\u001a\u00020%2\n\u0010&\u001a\u00060'j\u0002`(J\u001e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0004J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u000201R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/utils/CompressorUtils;", "", "()V", "I_FRAME_INTERVAL", "", "MIN_HEIGHT", "", "MIN_WIDTH", "autoResizePercentage", "width", "height", "findTrack", "extractor", "Landroid/media/MediaExtractor;", "isVideo", "", "getBitrate", "bitrate", "quality", "Lcom/abedelazizshe/lightcompressorlibrary/VideoQuality;", "getColorRange", "format", "Landroid/media/MediaFormat;", "(Landroid/media/MediaFormat;)Ljava/lang/Integer;", "getColorStandard", "getColorTransfer", "getFrameRate", "getHighestCodecProfileLevel", "type", "", "getIFrameIntervalRate", "hasQTI", "prepareVideoHeight", "mediaMetadataRetriever", "Landroid/media/MediaMetadataRetriever;", "prepareVideoWidth", "printException", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "setOutputFileParameters", "inputFormat", "outputFormat", "newBitrate", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/video/Mp4Movie;", "rotation", "cacheFile", "Ljava/io/File;", "lightcompressor_release"})
@SourceDebugExtension(value={"SMAP\nCompressorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressorUtils.kt\ncom/abedelazizshe/lightcompressorlibrary/utils/CompressorUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n3792#2:322\n4307#2,2:323\n11335#2:339\n11670#2,3:340\n1603#3,9:325\n1855#3:334\n1856#3:336\n1612#3:337\n1855#3:338\n1856#3:343\n1#4:335\n*S KotlinDebug\n*F\n+ 1 CompressorUtils.kt\ncom/abedelazizshe/lightcompressorlibrary/utils/CompressorUtils\n*L\n241#1:322\n241#1:323,2\n245#1:339\n245#1:340,3\n242#1:325,9\n242#1:334\n242#1:336\n242#1:337\n244#1:338\n244#1:343\n242#1:335\n*E\n"})
public final class CompressorUtils {
    @NotNull
    public static final CompressorUtils INSTANCE = new CompressorUtils();
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 368.0;
    private static final int I_FRAME_INTERVAL = 1;

    private CompressorUtils() {
    }

    public final double prepareVideoWidth(@NotNull MediaMetadataRetriever mediaMetadataRetriever) {
        Intrinsics.checkNotNullParameter((Object)mediaMetadataRetriever, (String)"mediaMetadataRetriever");
        String widthData = mediaMetadataRetriever.extractMetadata(18);
        CharSequence charSequence = widthData;
        return charSequence == null || charSequence.length() == 0 ? 368.0 : Double.parseDouble(widthData);
    }

    public final double prepareVideoHeight(@NotNull MediaMetadataRetriever mediaMetadataRetriever) {
        Intrinsics.checkNotNullParameter((Object)mediaMetadataRetriever, (String)"mediaMetadataRetriever");
        String heightData = mediaMetadataRetriever.extractMetadata(19);
        CharSequence charSequence = heightData;
        return charSequence == null || charSequence.length() == 0 ? 640.0 : Double.parseDouble(heightData);
    }

    @NotNull
    public final Mp4Movie setUpMP4Movie(int rotation, @NotNull File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie;
        Intrinsics.checkNotNullParameter((Object)cacheFile, (String)"cacheFile");
        Mp4Movie $this$setUpMP4Movie_u24lambda_u240 = mp4Movie = (movie = new Mp4Movie());
        boolean bl = false;
        $this$setUpMP4Movie_u24lambda_u240.setCacheFile(cacheFile);
        $this$setUpMP4Movie_u24lambda_u240.setRotation(rotation);
        return movie;
    }

    public final void setOutputFileParameters(@NotNull MediaFormat inputFormat, @NotNull MediaFormat outputFormat, int newBitrate) {
        int it;
        MediaFormat mediaFormat;
        Intrinsics.checkNotNullParameter((Object)inputFormat, (String)"inputFormat");
        Intrinsics.checkNotNullParameter((Object)outputFormat, (String)"outputFormat");
        int newFrameRate = this.getFrameRate(inputFormat);
        int iFrameInterval = this.getIFrameIntervalRate(inputFormat);
        MediaFormat $this$setOutputFileParameters_u24lambda_u244 = mediaFormat = outputFormat;
        boolean bl = false;
        if (Build.VERSION.SDK_INT >= 26) {
            String type = outputFormat.getString("mime");
            int higherLevel = INSTANCE.getHighestCodecProfileLevel(type);
            Log.i((String)"Output file parameters", (String)("Selected CodecProfileLevel: " + higherLevel));
            $this$setOutputFileParameters_u24lambda_u244.setInteger("profile", higherLevel);
        } else {
            $this$setOutputFileParameters_u24lambda_u244.setInteger("profile", 1);
        }
        $this$setOutputFileParameters_u24lambda_u244.setInteger("color-format", 2130708361);
        $this$setOutputFileParameters_u24lambda_u244.setInteger("frame-rate", newFrameRate);
        $this$setOutputFileParameters_u24lambda_u244.setInteger("i-frame-interval", iFrameInterval);
        $this$setOutputFileParameters_u24lambda_u244.setInteger("bitrate", newBitrate);
        $this$setOutputFileParameters_u24lambda_u244.setInteger("bitrate-mode", 2);
        Integer n = INSTANCE.getColorStandard(inputFormat);
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$setOutputFileParameters_u24lambda_u244.setInteger("color-standard", it);
        }
        Integer n2 = INSTANCE.getColorTransfer(inputFormat);
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl3 = false;
            $this$setOutputFileParameters_u24lambda_u244.setInteger("color-transfer", it);
        }
        Integer n3 = INSTANCE.getColorRange(inputFormat);
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl4 = false;
            $this$setOutputFileParameters_u24lambda_u244.setInteger("color-range", it);
        }
        Log.i((String)"Output file parameters", (String)("videoFormat: " + $this$setOutputFileParameters_u24lambda_u244));
    }

    private final int getFrameRate(MediaFormat format) {
        return format.containsKey("frame-rate") ? format.getInteger("frame-rate") : 30;
    }

    private final int getIFrameIntervalRate(MediaFormat format) {
        return format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 1;
    }

    private final Integer getColorStandard(MediaFormat format) {
        return format.containsKey("color-standard") ? Integer.valueOf(format.getInteger("color-standard")) : null;
    }

    private final Integer getColorTransfer(MediaFormat format) {
        return format.containsKey("color-transfer") ? Integer.valueOf(format.getInteger("color-transfer")) : null;
    }

    private final Integer getColorRange(MediaFormat format) {
        return format.containsKey("color-range") ? Integer.valueOf(format.getInteger("color-range")) : null;
    }

    public final int findTrack(@NotNull MediaExtractor extractor, boolean isVideo) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format;
            Intrinsics.checkNotNullExpressionValue((Object)extractor.getTrackFormat(i), (String)"extractor.getTrackFormat(i)");
            String mime = format.getString("mime");
            if (isVideo) {
                String string = mime;
                Boolean bl = string != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null)) : null;
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) continue;
                return i;
            }
            String string = mime;
            Boolean bl = string != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null)) : null;
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) continue;
            return i;
        }
        return -5;
    }

    public final void printException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String message = null;
        message = "An error has occurred!";
        String string = exception.getLocalizedMessage();
        if (string != null) {
            String it = string;
            boolean bl = false;
            message = it;
        }
        Log.e((String)"Compressor", (String)message, (Throwable)exception);
    }

    public final int getBitrate(int bitrate, @NotNull VideoQuality quality) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)quality), (String)"quality");
        switch (WhenMappings.$EnumSwitchMapping$0[quality.ordinal()]) {
            case 1: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.1));
                break;
            }
            case 2: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.2));
                break;
            }
            case 3: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.3));
                break;
            }
            case 4: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.4));
                break;
            }
            case 5: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.6));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public final double autoResizePercentage(double width, double height) {
        return width >= 1920.0 || height >= 1920.0 ? 0.5 : (width >= 1280.0 || height >= 1280.0 ? 0.75 : (width >= 960.0 || height >= 960.0 ? 0.95 : 0.9));
    }

    public final boolean hasQTI() {
        MediaCodecInfo[] list = new MediaCodecList(0).getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        for (MediaCodecInfo codec : list) {
            Log.i((String)"CODECS: ", (String)codec.getName());
            String string = codec.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codec.name");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"qti.avc", (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final int getHighestCodecProfileLevel(String type) {
        if (type == null) {
            return 1;
        }
        list = new MediaCodecList(0).getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        var4_3 = list;
        $i$f$filter = false;
        var6_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Iterator<T> element$iv$iv : $this$filterTo$iv$iv) {
            codec = element$iv$iv;
            $i$a$-filter-CompressorUtils$getHighestCodecProfileLevel$capabilities$1 = false;
            v0 = codec.getSupportedTypes();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"codec.supportedTypes");
            if (!ArraysKt.contains((Object[])v0, (Object)type)) ** GOTO lbl-1000
            v1 = codec.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"codec.name");
            if (StringsKt.contains$default((CharSequence)v1, (CharSequence)"encoder", (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        element$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv.hasNext()) {
            element$iv$iv = element$iv$iv$iv /* !! */  = element$iv$iv.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            codec = (MediaCodecInfo)element$iv$iv;
            $i$a$-mapNotNull-CompressorUtils$getHighestCodecProfileLevel$capabilities$2 = false;
            if (codec.getCapabilitiesForType(type) == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        capabilities = (List)destination$iv$iv;
        $this$forEach$iv = capabilities;
        $i$f$forEach = false;
        var6_5 = $this$forEach$iv.iterator();
        if (var6_5.hasNext()) {
            element$iv = var6_5.next();
            capabilitiesForType = (MediaCodecInfo.CodecCapabilities)element$iv;
            $i$a$-forEach-CompressorUtils$getHighestCodecProfileLevel$1 = false;
            Intrinsics.checkNotNullExpressionValue((Object)capabilitiesForType.profileLevels, (String)"capabilitiesForType.profileLevels");
            $this$map$iv = capabilitiesForType.profileLevels;
            $i$f$map = false;
            element$iv$iv$iv /* !! */  = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = (MediaCodecInfo.CodecProfileLevel)item$iv$iv;
                var19_28 = destination$iv$iv;
                $i$a$-map-CompressorUtils$getHighestCodecProfileLevel$1$levels$1 = false;
                var19_28.add(it.profile);
            }
            levels = (List)destination$iv$iv;
            return levels.contains(8) != false ? 8 : (levels.contains(2) != false ? 2 : 1);
        }
        return 1;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoQuality.values().length];
            try {
                nArray[VideoQuality.VERY_LOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoQuality.LOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoQuality.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoQuality.HIGH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoQuality.VERY_HIGH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

