/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary.utils;

import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.abedelazizshe.lightcompressorlibrary.VideoQuality;
import com.abedelazizshe.lightcompressorlibrary.utils.NumbersUtilsKt;
import com.abedelazizshe.lightcompressorlibrary.video.Mp4Movie;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0003\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0003\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0003\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u0012\u0010$\u001a\u00020%2\n\u0010&\u001a\u00060'j\u0002`(J-\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010-J\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u000202J&\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u0001062\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u000104R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/utils/CompressorUtils;", "", "()V", "I_FRAME_INTERVAL", "", "MIN_HEIGHT", "", "MIN_WIDTH", "findTrack", "extractor", "Landroid/media/MediaExtractor;", "isVideo", "", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "getBitrate", "bitrate", "quality", "Lcom/abedelazizshe/lightcompressorlibrary/VideoQuality;", "getColorRange", "format", "Landroid/media/MediaFormat;", "(Landroid/media/MediaFormat;)Ljava/lang/Integer;", "getColorStandard", "getColorTransfer", "getFrameRate", "frameRate", "(Landroid/media/MediaFormat;Ljava/lang/Integer;)I", "getIFrameIntervalRate", "hasQTI", "prepareVideoHeight", "mediaMetadataRetriever", "Landroid/media/MediaMetadataRetriever;", "prepareVideoWidth", "printException", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "setOutputFileParameters", "inputFormat", "outputFormat", "newBitrate", "(Landroid/media/MediaFormat;Landroid/media/MediaFormat;ILjava/lang/Integer;)V", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/video/Mp4Movie;", "rotation", "cacheFile", "Ljava/io/File;", "validateInputs", "", "context", "Landroid/content/Context;", "srcUri", "Landroid/net/Uri;", "srcPath", "lightcompressor_release"})
public final class CompressorUtils {
    @NotNull
    public static final CompressorUtils INSTANCE = new CompressorUtils();
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 368.0;
    private static final int I_FRAME_INTERVAL = 10;

    private CompressorUtils() {
    }

    @Nullable
    public final String validateInputs(@Nullable Context context, @Nullable Uri srcUri, @Nullable String srcPath) {
        if (srcPath != null && srcUri != null) {
            Log.w((String)"Compressor", (String)"ARE YOU SURE YOU WANT TO PASS BOTH srcPath AND srcUri?");
        }
        if (context == null && srcPath == null && srcUri == null) {
            return "You need to provide either a srcUri or a srcPath";
        }
        if (context == null && srcPath == null && srcUri != null) {
            return "You need to provide the application context";
        }
        return null;
    }

    public final double prepareVideoWidth(@NotNull MediaMetadataRetriever mediaMetadataRetriever) {
        double d;
        Intrinsics.checkNotNullParameter((Object)mediaMetadataRetriever, (String)"mediaMetadataRetriever");
        String widthData = mediaMetadataRetriever.extractMetadata(18);
        CharSequence charSequence = widthData;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            d = 368.0;
        } else {
            charSequence = widthData;
            bl = false;
            d = Double.parseDouble((String)charSequence);
        }
        return d;
    }

    public final double prepareVideoHeight(@NotNull MediaMetadataRetriever mediaMetadataRetriever) {
        double d;
        Intrinsics.checkNotNullParameter((Object)mediaMetadataRetriever, (String)"mediaMetadataRetriever");
        String heightData = mediaMetadataRetriever.extractMetadata(19);
        CharSequence charSequence = heightData;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            d = 640.0;
        } else {
            charSequence = heightData;
            bl = false;
            d = Double.parseDouble((String)charSequence);
        }
        return d;
    }

    @NotNull
    public final Mp4Movie setUpMP4Movie(int rotation, @NotNull File cacheFile) {
        Mp4Movie movie;
        Intrinsics.checkNotNullParameter((Object)cacheFile, (String)"cacheFile");
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$setUpMP4Movie_u24lambda_u2d0 = mp4Movie;
        boolean bl3 = false;
        $this$setUpMP4Movie_u24lambda_u2d0.setCacheFile(cacheFile);
        $this$setUpMP4Movie_u24lambda_u2d0.setRotation(rotation);
        return movie;
    }

    public final void setOutputFileParameters(@NotNull MediaFormat inputFormat, @NotNull MediaFormat outputFormat, int newBitrate, @Nullable Integer frameRate) {
        Intrinsics.checkNotNullParameter((Object)inputFormat, (String)"inputFormat");
        Intrinsics.checkNotNullParameter((Object)outputFormat, (String)"outputFormat");
        int newFrameRate = this.getFrameRate(inputFormat, frameRate);
        int iFrameInterval = this.getIFrameIntervalRate(inputFormat);
        MediaFormat mediaFormat = outputFormat;
        boolean bl = false;
        boolean bl2 = false;
        MediaFormat $this$setOutputFileParameters_u24lambda_u2d4 = mediaFormat;
        boolean bl3 = false;
        $this$setOutputFileParameters_u24lambda_u2d4.setInteger("color-format", 2130708361);
        $this$setOutputFileParameters_u24lambda_u2d4.setInteger("frame-rate", newFrameRate);
        $this$setOutputFileParameters_u24lambda_u2d4.setInteger("i-frame-interval", iFrameInterval);
        $this$setOutputFileParameters_u24lambda_u2d4.setInteger("bitrate", newBitrate);
        if (Build.VERSION.SDK_INT > 23) {
            int it;
            boolean bl4;
            boolean bl5;
            Integer n;
            Integer n2 = INSTANCE.getColorStandard(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl6 = false;
                $this$setOutputFileParameters_u24lambda_u2d4.setInteger("color-standard", it);
            }
            n2 = INSTANCE.getColorTransfer(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl7 = false;
                $this$setOutputFileParameters_u24lambda_u2d4.setInteger("color-transfer", it);
            }
            n2 = INSTANCE.getColorRange(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl8 = false;
                $this$setOutputFileParameters_u24lambda_u2d4.setInteger("color-range", it);
            }
        }
        Log.i((String)"Output file parameters", (String)Intrinsics.stringPlus((String)"videoFormat: ", (Object)$this$setOutputFileParameters_u24lambda_u2d4));
    }

    private final int getFrameRate(MediaFormat format, Integer frameRate) {
        if (frameRate != null) {
            return frameRate;
        }
        return format.containsKey("frame-rate") ? format.getInteger("frame-rate") : 30;
    }

    private final int getIFrameIntervalRate(MediaFormat format) {
        return format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 10;
    }

    @RequiresApi(value=24)
    private final Integer getColorStandard(MediaFormat format) {
        return format.containsKey("color-standard") ? Integer.valueOf(format.getInteger("color-standard")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorTransfer(MediaFormat format) {
        return format.containsKey("color-transfer") ? Integer.valueOf(format.getInteger("color-transfer")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorRange(MediaFormat format) {
        return format.containsKey("color-range") ? Integer.valueOf(format.getInteger("color-range")) : null;
    }

    public final int findTrack(@NotNull MediaExtractor extractor, boolean isVideo) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        int numTracks = extractor.getTrackCount();
        int n = 0;
        if (n < numTracks) {
            do {
                String string;
                int i = n++;
                MediaFormat mediaFormat = extractor.getTrackFormat(i);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(i)");
                MediaFormat format = mediaFormat;
                String mime = format.getString("mime");
                if (isVideo) {
                    string = mime;
                    Boolean bl = string == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null));
                    Intrinsics.checkNotNull(bl);
                    if (!bl.booleanValue()) continue;
                    return i;
                }
                string = mime;
                Boolean bl = string == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null));
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) continue;
                return i;
            } while (n < numTracks);
        }
        return -5;
    }

    public final void printException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String message = null;
        message = "An error has occurred!";
        String string = exception.getLocalizedMessage();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            message = it;
        }
        Log.e((String)"Compressor", (String)message, (Throwable)exception);
    }

    public final int getBitrate(int bitrate, @NotNull VideoQuality quality) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)quality), (String)"quality");
        VideoQuality videoQuality = quality;
        int n2 = WhenMappings.$EnumSwitchMapping$0[videoQuality.ordinal()];
        switch (n2) {
            case 1: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.1));
                break;
            }
            case 2: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.2));
                break;
            }
            case 3: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.3));
                break;
            }
            case 4: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.4));
                break;
            }
            case 5: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.6));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @NotNull
    public final Pair<Integer, Integer> generateWidthAndHeight(double width, double height) {
        int newWidth = 0;
        int newHeight = 0;
        if (width >= 1920.0 || height >= 1920.0) {
            newWidth = NumbersUtilsKt.generateWidthHeightValue(width, 0.5);
            newHeight = NumbersUtilsKt.generateWidthHeightValue(height, 0.5);
        } else if (width >= 1280.0 || height >= 1280.0) {
            newWidth = NumbersUtilsKt.generateWidthHeightValue(width, 0.75);
            newHeight = NumbersUtilsKt.generateWidthHeightValue(height, 0.75);
        } else if (width >= 960.0 || height >= 960.0) {
            newWidth = NumbersUtilsKt.generateWidthHeightValue(width, 0.95);
            newHeight = NumbersUtilsKt.generateWidthHeightValue(height, 0.95);
        } else {
            newWidth = NumbersUtilsKt.generateWidthHeightValue(width, 0.9);
            newHeight = NumbersUtilsKt.generateWidthHeightValue(height, 0.9);
        }
        return new Pair((Object)newWidth, (Object)newHeight);
    }

    public final boolean hasQTI() {
        MediaCodecInfo[] list = new MediaCodecList(0).getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        for (MediaCodecInfo codec : list) {
            Log.i((String)"CODECS: ", (String)codec.getName());
            String string = codec.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codec.name");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"qti.avc", (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoQuality.values().length];
            nArray[VideoQuality.VERY_LOW.ordinal()] = 1;
            nArray[VideoQuality.LOW.ordinal()] = 2;
            nArray[VideoQuality.MEDIUM.ordinal()] = 3;
            nArray[VideoQuality.HIGH.ordinal()] = 4;
            nArray[VideoQuality.VERY_HIGH.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

