/*
 * Decompiled with CFR 0.152.
 */
package com.mp4parser.iso14496.part30;

import com.coremedia.iso.Utf8;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.util.CastUtils;
import com.mp4parser.iso14496.part30.WebVTTConfigurationBox;
import com.mp4parser.iso14496.part30.WebVTTSampleEntry;
import com.mp4parser.iso14496.part30.WebVTTSourceLabelBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebVTTTrack
extends AbstractTrack {
    String[] subs;
    List<Sample> samples = new ArrayList<Sample>();
    WebVTTSampleEntry sampleEntry = new WebVTTSampleEntry();

    public WebVTTTrack(DataSource dataSource) throws IOException {
        super(dataSource.toString());
        this.sampleEntry.addBox(new WebVTTConfigurationBox());
        this.sampleEntry.addBox(new WebVTTSourceLabelBox());
        ByteBuffer bb = dataSource.map(0L, CastUtils.l2i(dataSource.size()));
        byte[] content = new byte[CastUtils.l2i(dataSource.size())];
        bb.get(content);
        this.subs = Utf8.convert(content).split("\\r?\\n");
        String config = "";
        int i = 0;
        while (i < this.subs.length) {
            config = String.valueOf(config) + this.subs[i] + "\n";
            if (this.subs[i + 1].isEmpty() && this.subs[i + 2].isEmpty()) break;
            ++i;
        }
        while (i < this.subs.length) {
            if (!this.subs[i].isEmpty()) break;
            ++i;
        }
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return null;
    }

    @Override
    public long[] getSampleDurations() {
        return new long[0];
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return null;
    }

    @Override
    public String getHandler() {
        return null;
    }

    @Override
    public List<Sample> getSamples() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

