/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public class UUIDConverter {
    public static byte[] convert(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        int i = 0;
        while (i < 8) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
            ++i;
        }
        i = 8;
        while (i < 16) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
            ++i;
        }
        return buffer;
    }

    public static UUID convert(byte[] uuidBytes) {
        ByteBuffer b = ByteBuffer.wrap(uuidBytes);
        b.order(ByteOrder.BIG_ENDIAN);
        return new UUID(b.getLong(), b.getLong());
    }
}

