/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework.javax;

import apijson.JSON;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.column.ColumnUtil;
import apijson.framework.javax.APIJSONSQLConfig;
import apijson.orm.AbstractSQLExecutor;
import apijson.orm.SQLConfig;
import com.alibaba.fastjson.JSONObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.postgresql.util.PGobject;

public class APIJSONSQLExecutor<T>
extends AbstractSQLExecutor<T> {
    public static final String TAG = "APIJSONSQLExecutor";

    public PreparedStatement setArgument(@NotNull SQLConfig<T> config, @NotNull PreparedStatement statement, int index, Object value) throws SQLException {
        if (config.isPostgreSQL() && !JSON.isBooleanOrNumberOrString((Object)value)) {
            PGobject o = new PGobject();
            o.setType("jsonb");
            o.setValue(value == null ? null : value.toString());
            statement.setObject(index + 1, o);
            return statement;
        }
        return super.setArgument(config, statement, index, value);
    }

    protected Object getValue(SQLConfig<T> config, ResultSet rs, ResultSetMetaData rsmd, int tablePosition, JSONObject table, int columnIndex, String lable, Map<String, JSONObject> childMap) throws Exception {
        Object value = super.getValue(config, rs, rsmd, tablePosition, table, columnIndex, lable, childMap);
        return value instanceof PGobject ? JSON.parse((Object)((PGobject)value).getValue()) : value;
    }

    protected String getKey(SQLConfig<T> config, ResultSet rs, ResultSetMetaData rsmd, int tablePosition, JSONObject table, int columnIndex, Map<String, JSONObject> childMap) throws Exception {
        String key = super.getKey(config, rs, rsmd, tablePosition, table, columnIndex, childMap);
        if (APIJSONSQLConfig.ENABLE_COLUMN_CONFIG) {
            return ColumnUtil.compatOutputKey((String)key, (String)config.getTable(), (RequestMethod)config.getMethod());
        }
        return key;
    }

    static {
        try {
            Log.d((String)TAG, (String)"\u5c1d\u8bd5\u52a0\u8f7d MySQL 8 \u9a71\u52a8 <<<<<<<<<<<<<<<<<<<<< ");
            Class.forName("com.mysql.cj.jdbc.Driver");
            Log.d((String)TAG, (String)"\u6210\u529f\u52a0\u8f7d MySQL 8 \u9a71\u52a8\uff01>>>>>>>>>>>>>>>>>>>>>");
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"\u52a0\u8f7d MySQL 8 \u9a71\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 pom.xml \u4e2d mysql-connector-java \u7248\u672c\u662f\u5426\u5b58\u5728\u4ee5\u53ca\u53ef\u7528 \uff01\uff01\uff01");
            e.printStackTrace();
            try {
                Log.d((String)TAG, (String)"\u5c1d\u8bd5\u52a0\u8f7d MySQL 7 \u53ca\u4ee5\u4e0b\u7248\u672c\u7684 \u9a71\u52a8 <<<<<<<<<<<<<<<<<<<<< ");
                Class.forName("com.mysql.jdbc.Driver");
                Log.d((String)TAG, (String)"\u6210\u529f\u52a0\u8f7d MySQL 7 \u53ca\u4ee5\u4e0b\u7248\u672c\u7684 \u9a71\u52a8\uff01>>>>>>>>>>>>>>>>>>>>> ");
            }
            catch (ClassNotFoundException e2) {
                Log.e((String)TAG, (String)"\u52a0\u8f7d MySQL 7 \u53ca\u4ee5\u4e0b\u7248\u672c\u7684 \u9a71\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 pom.xml \u4e2d mysql-connector-java \u7248\u672c\u662f\u5426\u5b58\u5728\u4ee5\u53ca\u53ef\u7528 \uff01\uff01\uff01");
                e2.printStackTrace();
            }
        }
        try {
            Log.d((String)TAG, (String)"\u5c1d\u8bd5\u52a0\u8f7d PostgresSQL \u9a71\u52a8 <<<<<<<<<<<<<<<<<<<<< ");
            Class.forName("org.postgresql.Driver");
            Log.d((String)TAG, (String)"\u6210\u529f\u52a0\u8f7d PostgresSQL \u9a71\u52a8\uff01>>>>>>>>>>>>>>>>>>>>> ");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"\u52a0\u8f7d PostgresSQL \u9a71\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 libs \u76ee\u5f55\u4e2d postgresql.jar \u7248\u672c\u662f\u5426\u5b58\u5728\u4ee5\u53ca\u53ef\u7528 \uff01\uff01\uff01");
        }
    }
}

