/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.Log;
import apijson.NotNull;
import apijson.framework.APIJSONController;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONFunctionParser;
import apijson.framework.APIJSONParser;
import apijson.framework.APIJSONSQLConfig;
import apijson.framework.APIJSONVerifier;
import apijson.orm.AbstractFunctionParser;
import apijson.orm.script.ScriptExecutor;
import java.rmi.ServerException;

public class APIJSONApplication {
    public static final String TAG = "APIJSONApplication";
    @NotNull
    public static APIJSONCreator<? extends Object> DEFAULT_APIJSON_CREATOR = new APIJSONCreator();

    public static void init() throws Exception {
        APIJSONApplication.init(true, DEFAULT_APIJSON_CREATOR);
    }

    public static void init(boolean shutdownWhenServerError) throws Exception {
        APIJSONApplication.init(shutdownWhenServerError, DEFAULT_APIJSON_CREATOR);
    }

    public static <T> void init(@NotNull APIJSONCreator<T> creator) throws Exception {
        APIJSONApplication.init(true, creator);
    }

    public static <T> void init(boolean shutdownWhenServerError, @NotNull APIJSONCreator<T> creator) throws Exception {
        System.out.println("\n\n\n\n\n<<<<<<<<<<<<<<<<<<<<<<<<< APIJSON \u5f00\u59cb\u542f\u52a8 >>>>>>>>>>>>>>>>>>>>>>>>\n");
        DEFAULT_APIJSON_CREATOR = creator;
        APIJSONSQLConfig.APIJSON_CREATOR = creator;
        APIJSONParser.APIJSON_CREATOR = creator;
        APIJSONController.APIJSON_CREATOR = creator;
        if (APIJSONVerifier.ENABLE_VERIFY_ROLE) {
            block13: {
                System.out.println("\n\n\n\u5f00\u59cb\u521d\u59cb\u5316: Access \u6743\u9650\u6821\u9a8c\u914d\u7f6e <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
                try {
                    APIJSONVerifier.initAccess(shutdownWhenServerError, creator);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (!shutdownWhenServerError) break block13;
                    APIJSONApplication.onServerError("\u6743Access \u9650\u6821\u9a8c\u914d\u7f6e \u521d\u59cb\u5316\u5931\u8d25\uff01", shutdownWhenServerError);
                }
            }
            System.out.println("\n\u5b8c\u6210\u521d\u59cb\u5316: Access \u6743\u9650\u6821\u9a8c\u914d\u7f6e >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        if (APIJSONFunctionParser.ENABLE_REMOTE_FUNCTION) {
            block15: {
                block14: {
                    System.out.println("\n\n\n\u5f00\u59cb\u521d\u59cb\u5316: Function \u8fdc\u7a0b\u51fd\u6570\u914d\u7f6e <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
                    try {
                        APIJSONFunctionParser.init(shutdownWhenServerError, creator);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        if (!shutdownWhenServerError) break block14;
                        APIJSONApplication.onServerError("Function \u8fdc\u7a0b\u51fd\u6570\u914d\u7f6e \u521d\u59cb\u5316\u5931\u8d25\uff01", shutdownWhenServerError);
                    }
                }
                System.out.println("\n\u5b8c\u6210\u521d\u59cb\u5316: Function \u8fdc\u7a0b\u51fd\u6570\u914d\u7f6e >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                System.out.println("\u5f00\u59cb\u6d4b\u8bd5: Function \u8fdc\u7a0b\u51fd\u6570 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
                try {
                    APIJSONFunctionParser.test();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (!shutdownWhenServerError) break block15;
                    APIJSONApplication.onServerError("Function \u8fdc\u7a0b\u51fd\u6570\u914d\u7f6e \u6d4b\u8bd5\u5931\u8d25\uff01", shutdownWhenServerError);
                }
            }
            System.out.println("\n\u5b8c\u6210\u6d4b\u8bd5: Function \u8fdc\u7a0b\u51fd\u6570 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        if (APIJSONVerifier.ENABLE_VERIFY_CONTENT) {
            block17: {
                block16: {
                    System.out.println("\n\n\n\u5f00\u59cb\u521d\u59cb\u5316: Request \u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u914d\u7f6e <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
                    try {
                        APIJSONVerifier.initRequest(shutdownWhenServerError, creator);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        if (!shutdownWhenServerError) break block16;
                        APIJSONApplication.onServerError("Request \u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u914d\u7f6e \u521d\u59cb\u5316\u5931\u8d25\uff01", shutdownWhenServerError);
                    }
                }
                System.out.println("\n\u5b8c\u6210\u521d\u59cb\u5316: Request \u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u6821\u9a8c\u914d\u7f6e >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                System.out.println("\n\n\n\u5f00\u59cb\u6d4b\u8bd5: Request \u8bf7\u6c42\u53c2\u6570\u6821\u9a8c <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
                try {
                    APIJSONVerifier.testStructure();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (!shutdownWhenServerError) break block17;
                    APIJSONApplication.onServerError("Request \u8bf7\u6c42\u53c2\u6570\u6821\u9a8c \u6d4b\u8bd5\u5931\u8d25\uff01", shutdownWhenServerError);
                }
            }
            System.out.println("\n\u5b8c\u6210\u6d4b\u8bd5: Request \u8bf7\u6c42\u53c2\u6570\u6821\u9a8c >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        System.out.println("\u5b98\u65b9\u7f51\u7ad9\uff1a http://apijson.cn");
        System.out.println("\u8bbe\u8ba1\u89c4\u8303\uff1a https://github.com/Tencent/APIJSON/blob/master/Document.md#3");
        System.out.println("\u6d4b\u8bd5\u94fe\u63a5\uff1a http://apijson.cn/api?type=JSON&url=http://localhost:8080/get");
        System.out.println("\n\n<<<<<<<<<<<<<<<<<<<<<<<<< APIJSON \u542f\u52a8\u5b8c\u6210\uff0c\u8bd5\u8bd5\u8c03\u7528\u96f6\u4ee3\u7801\u4e07\u80fd\u901a\u7528 API \u5427 ^_^ >>>>>>>>>>>>>>>>>>>>>>>>\n");
    }

    protected static void onServerError(String msg, boolean shutdown) throws ServerException {
        Log.e((String)TAG, (String)("\n\u542f\u52a8\u65f6\u81ea\u68c0\u6d4b\u8bd5\u672a\u901a\u8fc7\uff01\u539f\u56e0\uff1a\n" + msg));
        if (!shutdown) {
            throw new ServerException(msg);
        }
        System.exit(1);
    }

    public static void addScriptExecutor(String language, ScriptExecutor scriptExecutor) {
        scriptExecutor.init();
        AbstractFunctionParser.SCRIPT_EXECUTOR_MAP.put(language, scriptExecutor);
    }
}

