/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.JSON;
import apijson.JSONObject;
import apijson.JSONResponse;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.RequestRole;
import apijson.StringUtil;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONParser;
import apijson.framework.APIJSONSQLConfig;
import apijson.orm.AbstractVerifier;
import apijson.orm.JSONRequest;
import apijson.orm.SQLCreator;
import apijson.orm.Visitor;
import com.alibaba.fastjson.JSONArray;
import java.rmi.ServerException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;

public class APIJSONVerifier
extends AbstractVerifier<Long> {
    public static final String TAG = "APIJSONVerifier";
    public static APIJSONCreator APIJSON_CREATOR = new APIJSONCreator();
    static final String requestString = "{\"Comment\":{\"REFUSE\": \"id\", \"MUST\": \"userId,momentId,content\"}, \"INSERT\":{\"Comment:to\":{}}}";
    static final String responseString = "{\"User\":{\"REMOVE\": \"phone\", \"REPLACE\":{\"sex\":2}, \"INSERT\":{\"name\":\"api\"}}, \"UPDATE\":{\"Comment:to\":{}}}";

    public static com.alibaba.fastjson.JSONObject init() throws ServerException {
        return APIJSONVerifier.init(false);
    }

    public static com.alibaba.fastjson.JSONObject init(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONVerifier.init(shutdownWhenServerError, null);
    }

    public static com.alibaba.fastjson.JSONObject init(APIJSONCreator creator) throws ServerException {
        return APIJSONVerifier.init(false, creator);
    }

    public static com.alibaba.fastjson.JSONObject init(boolean shutdownWhenServerError, APIJSONCreator creator) throws ServerException {
        com.alibaba.fastjson.JSONObject result = new com.alibaba.fastjson.JSONObject(true);
        result.put(APIJSONConstant.ACCESS_, (Object)APIJSONVerifier.initAccess(shutdownWhenServerError, creator));
        result.put(APIJSONConstant.REQUEST_, (Object)APIJSONVerifier.initRequest(shutdownWhenServerError, creator));
        return result;
    }

    public static com.alibaba.fastjson.JSONObject initAccess() throws ServerException {
        return APIJSONVerifier.initAccess(false);
    }

    public static com.alibaba.fastjson.JSONObject initAccess(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONVerifier.initAccess(shutdownWhenServerError, null);
    }

    public static com.alibaba.fastjson.JSONObject initAccess(APIJSONCreator creator) throws ServerException {
        return APIJSONVerifier.initAccess(false, creator);
    }

    public static com.alibaba.fastjson.JSONObject initAccess(boolean shutdownWhenServerError, APIJSONCreator creator) throws ServerException {
        return APIJSONVerifier.initAccess(shutdownWhenServerError, creator, null);
    }

    public static com.alibaba.fastjson.JSONObject initAccess(boolean shutdownWhenServerError, APIJSONCreator creator, com.alibaba.fastjson.JSONObject table) throws ServerException {
        JSONArray list;
        int size;
        com.alibaba.fastjson.JSONObject access;
        if (creator == null) {
            creator = APIJSON_CREATOR;
        }
        APIJSON_CREATOR = creator;
        boolean isAll = table == null || table.isEmpty();
        Object object = access = isAll ? new JSONRequest() : table;
        if (!Log.DEBUG) {
            access.put("debug", (Object)0);
        }
        JSONRequest accessItem = new JSONRequest();
        accessItem.put(APIJSONConstant.ACCESS_, (Object)access);
        JSONRequest request = new JSONRequest();
        request.putAll((Map)accessItem.toArray(0, 0, APIJSONConstant.ACCESS_));
        com.alibaba.fastjson.JSONObject response = creator.createParser().setMethod(RequestMethod.GET).setNeedVerify(false).parseResponse((com.alibaba.fastjson.JSONObject)request);
        if (!JSONResponse.isSuccess((com.alibaba.fastjson.JSONObject)response)) {
            Log.e((String)TAG, (String)("\n\n\n\n\n !!!! \u67e5\u8be2\u6743\u9650\u914d\u7f6e\u5f02\u5e38 !!!\n" + response.getString("msg") + "\n\n\n\n\n"));
            APIJSONVerifier.onServerError("\u67e5\u8be2\u6743\u9650\u914d\u7f6e\u5f02\u5e38 !", shutdownWhenServerError);
        }
        int n = size = (list = response.getJSONArray(APIJSONConstant.ACCESS_ + "[]")) == null ? 0 : list.size();
        if (isAll && size <= 0) {
            Log.w((String)TAG, (String)"initAccess isAll && size <= 0\uff0c\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u6743\u9650\u914d\u7f6e");
            throw new NullPointerException("\u6ca1\u6709\u53ef\u7528\u7684\u6743\u9650\u914d\u7f6e");
        }
        Log.d((String)TAG, (String)("initAccess < for ACCESS_MAP.size() = " + ACCESS_MAP.size() + " <<<<<<<<<<<<<<<<<<<<<<<<"));
        if (isAll) {
            ACCESS_MAP.clear();
        }
        for (int i = 0; i < size; ++i) {
            com.alibaba.fastjson.JSONObject item = list.getJSONObject(i);
            if (item == null) continue;
            HashMap<RequestMethod, Object> map = new HashMap<RequestMethod, Object>();
            map.put(RequestMethod.GET, JSON.parseObject((String)item.getString("get"), RequestRole[].class));
            map.put(RequestMethod.HEAD, JSON.parseObject((String)item.getString("head"), RequestRole[].class));
            map.put(RequestMethod.GETS, JSON.parseObject((String)item.getString("gets"), RequestRole[].class));
            map.put(RequestMethod.HEADS, JSON.parseObject((String)item.getString("heads"), RequestRole[].class));
            map.put(RequestMethod.POST, JSON.parseObject((String)item.getString("post"), RequestRole[].class));
            map.put(RequestMethod.PUT, JSON.parseObject((String)item.getString("put"), RequestRole[].class));
            map.put(RequestMethod.DELETE, JSON.parseObject((String)item.getString("delete"), RequestRole[].class));
            String name = item.getString("name");
            String alias = item.getString("alias");
            if (StringUtil.isEmpty((String)name, (boolean)true)) {
                APIJSONVerifier.onServerError("\u5b57\u6bb5 name \u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            if (StringUtil.isEmpty((String)alias, (boolean)true)) {
                if (!JSONRequest.isTableKey((String)name)) {
                    APIJSONVerifier.onServerError("name: " + name + "\u4e0d\u5408\u6cd5\uff01\u5b57\u6bb5 alias \u7684\u503c\u4e3a\u7a7a\u65f6\uff0cname \u5fc5\u987b\u4e3a\u5408\u6cd5\u8868\u540d\uff01", shutdownWhenServerError);
                }
                ACCESS_MAP.put(name, map);
            } else {
                if (!JSONRequest.isTableKey((String)alias)) {
                    APIJSONVerifier.onServerError("alias: " + alias + "\u4e0d\u5408\u6cd5\uff01\u5b57\u6bb5 alias \u7684\u503c\u53ea\u80fd\u4e3a \u7a7a \u6216\u8005 \u5408\u6cd5\u8868\u540d\uff01", shutdownWhenServerError);
                }
                ACCESS_MAP.put(alias, map);
            }
            APIJSONSQLConfig.TABLE_KEY_MAP.put(alias, name);
        }
        Log.d((String)TAG, (String)("initAccess  for /> ACCESS_MAP.size() = " + ACCESS_MAP.size() + " >>>>>>>>>>>>>>>>>>>>>>>"));
        return response;
    }

    public static com.alibaba.fastjson.JSONObject initRequest() throws ServerException {
        return APIJSONVerifier.initRequest(false);
    }

    public static com.alibaba.fastjson.JSONObject initRequest(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONVerifier.initRequest(shutdownWhenServerError, null);
    }

    public static com.alibaba.fastjson.JSONObject initRequest(APIJSONCreator creator) throws ServerException {
        return APIJSONVerifier.initRequest(false, creator);
    }

    public static com.alibaba.fastjson.JSONObject initRequest(boolean shutdownWhenServerError, APIJSONCreator creator) throws ServerException {
        return APIJSONVerifier.initRequest(shutdownWhenServerError, creator, null);
    }

    public static com.alibaba.fastjson.JSONObject initRequest(boolean shutdownWhenServerError, APIJSONCreator creator, com.alibaba.fastjson.JSONObject table) throws ServerException {
        JSONArray list;
        int size;
        if (creator == null) {
            creator = APIJSON_CREATOR;
        }
        APIJSON_CREATOR = creator;
        boolean isAll = table == null || table.isEmpty();
        JSONRequest requestItem = new JSONRequest();
        requestItem.put(APIJSONConstant.REQUEST_, isAll ? new JSONRequest().setOrder("version-,id+") : table);
        JSONRequest request = new JSONRequest();
        request.putAll((Map)requestItem.toArray(0, 0, APIJSONConstant.REQUEST_));
        com.alibaba.fastjson.JSONObject response = creator.createParser().setMethod(RequestMethod.GET).setNeedVerify(false).parseResponse((com.alibaba.fastjson.JSONObject)request);
        if (!JSONResponse.isSuccess((com.alibaba.fastjson.JSONObject)response)) {
            Log.e((String)TAG, (String)("\n\n\n\n\n !!!! \u67e5\u8be2\u6743\u9650\u914d\u7f6e\u5f02\u5e38 !!!\n" + response.getString("msg") + "\n\n\n\n\n"));
            APIJSONVerifier.onServerError("\u67e5\u8be2\u6743\u9650\u914d\u7f6e\u5f02\u5e38 !", shutdownWhenServerError);
        }
        int n = size = (list = response.getJSONArray(APIJSONConstant.REQUEST_ + "[]")) == null ? 0 : list.size();
        if (isAll && size <= 0) {
            Log.w((String)TAG, (String)"initRequest isAll && size <= 0\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u6743\u9650\u914d\u7f6e");
            throw new NullPointerException("\u6ca1\u6709\u53ef\u7528\u7684\u6743\u9650\u914d\u7f6e");
        }
        Log.d((String)TAG, (String)("initRequest < for REQUEST_MAP.size() = " + REQUEST_MAP.size() + " <<<<<<<<<<<<<<<<<<<<<<<<"));
        if (isAll) {
            REQUEST_MAP.clear();
        }
        for (int i = 0; i < size; ++i) {
            String cacheKey;
            TreeMap<Integer, com.alibaba.fastjson.JSONObject> versionedMap;
            String tag;
            String method;
            com.alibaba.fastjson.JSONObject item = list.getJSONObject(i);
            if (item == null) continue;
            String version = item.getString("version");
            if (StringUtil.isEmpty((String)version, (boolean)true)) {
                Log.e((String)TAG, (String)"initRequest  for  StringUtil.isEmpty(version, true)\uff0cRequest \u8868\u4e2d\u7684 version \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                APIJSONVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cRequest \u8868\u4e2d\u7684 version \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            if (StringUtil.isEmpty((String)(method = item.getString("method")), (boolean)true)) {
                Log.e((String)TAG, (String)"initRequest  for  StringUtil.isEmpty(method, true)\uff0cRequest \u8868\u4e2d\u7684 method \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                APIJSONVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cRequest \u8868\u4e2d\u7684 method \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            if (StringUtil.isEmpty((String)(tag = item.getString("tag")), (boolean)true)) {
                Log.e((String)TAG, (String)"initRequest  for  StringUtil.isEmpty(tag, true)\uff0cRequest \u8868\u4e2d\u7684 tag \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                APIJSONVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cRequest \u8868\u4e2d\u7684 tag \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            com.alibaba.fastjson.JSONObject structure = JSON.parseObject((String)item.getString("structure"));
            com.alibaba.fastjson.JSONObject target = null;
            if (structure != null) {
                target = structure;
                if (!structure.containsKey((Object)tag)) {
                    String key;
                    boolean isArrayKey = tag.endsWith(":[]");
                    String string = key = isArrayKey ? tag.substring(0, tag.length() - 3) : tag;
                    if (JSONObject.isTableKey((String)key)) {
                        if (isArrayKey) {
                            target.put(key + "[]", (Object)new JSONArray());
                        } else {
                            target = new com.alibaba.fastjson.JSONObject(true);
                            target.put(tag, (Object)structure);
                        }
                    }
                }
            }
            if (target == null || target.isEmpty()) {
                Log.e((String)TAG, (String)"initRequest  for  target == null || target.isEmpty()");
                APIJSONVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cRequest \u8868\u4e2d\u7684 version = " + version + ", method = " + method + ", tag = " + tag + " \u5bf9\u5e94\u7684 structure \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            if ((versionedMap = (TreeMap<Integer, com.alibaba.fastjson.JSONObject>)REQUEST_MAP.get(cacheKey = APIJSONVerifier.getCacheKeyForRequest((String)method, (String)tag))) == null) {
                versionedMap = new TreeMap<Integer, com.alibaba.fastjson.JSONObject>(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o2 == null ? -1 : o2.compareTo(o1);
                    }
                });
            }
            versionedMap.put(Integer.valueOf(version), item);
            REQUEST_MAP.put(cacheKey, versionedMap);
        }
        Log.d((String)TAG, (String)("initRequest  for /> REQUEST_MAP.size() = " + REQUEST_MAP.size() + " >>>>>>>>>>>>>>>>>>>>>>>"));
        return response;
    }

    public static void test() {
        APIJSONVerifier.testStructure();
    }

    public static void testStructure() {
        com.alibaba.fastjson.JSONObject response;
        com.alibaba.fastjson.JSONObject request;
        try {
            request = JSON.parseObject((String)"{\"Comment\":{\"userId\":0}}");
            Log.d((String)TAG, (String)("test  verifyRequest = " + AbstractVerifier.verifyRequest((RequestMethod)RequestMethod.POST, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)requestString), (com.alibaba.fastjson.JSONObject)request, (SQLCreator)APIJSON_CREATOR)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            request = JSON.parseObject((String)"{\"Comment\":{\"userId\":0, \"momentId\":0, \"content\":\"apijson\"}}");
            Log.d((String)TAG, (String)("test  verifyRequest = " + AbstractVerifier.verifyRequest((RequestMethod)RequestMethod.POST, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)requestString), (com.alibaba.fastjson.JSONObject)request, (SQLCreator)APIJSON_CREATOR)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            request = JSON.parseObject((String)"{\"Comment\":{\"id\":0, \"userId\":0, \"momentId\":0, \"content\":\"apijson\"}}");
            Log.d((String)TAG, (String)("test  verifyRequest = " + AbstractVerifier.verifyRequest((RequestMethod)RequestMethod.POST, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)requestString), (com.alibaba.fastjson.JSONObject)request, (SQLCreator)APIJSON_CREATOR)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            response = JSON.parseObject((String)"{\"User\":{\"userId\":0}}");
            Log.d((String)TAG, (String)("test  verifyResponse = " + AbstractVerifier.verifyResponse((RequestMethod)RequestMethod.GET, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)responseString), (com.alibaba.fastjson.JSONObject)response, (SQLCreator)APIJSON_CREATOR, null)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            response = JSON.parseObject((String)"{\"User\":{\"userId\":0, \"phone\":\"12345678\"}}");
            Log.d((String)TAG, (String)("test  verifyResponse = " + AbstractVerifier.verifyResponse((RequestMethod)RequestMethod.GET, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)responseString), (com.alibaba.fastjson.JSONObject)response, (SQLCreator)APIJSON_CREATOR, null)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            response = JSON.parseObject((String)"{\"User\":{\"userId\":0, \"phone\":\"12345678\", \"sex\":1}}");
            Log.d((String)TAG, (String)("test  verifyResponse = " + AbstractVerifier.verifyResponse((RequestMethod)RequestMethod.GET, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)responseString), (com.alibaba.fastjson.JSONObject)response, (SQLCreator)APIJSON_CREATOR, null)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            response = JSON.parseObject((String)"{\"User\":{\"id\":0, \"name\":\"tommy\", \"phone\":\"12345678\", \"sex\":1}}");
            Log.d((String)TAG, (String)("test  verifyResponse = " + AbstractVerifier.verifyResponse((RequestMethod)RequestMethod.GET, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)responseString), (com.alibaba.fastjson.JSONObject)response, (SQLCreator)APIJSON_CREATOR, null)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onServerError(String msg, boolean shutdown) throws ServerException {
        Log.e((String)TAG, (String)("\n\u6743\u9650\u914d\u7f6e\u6587\u6863\u6d4b\u8bd5\u672a\u901a\u8fc7\uff01\n\u8bf7\u4fee\u6539 Access \u8868\u91cc\u7684\u8bb0\u5f55\uff01\n\u4fdd\u8bc1\u524d\u7aef\u770b\u5230\u7684\u6743\u9650\u914d\u7f6e\u6587\u6863\u662f\u6b63\u786e\u7684\uff01\uff01\uff01\n\n\u539f\u56e0\uff1a\n" + msg));
        if (!shutdown) {
            throw new ServerException(msg);
        }
        System.exit(1);
    }

    @NotNull
    public APIJSONParser createParser() {
        APIJSONParser parser = (APIJSONParser)APIJSON_CREATOR.createParser();
        parser.setVisitor(this.visitor);
        return parser;
    }

    public static void verifyLogin(HttpSession session) throws Exception {
        Log.d((String)TAG, (String)("verifyLogin  session.getId() = " + (session == null ? null : session.getId())));
        APIJSON_CREATOR.createVerifier().setVisitor(APIJSONVerifier.getVisitor(session)).verifyLogin();
    }

    public static long getVisitorId(HttpSession session) {
        if (session == null) {
            return 0L;
        }
        Long id = (Long)session.getAttribute("visitorId");
        if (id == null) {
            Visitor<Long> v = APIJSONVerifier.getVisitor(session);
            id = v == null ? 0L : APIJSONVerifier.value((Long)v.getId());
            session.setAttribute("visitorId", (Object)id);
        }
        return APIJSONVerifier.value(id);
    }

    public static Visitor<Long> getVisitor(HttpSession session) {
        return session == null ? null : (Visitor)session.getAttribute(APIJSONConstant.VISITOR_);
    }

    public static long value(Long v) {
        return v == null ? 0L : v;
    }

    public String getIdKey(String database, String schema, String table) {
        return APIJSONSQLConfig.SIMPLE_CALLBACK.getIdKey(database, schema, table);
    }

    public String getUserIdKey(String database, String schema, String table) {
        return APIJSONSQLConfig.SIMPLE_CALLBACK.getUserIdKey(database, schema, table);
    }

    public Object newId(RequestMethod method, String database, String schema, String table) {
        return APIJSONSQLConfig.SIMPLE_CALLBACK.newId(method, database, schema, table);
    }
}

