/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONFunctionParser;
import apijson.framework.APIJSONParser;
import apijson.framework.APIJSONVerifier;
import apijson.orm.Parser;
import apijson.orm.Visitor;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.rmi.ServerException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import unitauto.MethodUtil;

public class APIJSONController {
    public static final String TAG = "APIJSONController";
    @NotNull
    public static APIJSONCreator APIJSON_CREATOR = new APIJSONCreator();

    public Parser<Long> newParser(HttpSession session, RequestMethod method) {
        Parser<Long> parser = APIJSON_CREATOR.createParser();
        parser.setMethod(method);
        if (parser instanceof APIJSONParser) {
            ((APIJSONParser)parser).setSession(session);
        }
        return parser;
    }

    public String parse(String request, HttpSession session, RequestMethod method) {
        return this.newParser(session, method).parse(request);
    }

    public String get(String request, HttpSession session) {
        return this.parse(request, session, RequestMethod.GET);
    }

    public String head(String request, HttpSession session) {
        return this.parse(request, session, RequestMethod.HEAD);
    }

    public String gets(String request, HttpSession session) {
        return this.parse(request, session, RequestMethod.GETS);
    }

    public String heads(String request, HttpSession session) {
        return this.parse(request, session, RequestMethod.HEADS);
    }

    public String post(String request, HttpSession session) {
        return this.parse(request, session, RequestMethod.POST);
    }

    public String put(String request, HttpSession session) {
        return this.parse(request, session, RequestMethod.PUT);
    }

    public String delete(String request, HttpSession session) {
        return this.parse(request, session, RequestMethod.DELETE);
    }

    public JSONObject reload(String type) {
        boolean reloadAll;
        JSONObject result = APIJSONParser.newSuccessResult();
        boolean bl = reloadAll = StringUtil.isEmpty((String)type, (boolean)true) || "ALL".equals(type);
        if (reloadAll || "ACCESS".equals(type)) {
            try {
                result.put(APIJSONConstant.ACCESS_, (Object)APIJSONVerifier.initAccess());
            }
            catch (ServerException e) {
                e.printStackTrace();
                result.put(APIJSONConstant.ACCESS_, (Object)APIJSONParser.newErrorResult((Exception)e));
            }
        }
        if (reloadAll || "FUNCTION".equals(type)) {
            try {
                result.put(APIJSONConstant.FUNCTION_, (Object)APIJSONFunctionParser.init());
            }
            catch (ServerException e) {
                e.printStackTrace();
                result.put(APIJSONConstant.FUNCTION_, (Object)APIJSONParser.newErrorResult((Exception)e));
            }
        }
        if (reloadAll || "REQUEST".equals(type)) {
            try {
                result.put(APIJSONConstant.REQUEST_, (Object)APIJSONVerifier.initRequest());
            }
            catch (ServerException e) {
                e.printStackTrace();
                result.put(APIJSONConstant.REQUEST_, (Object)APIJSONParser.newErrorResult((Exception)e));
            }
        }
        return result;
    }

    public Object login(@NotNull HttpSession session, Visitor<Long> visitor, Integer version, Boolean format, JSONObject defaults) {
        session.setAttribute("visitorId", visitor.getId());
        session.setAttribute(APIJSONConstant.VISITOR_, visitor);
        session.setAttribute("version", (Object)version);
        session.setAttribute("format", (Object)format);
        session.setAttribute("defaults", (Object)defaults);
        return null;
    }

    public Object logout(@NotNull HttpSession session) {
        Long userId = APIJSONVerifier.getVisitorId(session);
        Log.d((String)TAG, (String)("logout  userId = " + userId + "; session.getId() = " + (session == null ? null : session.getId())));
        session.invalidate();
        return null;
    }

    public JSONObject listMethod(String request) {
        if (!Log.DEBUG) {
            return APIJSONParser.newErrorResult((Exception)new IllegalAccessException("\u975e DEBUG \u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4f7f\u7528 UnitAuto \u5355\u5143\u6d4b\u8bd5\uff01"));
        }
        return MethodUtil.listMethod((String)request);
    }

    public void invokeMethod(String request, final HttpServletRequest servletRequest) {
        final AsyncContext asyncContext = servletRequest.startAsync();
        MethodUtil.Listener<JSONObject> listener = new MethodUtil.Listener<JSONObject>(){

            public void complete(JSONObject data, Method method, MethodUtil.InterfaceProxy proxy, Object ... extras) throws Exception {
                ServletResponse servletResponse = asyncContext.getResponse();
                if (servletResponse.isCommitted()) {
                    Log.w((String)APIJSONController.TAG, (String)"invokeMethod  listener.complete  servletResponse.isCommitted() >> return;");
                    return;
                }
                servletResponse.setCharacterEncoding(servletRequest.getCharacterEncoding());
                servletResponse.setContentType(servletRequest.getContentType());
                servletResponse.getWriter().println(data);
                asyncContext.complete();
            }
        };
        if (!Log.DEBUG) {
            try {
                listener.complete((Object)MethodUtil.JSON_CALLBACK.newErrorResult((Throwable)new IllegalAccessException("\u975e DEBUG \u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4f7f\u7528 UnitAuto \u5355\u5143\u6d4b\u8bd5\uff01")));
            }
            catch (Exception e1) {
                e1.printStackTrace();
                asyncContext.complete();
            }
            return;
        }
        try {
            MethodUtil.invokeMethod((String)request, null, (MethodUtil.Listener)listener);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("invokeMethod  try { JSONObject req = JSON.parseObject(request); ... } catch (Exception e) { \n" + e.getMessage()));
            try {
                listener.complete((Object)MethodUtil.JSON_CALLBACK.newErrorResult((Throwable)e));
            }
            catch (Exception e1) {
                e1.printStackTrace();
                asyncContext.complete();
            }
        }
    }
}

