/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.app.Activity;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.PersistableBundle;
import com.google.auto.service.AutoService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.builder.LastActivityManager;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.ReportingAdministrator;
import org.acra.config.SchedulerConfiguration;
import org.acra.log.ACRALog;
import org.acra.plugins.HasConfigPlugin;
import org.acra.scheduler.RestartingService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/acra/scheduler/RestartingAdministrator;", "Lorg/acra/plugins/HasConfigPlugin;", "Lorg/acra/config/ReportingAdministrator;", "()V", "shouldFinishActivity", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "lastActivityManager", "Lorg/acra/builder/LastActivityManager;", "Companion", "acra-advanced-scheduler_release"})
@AutoService(value={ReportingAdministrator.class})
public class RestartingAdministrator
extends HasConfigPlugin
implements ReportingAdministrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXTRA_LAST_ACTIVITY = "lastActivity";
    @NotNull
    public static final String EXTRA_ACTIVITY_RESTART_AFTER_CRASH = "restartAfterCrash";

    public RestartingAdministrator() {
        super(SchedulerConfiguration.class);
    }

    public boolean shouldFinishActivity(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull LastActivityManager lastActivityManager) {
        String string;
        ACRALog aCRALog;
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)lastActivityManager, (String)"lastActivityManager");
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "RestartingAdministrator entry";
            aCRALog.d(string2, string);
        }
        if (((SchedulerConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, SchedulerConfiguration.class)).getRestartAfterCrash()) {
            Activity activity = lastActivityManager.getLastActivity();
            if (activity != null) {
                boolean $i$f$debug2 = false;
                if (ACRA.DEV_LOGGING) {
                    string2 = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    string = "Try to schedule last activity (" + activity.getClass().getName() + ") for restart";
                    aCRALog.d(string2, string);
                }
                try {
                    Object bl = context.getSystemService("jobscheduler");
                    if (bl == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.app.job.JobScheduler");
                    }
                    JobScheduler scheduler = (JobScheduler)bl;
                    PersistableBundle extras = new PersistableBundle();
                    extras.putString(EXTRA_LAST_ACTIVITY, activity.getClass().getName());
                    scheduler.schedule(new JobInfo.Builder(1, new ComponentName(context, RestartingService.class)).setExtras(extras).setOverrideDeadline(100L).build());
                    boolean $i$f$debug3 = false;
                    if (ACRA.DEV_LOGGING) {
                        string2 = ACRA.LOG_TAG;
                        aCRALog = ACRA.log;
                        boolean bl2 = false;
                        string = "Successfully scheduled last activity (" + activity.getClass().getName() + ") for restart";
                        aCRALog.d(string2, string);
                    }
                }
                catch (Exception e) {
                    boolean $i$f$warn = false;
                    string2 = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    string = "Failed to schedule last activity for restart";
                    aCRALog.w(string2, string, (Throwable)e);
                }
            } else {
                boolean $i$f$info = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Activity restart is enabled but no activity was found. Nothing to do.";
                aCRALog.i(string2, string);
            }
        }
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/acra/scheduler/RestartingAdministrator$Companion;", "", "()V", "EXTRA_ACTIVITY_RESTART_AFTER_CRASH", "", "EXTRA_LAST_ACTIVITY", "acra-advanced-scheduler_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

