/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.app.job.JobInfo;
import android.content.Context;
import android.os.Build;
import com.google.auto.service.AutoService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.SchedulerConfiguration;
import org.acra.plugins.HasConfigPlugin;
import org.acra.scheduler.DefaultSenderScheduler;
import org.acra.scheduler.SenderScheduler;
import org.acra.scheduler.SenderSchedulerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/acra/scheduler/AdvancedSenderScheduler;", "Lorg/acra/scheduler/DefaultSenderScheduler;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "schedulerConfiguration", "Lorg/acra/config/SchedulerConfiguration;", "configureJob", "", "job", "Landroid/app/job/JobInfo$Builder;", "Factory", "acra-advanced-scheduler_release"})
public final class AdvancedSenderScheduler
extends DefaultSenderScheduler {
    @NotNull
    private final SchedulerConfiguration schedulerConfiguration;

    private AdvancedSenderScheduler(Context context, CoreConfiguration config) {
        super(context, config);
        this.schedulerConfiguration = (SchedulerConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, SchedulerConfiguration.class);
    }

    protected void configureJob(@NotNull JobInfo.Builder job) {
        boolean constrained;
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        job.setRequiredNetworkType(this.schedulerConfiguration.getRequiresNetworkType());
        job.setRequiresCharging(this.schedulerConfiguration.getRequiresCharging());
        job.setRequiresDeviceIdle(this.schedulerConfiguration.getRequiresDeviceIdle());
        boolean bl = constrained = this.schedulerConfiguration.getRequiresNetworkType() != 0 || this.schedulerConfiguration.getRequiresCharging() || this.schedulerConfiguration.getRequiresDeviceIdle();
        if (Build.VERSION.SDK_INT >= 26) {
            job.setRequiresBatteryNotLow(this.schedulerConfiguration.getRequiresBatteryNotLow());
            constrained |= this.schedulerConfiguration.getRequiresBatteryNotLow();
        }
        if (!constrained) {
            job.setOverrideDeadline(0L);
        }
    }

    public /* synthetic */ AdvancedSenderScheduler(Context context, CoreConfiguration config, DefaultConstructorMarker $constructor_marker) {
        this(context, config);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/acra/scheduler/AdvancedSenderScheduler$Factory;", "Lorg/acra/plugins/HasConfigPlugin;", "Lorg/acra/scheduler/SenderSchedulerFactory;", "()V", "create", "Lorg/acra/scheduler/SenderScheduler;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "acra-advanced-scheduler_release"})
    @AutoService(value={SenderSchedulerFactory.class})
    public static class Factory
    extends HasConfigPlugin
    implements SenderSchedulerFactory {
        public Factory() {
            super(SchedulerConfiguration.class);
        }

        @NotNull
        public SenderScheduler create(@NotNull Context context, @NotNull CoreConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return (SenderScheduler)new AdvancedSenderScheduler(context, config, null);
        }
    }
}

