/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.content.Context;
import android.support.annotation.NonNull;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.support.PersistableBundleCompat;
import java.util.concurrent.TimeUnit;
import org.acra.builder.LastActivityManager;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.ReportingAdministrator;
import org.acra.config.SchedulerConfiguration;
import org.acra.plugins.HasConfigPlugin;

public class RestartingAdministrator
extends HasConfigPlugin
implements ReportingAdministrator {
    public static final String EXTRA_LAST_ACTIVITY = "lastActivity";

    public RestartingAdministrator() {
        super(SchedulerConfiguration.class);
    }

    public boolean shouldFinishActivity(@NonNull Context context, @NonNull CoreConfiguration config, LastActivityManager lastActivityManager) {
        if (((SchedulerConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, SchedulerConfiguration.class)).restartAfterCrash() && lastActivityManager.getLastActivity() != null) {
            PersistableBundleCompat extras = new PersistableBundleCompat();
            extras.putString(EXTRA_LAST_ACTIVITY, lastActivityManager.getLastActivity().getClass().getName());
            new JobRequest.Builder("org.acra.restart.Job").setExact(TimeUnit.SECONDS.toMillis(1L)).setExtras(extras).setUpdateCurrent(true).build().schedule();
        }
        return true;
    }
}

