/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.content.Context;
import android.support.annotation.NonNull;
import com.evernote.android.job.JobCreator;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.support.PersistableBundleCompat;
import java.util.concurrent.TimeUnit;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.SchedulerConfiguration;
import org.acra.file.ReportLocator;
import org.acra.plugins.HasConfigPlugin;
import org.acra.scheduler.AcraJobCreator;
import org.acra.scheduler.SenderScheduler;
import org.acra.scheduler.SenderSchedulerFactory;

public class AdvancedSenderScheduler
implements SenderScheduler {
    private final Context context;
    private final CoreConfiguration config;

    private AdvancedSenderScheduler(@NonNull Context context, @NonNull CoreConfiguration config) {
        this.context = context;
        this.config = config;
    }

    public void scheduleReportSending(boolean onlySendSilentReports) {
        if (new ReportLocator(this.context).getApprovedReports().length == 0) {
            return;
        }
        SchedulerConfiguration schedulerConfiguration = (SchedulerConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)this.config, SchedulerConfiguration.class);
        PersistableBundleCompat extras = new PersistableBundleCompat();
        extras.putBoolean("onlySendSilentReports", onlySendSilentReports);
        new JobRequest.Builder("org.acra.report.Job").setExecutionWindow(1L, TimeUnit.MINUTES.toMillis(1L)).setExtras(extras).setRequirementsEnforced(true).setRequiredNetworkType(schedulerConfiguration.requiresNetworkType()).setRequiresCharging(schedulerConfiguration.requiresCharging()).setRequiresDeviceIdle(schedulerConfiguration.requiresDeviceIdle()).setRequiresBatteryNotLow(schedulerConfiguration.requiresBatteryNotLow()).setUpdateCurrent(true).build().schedule();
    }

    public static class Factory
    extends HasConfigPlugin
    implements SenderSchedulerFactory {
        public Factory() {
            super(SchedulerConfiguration.class);
        }

        @NonNull
        public SenderScheduler create(@NonNull Context context, @NonNull CoreConfiguration config) {
            JobManager.create((Context)context).addJobCreator((JobCreator)new AcraJobCreator(config));
            return new AdvancedSenderScheduler(context, config);
        }
    }
}

