/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobCreator;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.scheduler.DefaultSenderScheduler;

class AcraJobCreator
implements JobCreator {
    static final String REPORT_TAG = "org.acra.report.Job";
    static final String RESTART_TAG = "org.acra.restart.Job";
    private final CoreConfiguration config;

    public AcraJobCreator(CoreConfiguration config) {
        this.config = config;
    }

    @Nullable
    public Job create(@NonNull String tag) {
        switch (tag) {
            case "org.acra.report.Job": {
                return new Job(){

                    @NonNull
                    protected Job.Result onRunJob(@NonNull Job.Params params) {
                        boolean sendOnlySilentReports = params.getExtras().getBoolean("onlySendSilentReports", false);
                        new DefaultSenderScheduler(this.getContext(), AcraJobCreator.this.config).scheduleReportSending(sendOnlySilentReports);
                        return Job.Result.SUCCESS;
                    }
                };
            }
            case "org.acra.restart.Job": {
                return new Job(){

                    @NonNull
                    protected Job.Result onRunJob(@NonNull Job.Params params) {
                        String className = params.getExtras().getString("lastActivity", null);
                        if (className != null) {
                            try {
                                Class<?> activityClass = Class.forName(className);
                                Intent intent = new Intent(this.getContext(), activityClass);
                                intent.addFlags(0x10000000);
                                this.getContext().startActivity(intent);
                            }
                            catch (ClassNotFoundException e) {
                                ACRA.log.w(ACRA.LOG_TAG, "Unable to find activity class" + className);
                            }
                        }
                        return Job.Result.SUCCESS;
                    }
                };
            }
        }
        return null;
    }
}

