/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import android.support.annotation.NonNull;
import com.evernote.android.job.JobRequest;
import org.acra.annotation.AcraScheduler;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.SchedulerConfiguration;
import org.acra.config.SchedulerConfigurationBuilder;

final class SchedulerConfigurationBuilderImpl
implements SchedulerConfigurationBuilder {
    @NonNull
    private final Context context;
    private boolean enabled;
    @NonNull
    private JobRequest.NetworkType requiresNetworkType;
    private boolean requiresCharging;
    private boolean requiresDeviceIdle;
    private boolean requiresBatteryNotLow;
    private boolean restartAfterCrash;

    SchedulerConfigurationBuilderImpl(@NonNull Context arg0) {
        AcraScheduler annotation = arg0.getClass().getAnnotation(AcraScheduler.class);
        this.context = arg0;
        boolean bl = this.enabled = annotation != null;
        if (this.enabled) {
            this.requiresNetworkType = annotation.requiresNetworkType();
            this.requiresCharging = annotation.requiresCharging();
            this.requiresDeviceIdle = annotation.requiresDeviceIdle();
            this.requiresBatteryNotLow = annotation.requiresBatteryNotLow();
            this.restartAfterCrash = annotation.restartAfterCrash();
        } else {
            this.requiresNetworkType = JobRequest.NetworkType.ANY;
            this.requiresCharging = false;
            this.requiresDeviceIdle = false;
            this.requiresBatteryNotLow = false;
            this.restartAfterCrash = false;
        }
    }

    @Override
    @NonNull
    public SchedulerConfigurationBuilderImpl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    boolean enabled() {
        return this.enabled;
    }

    @Override
    @NonNull
    public SchedulerConfigurationBuilderImpl setRequiresNetworkType(@NonNull JobRequest.NetworkType requiresNetworkType) {
        this.requiresNetworkType = requiresNetworkType;
        return this;
    }

    @NonNull
    JobRequest.NetworkType requiresNetworkType() {
        return this.requiresNetworkType;
    }

    @Override
    @NonNull
    public SchedulerConfigurationBuilderImpl setRequiresCharging(boolean requiresCharging) {
        this.requiresCharging = requiresCharging;
        return this;
    }

    boolean requiresCharging() {
        return this.requiresCharging;
    }

    @Override
    @NonNull
    public SchedulerConfigurationBuilderImpl setRequiresDeviceIdle(boolean requiresDeviceIdle) {
        this.requiresDeviceIdle = requiresDeviceIdle;
        return this;
    }

    boolean requiresDeviceIdle() {
        return this.requiresDeviceIdle;
    }

    @Override
    @NonNull
    public SchedulerConfigurationBuilderImpl setRequiresBatteryNotLow(boolean requiresBatteryNotLow) {
        this.requiresBatteryNotLow = requiresBatteryNotLow;
        return this;
    }

    boolean requiresBatteryNotLow() {
        return this.requiresBatteryNotLow;
    }

    @Override
    @NonNull
    public SchedulerConfigurationBuilderImpl setRestartAfterCrash(boolean restartAfterCrash) {
        this.restartAfterCrash = restartAfterCrash;
        return this;
    }

    boolean restartAfterCrash() {
        return this.restartAfterCrash;
    }

    @NonNull
    public SchedulerConfiguration build() throws ACRAConfigurationException {
        if (this.enabled) {
            // empty if block
        }
        return new SchedulerConfiguration(this);
    }
}

