/*
 * Decompiled with CFR 0.152.
 */
package cn.thens.okbinder2;

import cn.thens.okbinder2.RelatedTypes;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public final class FactoryGenerator {
    private final RelatedTypes t;
    private final Elements elementUtils;
    private final Filer filer;
    private static final boolean SHOULD_SKIP_OBJECT_METHODS = true;

    public FactoryGenerator(RelatedTypes types, Elements elementUtils, Filer filer) {
        this.t = types;
        this.elementUtils = elementUtils;
        this.filer = filer;
    }

    /*
     * WARNING - void declaration
     */
    public void generate(TypeElement element) {
        TypeName MyInterface = ClassName.get((TypeMirror)element.asType());
        String packageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
        ArrayList<FieldSpec> factoryFields = new ArrayList<FieldSpec>();
        ArrayList<MethodSpec> proxyMethods = new ArrayList<MethodSpec>();
        CodeBlock.Builder binderFunctionCode = CodeBlock.builder();
        int methodCount = 0;
        for (Element element2 : this.elementUtils.getAllMembers(element)) {
            void var18_20;
            if (this.shouldSkipMethod(element2)) continue;
            ExecutableElement methodMember = (ExecutableElement)element2;
            String methodName = methodMember.getSimpleName().toString();
            TypeName returnType = ClassName.get((TypeMirror)methodMember.getReturnType());
            String functionIdName = methodName + "_" + methodCount;
            ArrayList<CodeBlock> functionInvokeArgs = new ArrayList<CodeBlock>();
            ArrayList<ParameterSpec> proxyMethodParams = new ArrayList<ParameterSpec>();
            CodeBlock.Builder proxyMethodInvokeArgCode = CodeBlock.builder();
            for (VariableElement variableElement : methodMember.getParameters()) {
                TypeName ParamType = ClassName.get((TypeMirror)variableElement.asType());
                int index = functionInvokeArgs.size();
                functionInvokeArgs.add(CodeBlock.of((String)"($T) args[$L]", (Object[])new Object[]{ParamType, index}));
                proxyMethodParams.add(ParameterSpec.builder((TypeName)ParamType, (String)("arg" + index), (Modifier[])new Modifier[0]).build());
                if (index == 0) {
                    proxyMethodInvokeArgCode.add(", (Object) arg" + index, new Object[0]);
                    continue;
                }
                proxyMethodInvokeArgCode.add(", arg" + index, new Object[0]);
            }
            CodeBlock functionInvokeCode = CodeBlock.of((String)"(($T) obj).$L($L)", (Object[])new Object[]{MyInterface, methodName, CodeBlock.join(functionInvokeArgs, (String)", ")});
            if (!TypeName.VOID.equals((Object)returnType)) {
                functionInvokeCode = CodeBlock.builder().addStatement("return ($T) $L", new Object[]{returnType, functionInvokeCode}).build();
                CodeBlock codeBlock = CodeBlock.of((String)"return ($T) transact(0, $L$L)", (Object[])new Object[]{returnType, functionIdName, proxyMethodInvokeArgCode.build()});
            } else {
                functionInvokeCode = CodeBlock.builder().addStatement(functionInvokeCode).addStatement("return null", new Object[0]).build();
                CodeBlock codeBlock = CodeBlock.of((String)"transact($T.FLAG_ONEWAY, $L$L)", (Object[])new Object[]{this.t.IBinder, functionIdName, proxyMethodInvokeArgCode.build()});
            }
            TypeSpec MyFunction = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)this.t.Function).addMethod(MethodSpec.methodBuilder((String)"invoke").addAnnotation(this.t.Override).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeName.OBJECT, "obj", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeName.OBJECT), "args", new Modifier[0]).returns((TypeName)TypeName.OBJECT).addException((TypeName)this.t.Throwable).addCode(functionInvokeCode).build()).build();
            binderFunctionCode.addStatement("register($L, $L)", new Object[]{functionIdName, MyFunction});
            factoryFields.add(FieldSpec.builder((TypeName)this.t.String, (String)functionIdName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.builder().add("$S", new Object[]{this.getFunctionId(methodMember)}).build()).build());
            proxyMethods.add(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.t.Override).addParameters(proxyMethodParams).returns(returnType).addStatement((CodeBlock)var18_20).build());
            ++methodCount;
        }
        ClassName MyFactory = ClassName.get((String)packageName, (String)(this.getClassName(element) + "Factory"), (String[])new String[0]);
        ClassName className = MyFactory.nestedClass("MyBinder");
        ClassName MyProxy = MyFactory.nestedClass("MyProxy");
        TypeSpec MyFactorySpec = TypeSpec.classBuilder((ClassName)MyFactory).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)this.t.OkBinderFactory).addMethod(MethodSpec.methodBuilder((String)"newBinder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.t.Class, "serviceClass", new Modifier[0]).addParameter((TypeName)TypeName.OBJECT, "remoteObject", new Modifier[0]).returns((TypeName)this.t.Binder).addAnnotation(this.t.Override).addStatement("return new $T(serviceClass, remoteObject)", new Object[]{className}).build()).addMethod(MethodSpec.methodBuilder((String)"newProxy").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.t.Class, "serviceClass", new Modifier[0]).addParameter((TypeName)this.t.IBinder, "binder", new Modifier[0]).returns((TypeName)TypeName.OBJECT).addAnnotation(this.t.Override).addStatement("return new $T(serviceClass, binder)", new Object[]{MyProxy}).build()).addFields(factoryFields).addType(TypeSpec.classBuilder((ClassName)MyProxy).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)this.t.BaseProxy).addSuperinterface(MyInterface).addMethod(MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)this.t.Class, (String)"serviceClass", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)this.t.IBinder, (String)"binder", (Modifier[])new Modifier[0]).build()).addStatement("super(serviceClass, binder)", new Object[0]).build()).addMethods(proxyMethods).build()).addType(TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)this.t.BaseBinder).addMethod(MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)this.t.Class, (String)"serviceClass", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.OBJECT, (String)"obj", (Modifier[])new Modifier[0]).build()).addStatement("super(serviceClass, obj)", new Object[0]).addCode(binderFunctionCode.build()).build()).build()).build();
        try {
            JavaFile.builder((String)packageName, (TypeSpec)MyFactorySpec).indent("    ").build().writeTo(this.filer);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String getClassName(TypeElement element) {
        String fileName = this.elementUtils.getBinaryName(element).toString();
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    private boolean shouldSkipMethod(Element member) {
        if (!(member instanceof ExecutableElement)) {
            return true;
        }
        for (Modifier modifier : member.getModifiers()) {
            if (modifier != Modifier.FINAL && modifier != Modifier.STATIC) continue;
            return true;
        }
        ExecutableElement methodMember = (ExecutableElement)member;
        String methodName = methodMember.getSimpleName().toString();
        List<? extends VariableElement> parameters = methodMember.getParameters();
        if (methodName.equals("toString") && parameters.isEmpty()) {
            return true;
        }
        if (methodName.equals("hashCode") && parameters.isEmpty()) {
            return true;
        }
        if (methodName.equals("equals") && parameters.size() == 1) {
            return ClassName.get((TypeMirror)parameters.get(0).asType()).equals((Object)TypeName.OBJECT);
        }
        return false;
    }

    private String getFunctionId(ExecutableElement method) {
        StringBuilder functionId = new StringBuilder(method.getSimpleName());
        StringBuilder params = new StringBuilder();
        boolean isFirst = true;
        for (VariableElement variableElement : method.getParameters()) {
            TypeName paramType = TypeName.get((TypeMirror)variableElement.asType());
            params.append(isFirst ? "" : ",").append(paramType);
            isFirst = false;
        }
        if (params.length() <= 24) {
            return functionId.append("(").append((CharSequence)params).append(")").toString();
        }
        try {
            byte[] bytes = params.toString().getBytes();
            byte[] byArray = MessageDigest.getInstance("MD5").digest(bytes);
            String base64 = new String(Base64.getEncoder().encode(byArray));
            return functionId.append("(").append(base64).append(")").toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

