/*
 * Decompiled with CFR 0.152.
 */
package com.devlomi.record_view;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Chronometer;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import com.devlomi.record_view.AnimationHelper;
import com.devlomi.record_view.DpUtil;
import com.devlomi.record_view.OnBasketAnimationEnd;
import com.devlomi.record_view.OnRecordListener;
import com.devlomi.record_view.R;
import com.devlomi.record_view.RecordButton;
import com.devlomi.record_view.RecordPermissionHandler;
import io.supercharge.shimmerlayout.ShimmerLayout;
import java.io.IOException;

public class RecordView
extends RelativeLayout {
    public static final int DEFAULT_CANCEL_BOUNDS = 8;
    private ImageView smallBlinkingMic;
    private ImageView basketImg;
    private Chronometer counterTime;
    private TextView slideToCancel;
    private ShimmerLayout slideToCancelLayout;
    private ImageView arrow;
    private float initialX;
    private float basketInitialY;
    private float difX = 0.0f;
    private float cancelBounds = 8.0f;
    private long startTime;
    private long elapsedTime = 0L;
    private Context context;
    private OnRecordListener recordListener;
    private RecordPermissionHandler recordPermissionHandler;
    private boolean isSwiped;
    private boolean isLessThanSecondAllowed = false;
    private boolean isSoundEnabled = true;
    private int RECORD_START = R.raw.record_start;
    private int RECORD_FINISHED = R.raw.record_finished;
    private int RECORD_ERROR = R.raw.record_error;
    private MediaPlayer player;
    private AnimationHelper animationHelper;
    private boolean isRecordButtonGrowingAnimationEnabled = true;
    private boolean shimmerEffectEnabled = true;
    private long timeLimit = -1L;
    private Runnable runnable;
    private Handler handler;
    private RecordButton recordButton;
    private boolean canRecord = true;

    public RecordView(Context context) {
        super(context);
        this.context = context;
        this.init(context, null, -1, -1);
    }

    public RecordView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(context, attrs, -1, -1);
    }

    public RecordView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init(context, attrs, defStyleAttr, -1);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        View view = View.inflate((Context)context, (int)R.layout.record_view_layout, null);
        this.addView(view);
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        viewGroup.setClipChildren(false);
        this.arrow = (ImageView)view.findViewById(R.id.arrow);
        this.slideToCancel = (TextView)view.findViewById(R.id.slide_to_cancel);
        this.smallBlinkingMic = (ImageView)view.findViewById(R.id.glowing_mic);
        this.counterTime = (Chronometer)view.findViewById(R.id.counter_tv);
        this.basketImg = (ImageView)view.findViewById(R.id.basket_img);
        this.slideToCancelLayout = (ShimmerLayout)view.findViewById(R.id.shimmer_layout);
        this.hideViews(true);
        if (attrs != null && defStyleAttr == -1 && defStyleRes == -1) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RecordView, defStyleAttr, defStyleRes);
            int slideArrowResource = typedArray.getResourceId(R.styleable.RecordView_slide_to_cancel_arrow, -1);
            String slideToCancelText = typedArray.getString(R.styleable.RecordView_slide_to_cancel_text);
            int slideMarginRight = (int)typedArray.getDimension(R.styleable.RecordView_slide_to_cancel_margin_right, 30.0f);
            int counterTimeColor = typedArray.getColor(R.styleable.RecordView_counter_time_color, -1);
            int arrowColor = typedArray.getColor(R.styleable.RecordView_slide_to_cancel_arrow_color, -1);
            int cancelBounds = typedArray.getDimensionPixelSize(R.styleable.RecordView_slide_to_cancel_bounds, -1);
            if (cancelBounds != -1) {
                this.setCancelBounds(cancelBounds, false);
            }
            if (slideArrowResource != -1) {
                Drawable slideArrow = AppCompatResources.getDrawable((Context)this.getContext(), (int)slideArrowResource);
                this.arrow.setImageDrawable(slideArrow);
            }
            if (slideToCancelText != null) {
                this.slideToCancel.setText((CharSequence)slideToCancelText);
            }
            if (counterTimeColor != -1) {
                this.setCounterTimeColor(counterTimeColor);
            }
            if (arrowColor != -1) {
                this.setSlideToCancelArrowColor(arrowColor);
            }
            this.setMarginRight(slideMarginRight, true);
            typedArray.recycle();
        }
        this.animationHelper = new AnimationHelper(context, this.basketImg, this.smallBlinkingMic, this.isRecordButtonGrowingAnimationEnabled);
    }

    private boolean isTimeLimitValid() {
        return this.timeLimit > 0L;
    }

    private void initTimeLimitHandler() {
        this.handler = new Handler();
        this.runnable = new Runnable(){

            @Override
            public void run() {
                if (RecordView.this.recordListener != null && !RecordView.this.isSwiped) {
                    RecordView.this.recordListener.onFinish(RecordView.this.elapsedTime, true);
                }
                RecordView.this.removeTimeLimitCallbacks();
                RecordView.this.animationHelper.setStartRecorded(false);
                if (!RecordView.this.isSwiped) {
                    RecordView.this.playSound(RecordView.this.RECORD_FINISHED);
                }
                if (RecordView.this.recordButton != null) {
                    RecordView.this.resetRecord(RecordView.this.recordButton);
                }
                RecordView.this.isSwiped = true;
            }
        };
    }

    private void hideViews(boolean hideSmallMic) {
        this.slideToCancelLayout.setVisibility(8);
        this.counterTime.setVisibility(8);
        if (hideSmallMic) {
            this.smallBlinkingMic.setVisibility(8);
        }
    }

    private void showViews() {
        this.slideToCancelLayout.setVisibility(0);
        this.smallBlinkingMic.setVisibility(0);
        this.counterTime.setVisibility(0);
    }

    private boolean isLessThanOneSecond(long time) {
        return time <= 1000L;
    }

    private void playSound(int soundRes) {
        if (this.isSoundEnabled) {
            if (soundRes == 0) {
                return;
            }
            try {
                this.player = new MediaPlayer();
                AssetFileDescriptor afd = this.context.getResources().openRawResourceFd(soundRes);
                if (afd == null) {
                    return;
                }
                this.player.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                afd.close();
                this.player.prepare();
                this.player.start();
                this.player.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        mp.release();
                    }
                });
                this.player.setLooping(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void onActionDown(RecordButton recordBtn, MotionEvent motionEvent) {
        if (!this.isRecordPermissionGranted()) {
            return;
        }
        this.recordButton = recordBtn;
        if (this.recordListener != null) {
            this.recordListener.onStart();
        }
        if (this.isTimeLimitValid()) {
            this.removeTimeLimitCallbacks();
            this.handler.postDelayed(this.runnable, this.timeLimit);
        }
        this.animationHelper.setStartRecorded(true);
        this.animationHelper.resetBasketAnimation();
        this.animationHelper.resetSmallMic();
        if (this.isRecordButtonGrowingAnimationEnabled) {
            recordBtn.startScale();
        }
        if (this.shimmerEffectEnabled) {
            this.slideToCancelLayout.startShimmerAnimation();
        }
        this.initialX = recordBtn.getX();
        this.basketInitialY = this.basketImg.getY() + 90.0f;
        this.playSound(this.RECORD_START);
        this.showViews();
        this.animationHelper.animateSmallMicAlpha();
        this.counterTime.setBase(SystemClock.elapsedRealtime());
        this.startTime = System.currentTimeMillis();
        this.counterTime.start();
        this.isSwiped = false;
    }

    protected void onActionMove(RecordButton recordBtn, MotionEvent motionEvent) {
        if (!this.canRecord) {
            return;
        }
        long time = System.currentTimeMillis() - this.startTime;
        if (!this.isSwiped) {
            if (this.slideToCancelLayout.getX() != 0.0f && this.slideToCancelLayout.getX() <= (float)this.counterTime.getRight() + this.cancelBounds) {
                if (this.isLessThanOneSecond(time)) {
                    this.hideViews(true);
                    this.animationHelper.clearAlphaAnimation(false);
                    this.animationHelper.onAnimationEnd();
                } else {
                    this.hideViews(false);
                    this.animationHelper.animateBasket(this.basketInitialY);
                }
                this.animationHelper.moveRecordButtonAndSlideToCancelBack(recordBtn, (FrameLayout)this.slideToCancelLayout, this.initialX, this.difX);
                this.counterTime.stop();
                if (this.shimmerEffectEnabled) {
                    this.slideToCancelLayout.stopShimmerAnimation();
                }
                this.isSwiped = true;
                this.animationHelper.setStartRecorded(false);
                if (this.recordListener != null) {
                    this.recordListener.onCancel();
                }
                if (this.isTimeLimitValid()) {
                    this.removeTimeLimitCallbacks();
                }
            } else if (motionEvent.getRawX() < this.initialX) {
                recordBtn.animate().x(motionEvent.getRawX()).setDuration(0L).start();
                if (this.difX == 0.0f) {
                    this.difX = this.initialX - this.slideToCancelLayout.getX();
                }
                this.slideToCancelLayout.animate().x(motionEvent.getRawX() - this.difX).setDuration(0L).start();
            }
        }
    }

    protected void onActionUp(RecordButton recordBtn) {
        if (!this.canRecord) {
            return;
        }
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        if (!this.isLessThanSecondAllowed && this.isLessThanOneSecond(this.elapsedTime) && !this.isSwiped) {
            if (this.recordListener != null) {
                this.recordListener.onLessThanSecond();
            }
            this.removeTimeLimitCallbacks();
            this.animationHelper.setStartRecorded(false);
            this.playSound(this.RECORD_ERROR);
        } else {
            if (this.recordListener != null && !this.isSwiped) {
                this.recordListener.onFinish(this.elapsedTime, false);
            }
            this.removeTimeLimitCallbacks();
            this.animationHelper.setStartRecorded(false);
            if (!this.isSwiped) {
                this.playSound(this.RECORD_FINISHED);
            }
        }
        this.resetRecord(recordBtn);
    }

    private void resetRecord(RecordButton recordBtn) {
        this.hideViews(!this.isSwiped);
        if (!this.isSwiped) {
            this.animationHelper.clearAlphaAnimation(true);
        }
        this.animationHelper.moveRecordButtonAndSlideToCancelBack(recordBtn, (FrameLayout)this.slideToCancelLayout, this.initialX, this.difX);
        this.counterTime.stop();
        if (this.shimmerEffectEnabled) {
            this.slideToCancelLayout.stopShimmerAnimation();
        }
    }

    private void removeTimeLimitCallbacks() {
        if (this.isTimeLimitValid()) {
            this.handler.removeCallbacks(this.runnable);
        }
    }

    private boolean isRecordPermissionGranted() {
        if (this.recordPermissionHandler == null) {
            this.canRecord = true;
        }
        this.canRecord = this.recordPermissionHandler.isPermissionGranted();
        return this.canRecord;
    }

    private void setMarginRight(int marginRight, boolean convertToDp) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.slideToCancelLayout.getLayoutParams();
        layoutParams.rightMargin = convertToDp ? (int)DpUtil.toPixel(marginRight, this.context) : marginRight;
        this.slideToCancelLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setOnRecordListener(OnRecordListener recrodListener) {
        this.recordListener = recrodListener;
    }

    public void setRecordPermissionHandler(RecordPermissionHandler recordPermissionHandler) {
        this.recordPermissionHandler = recordPermissionHandler;
    }

    public void setOnBasketAnimationEndListener(OnBasketAnimationEnd onBasketAnimationEndListener) {
        this.animationHelper.setOnBasketAnimationEndListener(onBasketAnimationEndListener);
    }

    public void setSoundEnabled(boolean isEnabled) {
        this.isSoundEnabled = isEnabled;
    }

    public void setLessThanSecondAllowed(boolean isAllowed) {
        this.isLessThanSecondAllowed = isAllowed;
    }

    public void setSlideToCancelText(String text) {
        this.slideToCancel.setText((CharSequence)text);
    }

    public void setSlideToCancelTextColor(int color) {
        this.slideToCancel.setTextColor(color);
    }

    public void setSmallMicColor(int color) {
        this.smallBlinkingMic.setColorFilter(color);
    }

    public void setSmallMicIcon(int icon) {
        this.smallBlinkingMic.setImageResource(icon);
    }

    public void setSlideMarginRight(int marginRight) {
        this.setMarginRight(marginRight, true);
    }

    public void setCustomSounds(int startSound, int finishedSound, int errorSound) {
        this.RECORD_START = startSound;
        this.RECORD_FINISHED = finishedSound;
        this.RECORD_ERROR = errorSound;
    }

    public float getCancelBounds() {
        return this.cancelBounds;
    }

    public void setCancelBounds(float cancelBounds) {
        this.setCancelBounds(cancelBounds, true);
    }

    public void setCounterTimeColor(int color) {
        this.counterTime.setTextColor(color);
    }

    public void setSlideToCancelArrowColor(int color) {
        this.arrow.setColorFilter(color);
    }

    private void setCancelBounds(float cancelBounds, boolean convertDpToPixel) {
        float bounds;
        this.cancelBounds = bounds = convertDpToPixel ? DpUtil.toPixel(cancelBounds, this.context) : cancelBounds;
    }

    public boolean isRecordButtonGrowingAnimationEnabled() {
        return this.isRecordButtonGrowingAnimationEnabled;
    }

    public void setRecordButtonGrowingAnimationEnabled(boolean recordButtonGrowingAnimationEnabled) {
        this.isRecordButtonGrowingAnimationEnabled = recordButtonGrowingAnimationEnabled;
        this.animationHelper.setRecordButtonGrowingAnimationEnabled(recordButtonGrowingAnimationEnabled);
    }

    public boolean isShimmerEffectEnabled() {
        return this.shimmerEffectEnabled;
    }

    public void setShimmerEffectEnabled(boolean shimmerEffectEnabled) {
        this.shimmerEffectEnabled = shimmerEffectEnabled;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit;
        if (this.handler != null && this.runnable != null) {
            this.removeTimeLimitCallbacks();
        }
        this.initTimeLimitHandler();
    }

    public void setTrashIconColor(int color) {
        this.animationHelper.setTrashIconColor(color);
    }
}

