/*
 * Decompiled with CFR 0.152.
 */
package com.devlomi.record_view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import com.devlomi.record_view.OnRecordClickListener;
import com.devlomi.record_view.R;
import com.devlomi.record_view.RecordView;
import com.devlomi.record_view.ScaleAnim;

public class RecordButton
extends AppCompatImageView
implements View.OnTouchListener,
View.OnClickListener {
    private ScaleAnim scaleAnim;
    private RecordView recordView;
    private boolean listenForRecord = true;
    private OnRecordClickListener onRecordClickListener;

    public void setRecordView(RecordView recordView) {
        this.recordView = recordView;
    }

    public RecordButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public RecordButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RecordButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RecordButton);
            int imageResource = typedArray.getResourceId(R.styleable.RecordButton_mic_icon, -1);
            if (imageResource != -1) {
                this.setTheImageResource(imageResource);
            }
            typedArray.recycle();
        }
        this.scaleAnim = new ScaleAnim((View)this);
        this.setOnTouchListener(this);
        this.setOnClickListener(this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setClip((View)this);
    }

    public void setClip(View v) {
        if (v.getParent() == null) {
            return;
        }
        if (v instanceof ViewGroup) {
            ((ViewGroup)v).setClipChildren(false);
            ((ViewGroup)v).setClipToPadding(false);
        }
        if (v.getParent() instanceof View) {
            this.setClip((View)v.getParent());
        }
    }

    private void setTheImageResource(int imageResource) {
        Drawable image = AppCompatResources.getDrawable((Context)this.getContext(), (int)imageResource);
        this.setImageDrawable(image);
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.isListenForRecord()) {
            switch (event.getAction()) {
                case 0: {
                    this.recordView.onActionDown((RecordButton)v, event);
                    break;
                }
                case 2: {
                    this.recordView.onActionMove((RecordButton)v, event);
                    break;
                }
                case 1: {
                    this.recordView.onActionUp((RecordButton)v);
                }
            }
        }
        return this.isListenForRecord();
    }

    protected void startScale() {
        this.scaleAnim.start();
    }

    protected void stopScale() {
        this.scaleAnim.stop();
    }

    public void setListenForRecord(boolean listenForRecord) {
        this.listenForRecord = listenForRecord;
    }

    public boolean isListenForRecord() {
        return this.listenForRecord;
    }

    public void setOnRecordClickListener(OnRecordClickListener onRecordClickListener) {
        this.onRecordClickListener = onRecordClickListener;
    }

    public void onClick(View v) {
        if (this.onRecordClickListener != null) {
            this.onRecordClickListener.onClick(v);
        }
    }
}

