/*
 * Decompiled with CFR 0.152.
 */
package com.devlomi.record_view;

import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import androidx.vectordrawable.graphics.drawable.AnimatorInflaterCompat;
import com.devlomi.record_view.OnBasketAnimationEnd;
import com.devlomi.record_view.R;
import com.devlomi.record_view.RecordButton;

public class AnimationHelper {
    private Context context;
    private AnimatedVectorDrawableCompat animatedVectorDrawable;
    private ImageView basketImg;
    private ImageView smallBlinkingMic;
    private AlphaAnimation alphaAnimation;
    private OnBasketAnimationEnd onBasketAnimationEndListener;
    private boolean isBasketAnimating;
    private boolean isStartRecorded = false;
    private float micX;
    private float micY = 0.0f;
    private AnimatorSet micAnimation;
    private TranslateAnimation translateAnimation1;
    private TranslateAnimation translateAnimation2;
    private Handler handler1;
    private Handler handler2;
    private boolean recordButtonGrowingAnimationEnabled;

    public AnimationHelper(Context context, ImageView basketImg, ImageView smallBlinkingMic, boolean recordButtonGrowingAnimationEnabled) {
        this.context = context;
        this.smallBlinkingMic = smallBlinkingMic;
        this.basketImg = basketImg;
        this.animatedVectorDrawable = AnimatedVectorDrawableCompat.create((Context)context, (int)R.drawable.recv_basket_animated);
        this.recordButtonGrowingAnimationEnabled = recordButtonGrowingAnimationEnabled;
    }

    public void setTrashIconColor(int color) {
        this.animatedVectorDrawable.setColorFilter(color, PorterDuff.Mode.SRC_IN);
    }

    public void setRecordButtonGrowingAnimationEnabled(boolean recordButtonGrowingAnimationEnabled) {
        this.recordButtonGrowingAnimationEnabled = recordButtonGrowingAnimationEnabled;
    }

    @SuppressLint(value={"RestrictedApi"})
    public void animateBasket(float basketInitialY) {
        this.isBasketAnimating = true;
        this.clearAlphaAnimation(false);
        if (this.micX == 0.0f) {
            this.micX = this.smallBlinkingMic.getX();
            this.micY = this.smallBlinkingMic.getY();
        }
        this.micAnimation = (AnimatorSet)AnimatorInflaterCompat.loadAnimator((Context)this.context, (int)R.animator.delete_mic_animation);
        this.micAnimation.setTarget((Object)this.smallBlinkingMic);
        this.translateAnimation1 = new TranslateAnimation(0.0f, 0.0f, basketInitialY, basketInitialY - 90.0f);
        this.translateAnimation1.setDuration(250L);
        this.translateAnimation2 = new TranslateAnimation(0.0f, 0.0f, basketInitialY - 130.0f, basketInitialY);
        this.translateAnimation2.setDuration(350L);
        this.micAnimation.start();
        this.basketImg.setImageDrawable((Drawable)this.animatedVectorDrawable);
        this.handler1 = new Handler();
        this.handler1.postDelayed(new Runnable(){

            @Override
            public void run() {
                AnimationHelper.this.basketImg.setVisibility(0);
                AnimationHelper.this.basketImg.startAnimation((Animation)AnimationHelper.this.translateAnimation1);
            }
        }, 350L);
        this.translateAnimation1.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                AnimationHelper.this.animatedVectorDrawable.start();
                AnimationHelper.this.handler2 = new Handler();
                AnimationHelper.this.handler2.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AnimationHelper.this.basketImg.startAnimation((Animation)AnimationHelper.this.translateAnimation2);
                        AnimationHelper.this.smallBlinkingMic.setVisibility(4);
                        AnimationHelper.this.basketImg.setVisibility(4);
                    }
                }, 450L);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.translateAnimation2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                AnimationHelper.this.basketImg.setVisibility(4);
                AnimationHelper.this.isBasketAnimating = false;
                if (AnimationHelper.this.onBasketAnimationEndListener != null && !AnimationHelper.this.isStartRecorded) {
                    AnimationHelper.this.onBasketAnimationEndListener.onAnimationEnd();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    public void resetBasketAnimation() {
        if (this.isBasketAnimating) {
            this.translateAnimation1.reset();
            this.translateAnimation1.cancel();
            this.translateAnimation2.reset();
            this.translateAnimation2.cancel();
            this.micAnimation.cancel();
            this.smallBlinkingMic.clearAnimation();
            this.basketImg.clearAnimation();
            if (this.handler1 != null) {
                this.handler1.removeCallbacksAndMessages(null);
            }
            if (this.handler2 != null) {
                this.handler2.removeCallbacksAndMessages(null);
            }
            this.basketImg.setVisibility(4);
            this.smallBlinkingMic.setX(this.micX);
            this.smallBlinkingMic.setY(this.micY);
            this.smallBlinkingMic.setVisibility(8);
            this.isBasketAnimating = false;
        }
    }

    public void clearAlphaAnimation(boolean hideView) {
        this.alphaAnimation.cancel();
        this.alphaAnimation.reset();
        this.smallBlinkingMic.clearAnimation();
        if (hideView) {
            this.smallBlinkingMic.setVisibility(8);
        }
    }

    public void animateSmallMicAlpha() {
        this.alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        this.alphaAnimation.setDuration(500L);
        this.alphaAnimation.setRepeatMode(2);
        this.alphaAnimation.setRepeatCount(-1);
        this.smallBlinkingMic.startAnimation((Animation)this.alphaAnimation);
    }

    public void moveRecordButtonAndSlideToCancelBack(final RecordButton recordBtn, FrameLayout slideToCancelLayout, float initialX, float difX) {
        ValueAnimator positionAnimator = ValueAnimator.ofFloat((float[])new float[]{recordBtn.getX(), initialX});
        positionAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        positionAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float x = ((Float)animation.getAnimatedValue()).floatValue();
                recordBtn.setX(x);
            }
        });
        if (this.recordButtonGrowingAnimationEnabled) {
            recordBtn.stopScale();
        }
        positionAnimator.setDuration(0L);
        positionAnimator.start();
        if (difX != 0.0f) {
            float x = initialX - difX;
            slideToCancelLayout.animate().x(x).setDuration(0L).start();
        }
    }

    public void resetSmallMic() {
        this.smallBlinkingMic.setAlpha(1.0f);
        this.smallBlinkingMic.setScaleX(1.0f);
        this.smallBlinkingMic.setScaleY(1.0f);
    }

    public void setOnBasketAnimationEndListener(OnBasketAnimationEnd onBasketAnimationEndListener) {
        this.onBasketAnimationEndListener = onBasketAnimationEndListener;
    }

    protected void onAnimationEnd() {
        if (this.onBasketAnimationEndListener != null) {
            this.onBasketAnimationEndListener.onAnimationEnd();
        }
    }

    public void setStartRecorded(boolean startRecorded) {
        this.isStartRecorded = startRecorded;
    }
}

