/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;

public final class Absolute {
    public static URI uri(String uri) {
        try {
            URL url = new URL(uri);
            String decodedPath = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8);
            URI decodedUri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), decodedPath, url.getQuery(), url.getRef());
            return Absolute.checkFileAuthorityAndReturnURI(decodedUri);
        }
        catch (MalformedURLException | URISyntaxException e) {
            return Absolute.uri(URI.create(uri));
        }
    }

    public static URI uri(URI uri) {
        URI decodedUri = URI.create(uri.getScheme() + ":" + Absolute.encodePath(uri.getSchemeSpecificPart()));
        return Absolute.checkFileAuthorityAndReturnURI(decodedUri);
    }

    public static URI uri(File file) {
        return Absolute.uri(Absolute.path(file).toUri());
    }

    public static Path path(String path) {
        return Absolute.path(Path.of(path, new String[0]));
    }

    public static Path path(URI uri) {
        return Absolute.path(Path.of(Absolute.uri(uri)));
    }

    public static Path path(Path path) {
        return Absolute.path(path.toFile());
    }

    public static Path path(File file) {
        return file.getCanonicalFile().toPath().toAbsolutePath();
    }

    private static String encodePath(String path) {
        return path.replace(" ", "%20").replace("[", "%91").replace("]", "%93").replace("?", "%3F").replace("{", "%7B").replace("}", "%7D").replace(":", "%3A").replace("\"", "%22").replace("\\", "%5C");
    }

    private static URI checkFileAuthorityAndReturnURI(URI uri) {
        if ("file".equals(uri.getScheme()) && uri.getAuthority() == null) {
            return Absolute.path(new File(uri)).toUri();
        }
        return uri;
    }

    @Generated
    private Absolute() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

