/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.utils;

import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.mdclasses.utils.MDOPathUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public final class MDOUtils {
    private static final Map<MDOType, Set<ModuleType>> MODULE_TYPES_FOR_MDO_TYPES = MDOUtils.moduleTypesForMDOTypes();

    public static ConfigurationSource getConfigurationSourceByPath(Path rootPath) {
        ConfigurationSource configurationSource = ConfigurationSource.EMPTY;
        if (rootPath != null) {
            String rootPathString = rootPath.toString();
            File rootConfiguration = new File(rootPathString, "Configuration.xml");
            if (rootConfiguration.exists()) {
                configurationSource = ConfigurationSource.DESIGNER;
            } else {
                rootConfiguration = Paths.get(rootPathString, "src", MDOType.CONFIGURATION.getName(), "Configuration.mdo").toFile();
                if (rootConfiguration.exists()) {
                    configurationSource = ConfigurationSource.EDT;
                }
            }
        }
        return configurationSource;
    }

    public static ConfigurationSource getConfigurationSourceByMDOPath(Path path) {
        if (path.toString().endsWith(MDOPathUtils.mdoExtension(ConfigurationSource.DESIGNER, true))) {
            return ConfigurationSource.DESIGNER;
        }
        return ConfigurationSource.EDT;
    }

    public static Map<MDOType, Set<ModuleType>> getModuleTypesForMdoTypes() {
        return MODULE_TYPES_FOR_MDO_TYPES;
    }

    private static Map<MDOType, Set<ModuleType>> moduleTypesForMDOTypes() {
        EnumMap<MDOType, Set<ModuleType>> result = new EnumMap<MDOType, Set<ModuleType>>(MDOType.class);
        for (MDOType mdoType : MDOType.values()) {
            HashSet<ModuleType> types = new HashSet<ModuleType>();
            switch (mdoType) {
                case INTEGRATION_SERVICE: {
                    types.add(ModuleType.IntegrationServiceModule);
                    break;
                }
                case BOT: {
                    types.add(ModuleType.BotModule);
                    break;
                }
                case ACCOUNTING_REGISTER: 
                case ACCUMULATION_REGISTER: 
                case CALCULATION_REGISTER: 
                case INFORMATION_REGISTER: {
                    types.add(ModuleType.ManagerModule);
                    types.add(ModuleType.RecordSetModule);
                    break;
                }
                case BUSINESS_PROCESS: 
                case CATALOG: 
                case CHART_OF_ACCOUNTS: 
                case CHART_OF_CALCULATION_TYPES: 
                case CHART_OF_CHARACTERISTIC_TYPES: 
                case DATA_PROCESSOR: 
                case DOCUMENT: 
                case EXCHANGE_PLAN: 
                case REPORT: 
                case TASK: {
                    types.add(ModuleType.ManagerModule);
                    types.add(ModuleType.ObjectModule);
                    break;
                }
                case COMMAND_GROUP: 
                case COMMON_ATTRIBUTE: 
                case COMMON_PICTURE: 
                case COMMON_TEMPLATE: 
                case DEFINED_TYPE: 
                case DOCUMENT_NUMERATOR: 
                case EVENT_SUBSCRIPTION: 
                case FUNCTIONAL_OPTION: 
                case ROLE: 
                case SCHEDULED_JOB: 
                case SESSION_PARAMETER: 
                case STYLE_ITEM: 
                case STYLE: 
                case SUBSYSTEM: 
                case WS_REFERENCE: 
                case XDTO_PACKAGE: {
                    break;
                }
                case COMMON_COMMAND: 
                case COMMAND: {
                    types.add(ModuleType.CommandModule);
                    break;
                }
                case COMMON_FORM: 
                case FORM: {
                    types.add(ModuleType.FormModule);
                    break;
                }
                case COMMON_MODULE: {
                    types.add(ModuleType.CommonModule);
                    break;
                }
                case CONFIGURATION: {
                    types.add(ModuleType.ApplicationModule);
                    types.add(ModuleType.SessionModule);
                    types.add(ModuleType.ExternalConnectionModule);
                    types.add(ModuleType.ManagedApplicationModule);
                    types.add(ModuleType.OrdinaryApplicationModule);
                    break;
                }
                case CONSTANT: {
                    types.add(ModuleType.ValueManagerModule);
                    break;
                }
                case DOCUMENT_JOURNAL: 
                case ENUM: 
                case FILTER_CRITERION: 
                case SETTINGS_STORAGE: {
                    types.add(ModuleType.ManagerModule);
                    break;
                }
                case HTTP_SERVICE: {
                    types.add(ModuleType.HTTPServiceModule);
                    break;
                }
                case SEQUENCE: {
                    types.add(ModuleType.RecordSetModule);
                    break;
                }
                case WEB_SERVICE: {
                    types.add(ModuleType.WEBServiceModule);
                    break;
                }
            }
            result.put(mdoType, types);
        }
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MDOUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

