/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.utils;

import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.MDLanguage;
import com.github._1c_syntax.mdclasses.mdo.children.XDTOPackageData;
import com.github._1c_syntax.mdclasses.mdo.children.form.FormData;
import com.github._1c_syntax.mdclasses.mdo.children.template.DataCompositionSchema;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.RoleData;
import com.github._1c_syntax.mdclasses.mdo.support.ScriptVariant;
import com.github._1c_syntax.mdclasses.unmarshal.XStreamFactory;
import com.github._1c_syntax.mdclasses.utils.MDOPathUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;

public final class MDOFactory {
    public static Optional<AbstractMDObjectBase> readMDOConfiguration(ConfigurationSource configurationSource, Path rootPath) {
        return MDOPathUtils.getMDOPath(configurationSource, rootPath, MDOType.CONFIGURATION, MDOType.CONFIGURATION.getName()).flatMap(MDOFactory::readMDObject);
    }

    public static Optional<AbstractMDObjectBase> readMDObject(Path mdoPath) {
        Optional<AbstractMDObjectBase> mdo = Optional.ofNullable(MDOFactory.readMDO(mdoPath));
        mdo.ifPresent(AbstractMDObjectBase::supplement);
        return mdo;
    }

    public static AbstractMDObjectBase readMDO(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        AbstractMDObjectBase value = (AbstractMDObjectBase)XStreamFactory.fromXML(path.toFile());
        value.setPath(path);
        return value;
    }

    public static Optional<FormData> readFormData(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        FormData value = (FormData)XStreamFactory.fromXML(path.toFile());
        value.fillPlainChildren(value.getChildren());
        return Optional.of(value);
    }

    public static Optional<XDTOPackageData> readXDTOPackageData(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of((XDTOPackageData)XStreamFactory.fromXML(path.toFile()));
    }

    public static Optional<RoleData> readRoleData(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.ofNullable((RoleData)XStreamFactory.fromXML(path.toFile()));
    }

    public static Optional<DataCompositionSchema> readDataCompositionSchema(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        DataCompositionSchema value = (DataCompositionSchema)XStreamFactory.fromXML(path.toFile());
        value.fillPlainDataSets();
        return Optional.of(value);
    }

    public static MDLanguage fakeLanguage(ScriptVariant scriptVariant) {
        if (scriptVariant == ScriptVariant.ENGLISH) {
            return MDLanguage.ENGLISH;
        }
        return MDLanguage.RUSSIAN;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MDOFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

