/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.unmarshal.converters;

import com.github._1c_syntax.mdclasses.unmarshal.XStreamFactory;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerMDO;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerRootWrapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesignerMDOConverter
implements Converter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DesignerMDOConverter.class);
    private final Map<Class<?>, Constructor<?>> constructors = new ConcurrentHashMap();

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        String nodeName = reader.getNodeName();
        Class<?> realClass = XStreamFactory.getRealClass(nodeName);
        if (realClass == null) {
            throw new IllegalStateException("Unexpected type: " + nodeName);
        }
        DesignerMDO wrapperMDO = (DesignerMDO)context.convertAnother((Object)reader, DesignerMDO.class);
        wrapperMDO.setMdoPath(XStreamFactory.getCurrentPath(reader));
        return this.getConstructor(realClass).newInstance(wrapperMDO);
    }

    public boolean canConvert(Class type) {
        return type == DesignerRootWrapper.class;
    }

    private Constructor<?> getConstructor(Class<?> realClass) {
        return this.constructors.computeIfAbsent(realClass, realClazz -> {
            try {
                return realClazz.getDeclaredConstructor(DesignerMDO.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No constructor found: " + realClass.getCanonicalName());
            }
        });
    }
}

