/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.supportconf;

import com.github._1c_syntax.mdclasses.supportconf.GeneralSupportVariant;
import com.github._1c_syntax.mdclasses.supportconf.SupportConfiguration;
import com.github._1c_syntax.mdclasses.supportconf.SupportVariant;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseSupportData {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseSupportData.class);
    private static final String REGEX = "(?:,|\\n|^)(\"(?:(?:\"\")*[^\"]*)*\"|[^\",\\n]*|(?:\\n|$))";
    private static final Pattern patternSplit = Pattern.compile("(?:,|\\n|^)(\"(?:(?:\"\")*[^\"]*)*\"|[^\",\\n]*|(?:\\n|$))");
    private static final int POINT_COUNT_CONFIGURATION = 2;
    private static final int SHIFT_CONFIGURATION_VERSION = 3;
    private static final int SHIFT_CONFIGURATION_PRODUCER = 4;
    private static final int SHIFT_CONFIGURATION_NAME = 5;
    private static final int SHIFT_CONFIGURATION_COUNT_OBJECT = 6;
    private static final int SHIFT_OBJECT_COUNT = 7;
    private static final int COUNT_ELEMENT_OBJECT = 4;
    private static final int CONFIGURATION_SUPPORT = 1;
    private static final int START_READ_POSITION = 3;
    private static final int SHIFT_SIZE = 2;
    private final Path pathToBinFile;
    private final Map<String, Map<SupportConfiguration, SupportVariant>> supportMap = new HashMap<String, Map<SupportConfiguration, SupportVariant>>();

    public ParseSupportData(Path pathToBinFile) {
        this.pathToBinFile = pathToBinFile;
        LOGGER.debug("\u0427\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 ParentConfigurations.bin");
        try {
            this.read();
        }
        catch (FileNotFoundException exception) {
            LOGGER.error("\u041f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 ParentConfigurations.bin \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)exception);
        }
        catch (NumberFormatException exception) {
            LOGGER.error("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u0430\u0439\u043b ParentConfigurations.bin", (Throwable)exception);
            this.supportMap.clear();
        }
    }

    private void read() throws FileNotFoundException {
        String[] dataStrings;
        FileInputStream fileInputStream = new FileInputStream(this.pathToBinFile.toFile());
        try (Scanner scanner = new Scanner((InputStream)fileInputStream, StandardCharsets.UTF_8);){
            dataStrings = (String[])scanner.findAll(patternSplit).map(matchResult -> matchResult.group(1)).toArray(String[]::new);
        }
        int countConfiguration = Integer.parseInt(dataStrings[2]);
        LOGGER.debug("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439: {}", (Object)countConfiguration);
        int startPoint = 3;
        for (int numberConfiguration = 1; numberConfiguration <= countConfiguration; ++numberConfiguration) {
            String configurationVersion = dataStrings[startPoint + 3];
            String configurationProducer = dataStrings[startPoint + 4];
            String configurationName = dataStrings[startPoint + 5];
            int countObjectsConfiguration = Integer.parseInt(dataStrings[startPoint + 6]);
            int configurationSupport = Integer.parseInt(dataStrings[1]);
            GeneralSupportVariant configurationSupportVariant = ParseSupportData.getGeneralSupportVariantByInt(configurationSupport);
            SupportConfiguration supportConfiguration = new SupportConfiguration(configurationName, configurationProducer, configurationVersion);
            LOGGER.debug(String.format("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f: %s \u0412\u0435\u0440\u0441\u0438\u044f: %s \u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a: %s \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432: %s", configurationName, configurationVersion, configurationProducer, countObjectsConfiguration));
            int startObjectPoint = startPoint + 7;
            for (int numberObject = 0; numberObject < countObjectsConfiguration; ++numberObject) {
                int currentObjectPoint = startObjectPoint + numberObject * 4;
                int support = Integer.parseInt(dataStrings[currentObjectPoint]);
                String guidObject = dataStrings[currentObjectPoint + 2];
                SupportVariant supportVariant = configurationSupportVariant == GeneralSupportVariant.LOCKED ? SupportVariant.NOT_EDITABLE : ParseSupportData.getSupportVariantByInt(support);
                Map map = this.supportMap.computeIfAbsent(guidObject, k -> new HashMap());
                map.put(supportConfiguration, supportVariant);
            }
            startPoint = startObjectPoint + 2 + countObjectsConfiguration * 4;
        }
    }

    public Map<String, Map<SupportConfiguration, SupportVariant>> getSupportMap() {
        return this.supportMap;
    }

    private static GeneralSupportVariant getGeneralSupportVariantByInt(int support) {
        if (support == 0) {
            return GeneralSupportVariant.UNLOCKED;
        }
        return GeneralSupportVariant.LOCKED;
    }

    private static SupportVariant getSupportVariantByInt(int support) {
        switch (support) {
            case 0: {
                return SupportVariant.NOT_EDITABLE;
            }
            case 1: {
                return SupportVariant.EDITABLE_SUPPORT_ENABLED;
            }
            case 2: {
                return SupportVariant.NOT_SUPPORTED;
            }
        }
        return SupportVariant.NONE;
    }
}

