/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.mdo.children.form;

import com.github._1c_syntax.mdclasses.mdo.children.form.FormAttribute;
import com.github._1c_syntax.mdclasses.mdo.children.form.FormCommand;
import com.github._1c_syntax.mdclasses.mdo.children.form.FormHandlerItem;
import com.github._1c_syntax.mdclasses.mdo.children.form.FormItem;
import com.github._1c_syntax.mdclasses.mdo.support.DataPath;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.form.DesignerChildItems;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.form.DesignerForm;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.form.DesignerFormItem;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class FormData {
    private List<FormItem> plainChildren = new ArrayList<FormItem>();
    @XStreamImplicit
    private List<FormItem> children = new ArrayList<FormItem>();
    @XStreamImplicit
    private List<FormHandlerItem> handlers = Collections.emptyList();
    @XStreamImplicit
    private List<FormAttribute> attributes = Collections.emptyList();
    private boolean enabled = true;
    @XStreamAlias(value="formCommands")
    @XStreamImplicit
    private List<FormCommand> commands = Collections.emptyList();

    public FormData(DesignerForm designerForm) {
        FormData.fillChildrenItems(designerForm.getChildItems(), this.children);
        FormData.addDesignerFormItem(designerForm.getAutoCommandBar(), this.children);
        this.handlers = Optional.ofNullable(designerForm.getEvents()).map(designerEvents -> designerEvents.getChildren().stream().map(FormHandlerItem::new).collect(Collectors.toList())).orElse(Collections.emptyList());
        this.attributes = Optional.ofNullable(designerForm.getAttributes()).map(designerAttributes -> designerAttributes.getChildren().stream().map(FormAttribute::new).collect(Collectors.toList())).orElse(Collections.emptyList());
        this.commands = Optional.ofNullable(designerForm.getCommands()).map(designerFormCommands -> designerFormCommands.getChildren().stream().map(FormCommand::new).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static void fillChildrenItems(DesignerChildItems designerChildItems, List<FormItem> list) {
        if (designerChildItems == null) {
            return;
        }
        designerChildItems.getChildren().forEach(formItem -> list.add(FormData.newFormItem(formItem)));
    }

    private static FormItem newFormItem(DesignerFormItem designerFormItem) {
        FormItem formItem = new FormItem();
        formItem.setName(designerFormItem.getName());
        formItem.setId(designerFormItem.getId());
        if (designerFormItem.getDataPath() != null) {
            DataPath dataPath = new DataPath(designerFormItem.getDataPath());
            formItem.setDataPath(dataPath);
        }
        formItem.setType(designerFormItem.getType());
        FormData.addDesignerFormItem(designerFormItem.getContextMenu(), formItem.getChildren());
        FormData.addDesignerFormItem(designerFormItem.getExtendedTooltip(), formItem.getChildren());
        FormData.addDesignerFormItem(designerFormItem.getAutoCommandBar(), formItem.getChildren());
        FormData.addDesignerFormItem(designerFormItem.getSearchStringAddition(), formItem.getChildren());
        FormData.addDesignerFormItem(designerFormItem.getViewStatusAddition(), formItem.getChildren());
        if (designerFormItem.getChildItems() != null) {
            FormData.fillChildrenItems(designerFormItem.getChildItems(), formItem.getChildren());
        }
        if (designerFormItem.getEvents() != null) {
            List<FormHandlerItem> handlers = designerFormItem.getEvents().getChildren().stream().map(FormHandlerItem::new).collect(Collectors.toList());
            formItem.setHandlers(handlers);
        }
        return formItem;
    }

    private static void addDesignerFormItem(DesignerFormItem designerFormItem, List<FormItem> children) {
        if (designerFormItem != null) {
            children.add(FormData.newFormItem(designerFormItem));
        }
    }

    public void fillPlainChildren(List<FormItem> itemList) {
        itemList.forEach(formItem -> {
            this.plainChildren.add((FormItem)formItem);
            this.fillPlainChildren(formItem.getChildren());
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<FormItem> getPlainChildren() {
        return this.plainChildren;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<FormItem> getChildren() {
        return this.children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<FormHandlerItem> getHandlers() {
        return this.handlers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<FormAttribute> getAttributes() {
        return this.attributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<FormCommand> getCommands() {
        return this.commands;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPlainChildren(List<FormItem> plainChildren) {
        this.plainChildren = plainChildren;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChildren(List<FormItem> children) {
        this.children = children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHandlers(List<FormHandlerItem> handlers) {
        this.handlers = handlers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAttributes(List<FormAttribute> attributes) {
        this.attributes = attributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCommands(List<FormCommand> commands) {
        this.commands = commands;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormData)) {
            return false;
        }
        FormData other = (FormData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        List<FormItem> this$plainChildren = this.getPlainChildren();
        List<FormItem> other$plainChildren = other.getPlainChildren();
        if (this$plainChildren == null ? other$plainChildren != null : !((Object)this$plainChildren).equals(other$plainChildren)) {
            return false;
        }
        List<FormItem> this$children = this.getChildren();
        List<FormItem> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        List<FormHandlerItem> this$handlers = this.getHandlers();
        List<FormHandlerItem> other$handlers = other.getHandlers();
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        List<FormAttribute> this$attributes = this.getAttributes();
        List<FormAttribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<FormCommand> this$commands = this.getCommands();
        List<FormCommand> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FormData;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        List<FormItem> $plainChildren = this.getPlainChildren();
        result = result * 59 + ($plainChildren == null ? 43 : ((Object)$plainChildren).hashCode());
        List<FormItem> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        List<FormHandlerItem> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        List<FormAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<FormCommand> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "FormData()";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FormData() {
    }
}

