/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.mdo;

import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.support.MDOModule;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerMDO;
import com.github._1c_syntax.mdclasses.utils.MDOPathUtils;
import com.github._1c_syntax.mdclasses.utils.MDOUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public abstract class AbstractMDObjectBSL
extends AbstractMDObjectBase {
    private List<MDOModule> modules = Collections.emptyList();

    protected AbstractMDObjectBSL(DesignerMDO designerMDO) {
        super(designerMDO);
    }

    @Override
    public void supplement() {
        super.supplement();
        MDOPathUtils.getMDOTypeFolderByMDOPath(this.path, this.getType()).ifPresent(this::computeAndSetModules);
    }

    @Override
    public void supplement(AbstractMDObjectBase parent) {
        super.supplement(parent);
        MDOPathUtils.getMDOTypeFolderByMDOPath(parent.getPath(), parent.getType()).flatMap(folder -> MDOPathUtils.getChildrenFolder(parent.getName(), folder, this.getType())).ifPresent(this::computeAndSetModules);
    }

    private void computeAndSetModules(Path folder) {
        Set<ModuleType> moduleTypes = MDOUtils.getModuleTypesForMdoTypes().getOrDefault((Object)this.getType(), Collections.emptySet());
        if (moduleTypes.isEmpty()) {
            return;
        }
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByMDOPath(this.path);
        String mdoName = this.getType() == MDOType.CONFIGURATION ? "" : this.getName();
        ArrayList<MDOModule> mdoModules = new ArrayList<MDOModule>();
        moduleTypes.forEach(moduleType -> MDOPathUtils.getModulePath(configurationSource, folder, mdoName, moduleType).ifPresent(modulePath -> {
            if (modulePath.toFile().exists()) {
                mdoModules.add(new MDOModule((ModuleType)((Object)moduleType), modulePath.toUri(), this));
            }
        }));
        this.setModules(mdoModules);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<MDOModule> getModules() {
        return this.modules;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setModules(List<MDOModule> modules) {
        this.modules = modules;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMDObjectBSL)) {
            return false;
        }
        AbstractMDObjectBSL other = (AbstractMDObjectBSL)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<MDOModule> this$modules = this.getModules();
        List<MDOModule> other$modules = other.getModules();
        return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractMDObjectBSL;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<MDOModule> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        return result;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AbstractMDObjectBSL(super=" + super.toString() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractMDObjectBSL() {
    }
}

