/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser.description;

import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionParser;
import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionTokenizer;
import com.github._1c_syntax.bsl.parser.description.SourceDefinedSymbolDescription;
import com.github._1c_syntax.bsl.parser.description.support.DescriptionReader;
import com.github._1c_syntax.bsl.parser.description.support.ParameterDescription;
import com.github._1c_syntax.bsl.parser.description.support.SimpleRange;
import com.github._1c_syntax.bsl.parser.description.support.TypeDescription;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;

public final class MethodDescription
implements SourceDefinedSymbolDescription {
    private final String description;
    private final String deprecationInfo;
    private final boolean deprecated;
    private final String purposeDescription;
    private final List<String> examples;
    private final List<String> callOptions;
    private final List<ParameterDescription> parameters;
    private final List<TypeDescription> returnedValue;
    private final String link;
    private final SimpleRange range;

    MethodDescription(List<Token> comments) {
        this.description = comments.stream().map(Token::getText).collect(Collectors.joining("\n"));
        BSLMethodDescriptionTokenizer tokenizer = new BSLMethodDescriptionTokenizer(this.description);
        BSLMethodDescriptionParser.MethodDescriptionContext ast = Objects.requireNonNull((BSLMethodDescriptionParser.MethodDescriptionContext)((Object)tokenizer.getAst()));
        this.purposeDescription = DescriptionReader.readPurposeDescription(ast);
        this.link = DescriptionReader.readLink(ast);
        this.deprecated = ast.deprecate() != null;
        this.deprecationInfo = DescriptionReader.readDeprecationInfo(ast);
        this.callOptions = DescriptionReader.readCallOptions(ast);
        this.examples = DescriptionReader.readExamples(ast);
        this.parameters = DescriptionReader.readParameters(ast);
        this.returnedValue = DescriptionReader.readReturnedValue(ast);
        this.range = SimpleRange.create(comments);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDeprecationInfo() {
        return this.deprecationInfo;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public String getPurposeDescription() {
        return this.purposeDescription;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public SimpleRange getSimpleRange() {
        return this.range;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public List<String> getCallOptions() {
        return this.callOptions;
    }

    public List<ParameterDescription> getParameters() {
        return this.parameters;
    }

    public List<TypeDescription> getReturnedValue() {
        return this.returnedValue;
    }
}

