/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import cn.forward.androids.utils.ImageUtils;
import cn.forward.androids.utils.LogUtil;
import cn.forward.androids.utils.Util;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleShape;
import cn.hzw.doodle.IDoodleListener;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleColor;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodlePen;
import cn.hzw.doodle.core.IDoodleShape;
import cn.hzw.doodle.core.IDoodleTouchDetector;
import cn.hzw.doodle.util.DrawUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DoodleView
extends FrameLayout
implements IDoodle {
    public static final String TAG = "DoodleView";
    public static final float MAX_SCALE = 5.0f;
    public static final float MIN_SCALE = 0.25f;
    public static final int DEFAULT_SIZE = 6;
    public static final int ERROR_INIT = -1;
    public static final int ERROR_SAVE = -2;
    private static final int FLAG_RESET_BACKGROUND = 2;
    private static final int FLAG_DRAW_PENDINGS_TO_BACKGROUND = 4;
    private static final int FLAG_REFRESH_BACKGROUND = 8;
    private IDoodleListener mDoodleListener;
    private final Bitmap mBitmap;
    private float mCenterScale;
    private int mCenterHeight;
    private int mCenterWidth;
    private float mCentreTranX;
    private float mCentreTranY;
    private float mRotateScale = 1.0f;
    private float mRotateTranX;
    private float mRotateTranY;
    private float mScale = 1.0f;
    private float mTransX = 0.0f;
    private float mTransY = 0.0f;
    private float mMinScale = 0.25f;
    private float mMaxScale = 5.0f;
    private float mSize;
    private IDoodleColor mColor;
    private boolean isJustDrawOriginal;
    private boolean mIsDrawableOutside = false;
    private boolean mReady = false;
    private List<IDoodleItem> mItemStack = new ArrayList<IDoodleItem>();
    private List<IDoodleItem> mRedoItemStack = new ArrayList<IDoodleItem>();
    private IDoodlePen mPen;
    private IDoodleShape mShape;
    private float mTouchX;
    private float mTouchY;
    private boolean mEnableZoomer = false;
    private boolean mEnableOverview = true;
    private float mLastZoomerY;
    private float mZoomerRadius;
    private Path mZoomerPath;
    private float mZoomerScale = 0.0f;
    private Paint mZooomerPaint;
    private Paint mZoomerTouchPaint;
    private int mZoomerHorizonX;
    private boolean mIsScrollingDoodle = false;
    private float mDoodleSizeUnit = 1.0f;
    private int mDoodleRotateDegree = 0;
    private IDoodleTouchDetector mDefaultTouchDetector;
    private Map<IDoodlePen, IDoodleTouchDetector> mTouchDetectorMap = new HashMap<IDoodlePen, IDoodleTouchDetector>();
    private ForegroundView mForegroundView;
    private RectF mDoodleBound = new RectF();
    private PointF mTempPoint = new PointF();
    private boolean mIsEditMode = false;
    private boolean mIsSaving = false;
    private final boolean mOptimizeDrawing;
    private List<IDoodleItem> mItemStackOnViewCanvas = new ArrayList<IDoodleItem>();
    private List<IDoodleItem> mPendingItemsDrawToBitmap = new ArrayList<IDoodleItem>();
    private Bitmap mDoodleBitmap;
    private int mFlags = 0;
    private Canvas mDoodleBitmapCanvas;
    private BackgroundView mBackgroundView;
    private Matrix mTouchEventMatrix = new Matrix();
    private View.OnTouchListener mOnTouchListener;

    public DoodleView(Context context, Bitmap bitmap, IDoodleListener listener) {
        this(context, bitmap, false, listener, null);
    }

    public DoodleView(Context context, Bitmap bitmap, IDoodleListener listener, IDoodleTouchDetector defaultDetector) {
        this(context, bitmap, false, listener, defaultDetector);
    }

    public DoodleView(Context context, Bitmap bitmap, boolean optimizeDrawing, IDoodleListener listener) {
        this(context, bitmap, optimizeDrawing, listener, null);
    }

    public DoodleView(Context context, Bitmap bitmap, boolean optimizeDrawing, IDoodleListener listener, IDoodleTouchDetector defaultDetector) {
        super(context);
        this.setClipChildren(false);
        this.mBitmap = bitmap;
        if (this.mBitmap.getConfig() != Bitmap.Config.RGB_565) {
            LogUtil.w((String)TAG, (String)"the bitmap may contain alpha, which will cause eraser don't work well.");
        }
        this.mDoodleListener = listener;
        if (this.mDoodleListener == null) {
            throw new RuntimeException("IDoodleListener is null!!!");
        }
        if (this.mBitmap == null) {
            throw new RuntimeException("Bitmap is null!!!");
        }
        this.mOptimizeDrawing = optimizeDrawing;
        this.mScale = 1.0f;
        this.mColor = new DoodleColor(-65536);
        this.mPen = DoodlePen.BRUSH;
        this.mShape = DoodleShape.HAND_WRITE;
        this.mZooomerPaint = new Paint();
        this.mZooomerPaint.setColor(-1426063361);
        this.mZooomerPaint.setStyle(Paint.Style.STROKE);
        this.mZooomerPaint.setAntiAlias(true);
        this.mZooomerPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mZooomerPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mZooomerPaint.setStrokeWidth((float)Util.dp2px((Context)this.getContext(), (float)10.0f));
        this.mZoomerTouchPaint = new Paint();
        this.mZoomerTouchPaint.setStyle(Paint.Style.STROKE);
        this.mZoomerTouchPaint.setAntiAlias(true);
        this.mZoomerTouchPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mZoomerTouchPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mDefaultTouchDetector = defaultDetector;
        this.mForegroundView = new ForegroundView(context);
        this.mBackgroundView = new BackgroundView(context);
        this.addView(this.mBackgroundView, new ViewGroup.LayoutParams(-1, -1));
        this.addView(this.mForegroundView, new ViewGroup.LayoutParams(-1, -1));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.init();
        if (!this.mReady) {
            this.mDoodleListener.onReady(this);
            this.mReady = true;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mOnTouchListener != null && this.mOnTouchListener.onTouch((View)this, event)) {
            return true;
        }
        this.mTouchX = event.getX();
        this.mTouchY = event.getY();
        MotionEvent transformedEvent = MotionEvent.obtain((MotionEvent)event);
        this.mTouchEventMatrix.reset();
        this.mTouchEventMatrix.setRotate((float)(-this.mDoodleRotateDegree), (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        transformedEvent.transform(this.mTouchEventMatrix);
        boolean handled = this.mForegroundView.onTouchEvent(transformedEvent);
        transformedEvent.recycle();
        return handled;
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mOnTouchListener = l;
        super.setOnTouchListener(l);
    }

    private void init() {
        float nh;
        int w = this.mBitmap.getWidth();
        int h = this.mBitmap.getHeight();
        float nw = (float)w * 1.0f / (float)this.getWidth();
        if (nw > (nh = (float)h * 1.0f / (float)this.getHeight())) {
            this.mCenterScale = 1.0f / nw;
            this.mCenterWidth = this.getWidth();
            this.mCenterHeight = (int)((float)h * this.mCenterScale);
        } else {
            this.mCenterScale = 1.0f / nh;
            this.mCenterWidth = (int)((float)w * this.mCenterScale);
            this.mCenterHeight = this.getHeight();
        }
        this.mCentreTranX = (float)(this.getWidth() - this.mCenterWidth) / 2.0f;
        this.mCentreTranY = (float)(this.getHeight() - this.mCenterHeight) / 2.0f;
        this.mZoomerRadius = Math.min(this.getWidth(), this.getHeight()) / 4;
        this.mZoomerPath = new Path();
        this.mZoomerPath.addCircle(this.mZoomerRadius, this.mZoomerRadius, this.mZoomerRadius, Path.Direction.CCW);
        this.mZoomerHorizonX = (int)((float)(Math.min(this.getWidth(), this.getHeight()) / 2) - this.mZoomerRadius);
        this.mDoodleSizeUnit = (float)Util.dp2px((Context)this.getContext(), (float)1.0f) / this.mCenterScale;
        if (!this.mReady) {
            this.mSize = 6.0f * this.mDoodleSizeUnit;
        }
        this.mTransY = 0.0f;
        this.mTransX = 0.0f;
        this.mScale = 1.0f;
        this.initDoodleBitmap();
        this.refreshWithBackground();
    }

    private void initDoodleBitmap() {
        if (!this.mOptimizeDrawing) {
            return;
        }
        if (this.mDoodleBitmap != null) {
            this.mDoodleBitmap.recycle();
        }
        this.mDoodleBitmap = this.mBitmap.copy(this.mBitmap.getConfig(), true);
        this.mDoodleBitmapCanvas = new Canvas(this.mDoodleBitmap);
    }

    public RectF getDoodleBound() {
        float width = (float)this.mCenterWidth * this.mRotateScale * this.mScale;
        float height = (float)this.mCenterHeight * this.mRotateScale * this.mScale;
        if (this.mDoodleRotateDegree % 90 == 0) {
            if (this.mDoodleRotateDegree == 0) {
                this.mTempPoint.x = this.toTouchX(0.0f);
                this.mTempPoint.y = this.toTouchY(0.0f);
            } else if (this.mDoodleRotateDegree == 90) {
                this.mTempPoint.x = this.toTouchX(0.0f);
                this.mTempPoint.y = this.toTouchY(this.mBitmap.getHeight());
                float t = width;
                width = height;
                height = t;
            } else if (this.mDoodleRotateDegree == 180) {
                this.mTempPoint.x = this.toTouchX(this.mBitmap.getWidth());
                this.mTempPoint.y = this.toTouchY(this.mBitmap.getHeight());
            } else if (this.mDoodleRotateDegree == 270) {
                this.mTempPoint.x = this.toTouchX(this.mBitmap.getWidth());
                this.mTempPoint.y = this.toTouchY(0.0f);
                float t = width;
                width = height;
                height = t;
            }
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, this.mTempPoint.x, this.mTempPoint.y, this.getWidth() / 2, this.getHeight() / 2);
            this.mDoodleBound.set(this.mTempPoint.x, this.mTempPoint.y, this.mTempPoint.x + width, this.mTempPoint.y + height);
        } else {
            float ltX = this.toTouchX(0.0f);
            float ltY = this.toTouchY(0.0f);
            float rbX = this.toTouchX(this.mBitmap.getWidth());
            float rbY = this.toTouchY(this.mBitmap.getHeight());
            float lbX = this.toTouchX(0.0f);
            float lbY = this.toTouchY(this.mBitmap.getHeight());
            float rtX = this.toTouchX(this.mBitmap.getWidth());
            float rtY = this.toTouchY(0.0f);
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, ltX, ltY, this.getWidth() / 2, this.getHeight() / 2);
            ltX = this.mTempPoint.x;
            ltY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, rbX, rbY, this.getWidth() / 2, this.getHeight() / 2);
            rbX = this.mTempPoint.x;
            rbY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, lbX, lbY, this.getWidth() / 2, this.getHeight() / 2);
            lbX = this.mTempPoint.x;
            lbY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, rtX, rtY, this.getWidth() / 2, this.getHeight() / 2);
            rtX = this.mTempPoint.x;
            rtY = this.mTempPoint.y;
            this.mDoodleBound.left = Math.min(Math.min(ltX, rbX), Math.min(lbX, rtX));
            this.mDoodleBound.top = Math.min(Math.min(ltY, rbY), Math.min(lbY, rtY));
            this.mDoodleBound.right = Math.max(Math.max(ltX, rbX), Math.max(lbX, rtX));
            this.mDoodleBound.bottom = Math.max(Math.max(ltY, rbY), Math.max(lbY, rtY));
        }
        return this.mDoodleBound;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mBitmap.isRecycled()) {
            return;
        }
        if (this.hasFlag(2)) {
            LogUtil.d((String)TAG, (String)"FLAG_RESET_BACKGROUND");
            this.clearFlag(2);
            this.clearFlag(4);
            this.clearFlag(8);
            this.refreshDoodleBitmap(false);
            this.mPendingItemsDrawToBitmap.clear();
            this.mBackgroundView.invalidate();
        } else if (this.hasFlag(4)) {
            LogUtil.d((String)TAG, (String)"FLAG_DRAW_PENDINGS_TO_BACKGROUND");
            this.clearFlag(4);
            this.clearFlag(8);
            this.drawToDoodleBitmap(this.mPendingItemsDrawToBitmap);
            this.mPendingItemsDrawToBitmap.clear();
            this.mBackgroundView.invalidate();
        } else if (this.hasFlag(8)) {
            LogUtil.d((String)TAG, (String)"FLAG_REFRESH_BACKGROUND");
            this.clearFlag(8);
            this.mBackgroundView.invalidate();
        }
        int count = canvas.save();
        super.dispatchDraw(canvas);
        canvas.restoreToCount(count);
        if (this.mIsScrollingDoodle && this.mEnableZoomer && this.mZoomerScale > 0.0f) {
            canvas.save();
            float unitSize = this.getUnitSize();
            if (this.mTouchY <= this.mZoomerRadius * 2.0f) {
                this.mLastZoomerY = (float)this.getHeight() - this.mZoomerRadius * 2.0f;
            } else if (this.mTouchY >= (float)this.getHeight() - this.mZoomerRadius * 2.0f) {
                this.mLastZoomerY = 0.0f;
            }
            canvas.translate((float)this.mZoomerHorizonX, this.mLastZoomerY);
            canvas.clipPath(this.mZoomerPath);
            canvas.drawColor(-16777216);
            canvas.save();
            float scale = this.mZoomerScale / this.mScale;
            canvas.scale(scale, scale);
            canvas.translate(-this.mTouchX + this.mZoomerRadius / scale, -this.mTouchY + this.mZoomerRadius / scale);
            super.dispatchDraw(canvas);
            float left = this.getAllTranX();
            float top = this.getAllTranY();
            canvas.translate(left, top);
            scale = this.getAllScale();
            canvas.scale(scale, scale);
            this.mZoomerTouchPaint.setStrokeWidth(unitSize / 2.0f);
            float radius = this.mSize / 2.0f - unitSize / 2.0f;
            float radius2 = radius - unitSize / 2.0f;
            if (radius <= 1.0f) {
                radius = 1.0f;
                radius2 = radius / 2.0f;
                this.mZoomerTouchPaint.setStrokeWidth(this.mSize);
            }
            this.mZoomerTouchPaint.setColor(-1442840576);
            DrawUtil.drawCircle(canvas, this.toX(this.mTouchX), this.toY(this.mTouchY), radius, this.mZoomerTouchPaint);
            this.mZoomerTouchPaint.setColor(-1426063361);
            DrawUtil.drawCircle(canvas, this.toX(this.mTouchX), this.toY(this.mTouchY), radius2, this.mZoomerTouchPaint);
            canvas.restore();
            DrawUtil.drawCircle(canvas, this.mZoomerRadius, this.mZoomerRadius, this.mZoomerRadius, this.mZooomerPaint);
            canvas.restore();
            canvas.save();
            canvas.translate((float)this.mZoomerHorizonX, this.mLastZoomerY);
            scale = this.mZoomerRadius / 2.0f / (float)this.getWidth();
            canvas.scale(scale, scale);
            float strokeWidth = 1.0f / scale;
            canvas.clipRect(-strokeWidth, -strokeWidth, (float)this.getWidth() + strokeWidth, (float)this.getHeight() + strokeWidth);
            canvas.drawColor(-2004318072);
            canvas.save();
            float tempScale = this.mScale;
            float tempTransX = this.mTransX;
            float tempTransY = this.mTransY;
            this.mScale = 1.0f;
            this.mTransY = 0.0f;
            this.mTransX = 0.0f;
            super.dispatchDraw(canvas);
            this.mScale = tempScale;
            this.mTransX = tempTransX;
            this.mTransY = tempTransY;
            canvas.restore();
            this.mZoomerTouchPaint.setStrokeWidth(strokeWidth);
            this.mZoomerTouchPaint.setColor(-1442840576);
            DrawUtil.drawRect(canvas, 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.mZoomerTouchPaint);
            this.mZoomerTouchPaint.setColor(-1426063361);
            DrawUtil.drawRect(canvas, strokeWidth, strokeWidth, (float)this.getWidth() - strokeWidth, (float)this.getHeight() - strokeWidth, this.mZoomerTouchPaint);
            canvas.restore();
        }
    }

    private boolean hasFlag(int flag) {
        return (this.mFlags & flag) != 0;
    }

    private void addFlag(int flag) {
        this.mFlags |= flag;
    }

    private void clearFlag(int flag) {
        this.mFlags &= ~flag;
    }

    public float getAllScale() {
        return this.mCenterScale * this.mRotateScale * this.mScale;
    }

    public float getAllTranX() {
        return this.mCentreTranX + this.mRotateTranX + this.mTransX;
    }

    public float getAllTranY() {
        return this.mCentreTranY + this.mRotateTranY + this.mTransY;
    }

    public final float toX(float touchX) {
        return (touchX - this.getAllTranX()) / this.getAllScale();
    }

    public final float toY(float touchY) {
        return (touchY - this.getAllTranY()) / this.getAllScale();
    }

    public final float toTouchX(float x) {
        return x * this.getAllScale() + this.getAllTranX();
    }

    public final float toTouchY(float y) {
        return y * this.getAllScale() + this.getAllTranY();
    }

    public final float toTransX(float touchX, float doodleX) {
        return -doodleX * this.getAllScale() + touchX - this.mCentreTranX - this.mRotateTranX;
    }

    public final float toTransY(float touchY, float doodleY) {
        return -doodleY * this.getAllScale() + touchY - this.mCentreTranY - this.mRotateTranY;
    }

    public void bindTouchDetector(IDoodlePen pen, IDoodleTouchDetector detector) {
        if (pen == null) {
            return;
        }
        this.mTouchDetectorMap.put(pen, detector);
    }

    public IDoodleTouchDetector getDefaultTouchDetector(IDoodlePen pen) {
        return this.mTouchDetectorMap.get(pen);
    }

    public void removeTouchDetector(IDoodlePen pen) {
        if (pen == null) {
            return;
        }
        this.mTouchDetectorMap.remove(pen);
    }

    public void setDefaultTouchDetector(IDoodleTouchDetector touchGestureDetector) {
        this.mDefaultTouchDetector = touchGestureDetector;
    }

    public IDoodleTouchDetector getDefaultTouchDetector() {
        return this.mDefaultTouchDetector;
    }

    private void drawToDoodleBitmap(List<IDoodleItem> items) {
        if (!this.mOptimizeDrawing) {
            return;
        }
        for (IDoodleItem item : items) {
            item.draw(this.mDoodleBitmapCanvas);
        }
    }

    private void refreshDoodleBitmap(boolean drawAll) {
        if (!this.mOptimizeDrawing) {
            return;
        }
        this.initDoodleBitmap();
        List<IDoodleItem> items = null;
        if (drawAll) {
            items = this.mItemStack;
        } else {
            items = new ArrayList<IDoodleItem>(this.mItemStack);
            items.removeAll(this.mItemStackOnViewCanvas);
        }
        for (IDoodleItem item : items) {
            item.draw(this.mDoodleBitmapCanvas);
        }
    }

    private void refreshWithBackground() {
        this.addFlag(8);
        this.refresh();
    }

    public void invalidate() {
        this.refresh();
    }

    @Override
    public void refresh() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            super.invalidate();
            this.mForegroundView.invalidate();
        } else {
            super.postInvalidate();
            this.mForegroundView.postInvalidate();
        }
    }

    @Override
    public int getDoodleRotation() {
        return this.mDoodleRotateDegree;
    }

    @Override
    public void setDoodleRotation(int degree) {
        float nh;
        this.mDoodleRotateDegree = degree;
        this.mDoodleRotateDegree %= 360;
        if (this.mDoodleRotateDegree < 0) {
            this.mDoodleRotateDegree = 360 + this.mDoodleRotateDegree;
        }
        RectF rectF = this.getDoodleBound();
        int w = (int)(rectF.width() / this.getAllScale());
        int h = (int)(rectF.height() / this.getAllScale());
        float nw = (float)w * 1.0f / (float)this.getWidth();
        float scale = nw > (nh = (float)h * 1.0f / (float)this.getHeight()) ? 1.0f / nw : 1.0f / nh;
        int pivotX = this.mBitmap.getWidth() / 2;
        int pivotY = this.mBitmap.getHeight() / 2;
        this.mTransY = 0.0f;
        this.mTransX = 0.0f;
        this.mRotateTranY = 0.0f;
        this.mRotateTranX = 0.0f;
        this.mScale = 1.0f;
        this.mRotateScale = 1.0f;
        float touchX = this.toTouchX(pivotX);
        float touchY = this.toTouchY(pivotY);
        this.mRotateScale = scale / this.mCenterScale;
        float tx = this.toTransX(touchX, pivotX);
        float ty = this.toTransY(touchY, pivotY);
        this.mRotateTranX = tx;
        this.mRotateTranY = ty;
        this.refreshWithBackground();
    }

    public boolean isOptimizeDrawing() {
        return this.mOptimizeDrawing;
    }

    public void markItemToOptimizeDrawing(IDoodleItem item) {
        if (!this.mOptimizeDrawing) {
            return;
        }
        if (this.mItemStackOnViewCanvas.contains(item)) {
            throw new RuntimeException("The item has been added");
        }
        this.mItemStackOnViewCanvas.add(item);
        if (this.mItemStack.contains(item)) {
            this.addFlag(2);
        }
        this.refresh();
    }

    public void notifyItemFinishedDrawing(IDoodleItem item) {
        if (!this.mOptimizeDrawing) {
            return;
        }
        if (this.mItemStackOnViewCanvas.remove(item)) {
            if (this.mItemStack.contains(item)) {
                this.addFlag(2);
            } else {
                this.addItem(item);
            }
        }
        this.refresh();
    }

    @Override
    @SuppressLint(value={"StaticFieldLeak"})
    public void save() {
        if (this.mIsSaving) {
            return;
        }
        this.mIsSaving = true;
        new AsyncTask<Void, Void, Bitmap>(){

            @SuppressLint(value={"WrongThread"})
            protected Bitmap doInBackground(Void ... voids) {
                Bitmap savedBitmap = null;
                if (DoodleView.this.mOptimizeDrawing) {
                    DoodleView.this.refreshDoodleBitmap(true);
                    savedBitmap = DoodleView.this.mDoodleBitmap;
                } else {
                    savedBitmap = DoodleView.this.mBitmap.copy(DoodleView.this.mBitmap.getConfig(), true);
                    Canvas canvas = new Canvas(savedBitmap);
                    for (IDoodleItem item : DoodleView.this.mItemStack) {
                        item.draw(canvas);
                    }
                }
                savedBitmap = ImageUtils.rotate((Bitmap)savedBitmap, (int)DoodleView.this.mDoodleRotateDegree, (boolean)true);
                return savedBitmap;
            }

            protected void onPostExecute(Bitmap bitmap) {
                DoodleView.this.mDoodleListener.onSaved(DoodleView.this, bitmap, new Runnable(){

                    @Override
                    public void run() {
                        DoodleView.this.mIsSaving = false;
                        if (DoodleView.this.mOptimizeDrawing) {
                            DoodleView.this.refreshDoodleBitmap(false);
                        }
                        DoodleView.this.refresh();
                    }
                });
            }
        }.execute((Object[])new Void[0]);
    }

    @Override
    public void clear() {
        ArrayList<IDoodleItem> temp = new ArrayList<IDoodleItem>(this.mItemStack);
        this.mItemStack.clear();
        this.mRedoItemStack.clear();
        this.mItemStackOnViewCanvas.clear();
        this.mPendingItemsDrawToBitmap.clear();
        for (int i = temp.size() - 1; i >= 0; --i) {
            IDoodleItem item = (IDoodleItem)temp.get(i);
            item.onRemove();
        }
        this.addFlag(2);
        this.refresh();
    }

    @Override
    public boolean undo(int step) {
        if (this.mItemStack.size() > 0) {
            step = Math.min(this.mItemStack.size(), step);
            ArrayList<IDoodleItem> list = new ArrayList<IDoodleItem>(this.mItemStack.subList(this.mItemStack.size() - step, this.mItemStack.size()));
            for (IDoodleItem item : list) {
                this.removeItem(item);
                this.mRedoItemStack.add(0, item);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean redo(int step) {
        if (this.mRedoItemStack.isEmpty()) {
            return false;
        }
        for (int i = 0; i < step && !this.mRedoItemStack.isEmpty(); ++i) {
            this.addItemInner(this.mRedoItemStack.remove(0));
        }
        return true;
    }

    @Override
    public boolean undo() {
        return this.undo(1);
    }

    @Override
    public void setShowOriginal(boolean justDrawOriginal) {
        this.isJustDrawOriginal = justDrawOriginal;
        this.refreshWithBackground();
    }

    @Override
    public boolean isShowOriginal() {
        return this.isJustDrawOriginal;
    }

    @Override
    public void setColor(IDoodleColor color) {
        this.mColor = color;
        this.refresh();
    }

    @Override
    public IDoodleColor getColor() {
        return this.mColor;
    }

    @Override
    public void setDoodleScale(float scale, float pivotX, float pivotY) {
        if (scale < this.mMinScale) {
            scale = this.mMinScale;
        } else if (scale > this.mMaxScale) {
            scale = this.mMaxScale;
        }
        float touchX = this.toTouchX(pivotX);
        float touchY = this.toTouchY(pivotY);
        this.mScale = scale;
        this.mTransX = this.toTransX(touchX, pivotX);
        this.mTransY = this.toTransY(touchY, pivotY);
        this.addFlag(8);
        this.refresh();
    }

    @Override
    public float getDoodleScale() {
        return this.mScale;
    }

    @Override
    public void setPen(IDoodlePen pen) {
        if (pen == null) {
            throw new RuntimeException("Pen can't be null");
        }
        IDoodlePen old = this.mPen;
        this.mPen = pen;
        this.refresh();
    }

    @Override
    public IDoodlePen getPen() {
        return this.mPen;
    }

    @Override
    public void setShape(IDoodleShape shape) {
        if (shape == null) {
            throw new RuntimeException("Shape can't be null");
        }
        this.mShape = shape;
        this.refresh();
    }

    @Override
    public IDoodleShape getShape() {
        return this.mShape;
    }

    @Override
    public void setDoodleTranslation(float transX, float transY) {
        this.mTransX = transX;
        this.mTransY = transY;
        this.refreshWithBackground();
    }

    @Override
    public void setDoodleTranslationX(float transX) {
        this.mTransX = transX;
        this.refreshWithBackground();
    }

    @Override
    public float getDoodleTranslationX() {
        return this.mTransX;
    }

    @Override
    public void setDoodleTranslationY(float transY) {
        this.mTransY = transY;
        this.refreshWithBackground();
    }

    @Override
    public float getDoodleTranslationY() {
        return this.mTransY;
    }

    @Override
    public void setSize(float paintSize) {
        this.mSize = paintSize;
        this.refresh();
    }

    @Override
    public float getSize() {
        return this.mSize;
    }

    @Override
    public void setIsDrawableOutside(boolean isDrawableOutside) {
        this.mIsDrawableOutside = isDrawableOutside;
    }

    @Override
    public boolean isDrawableOutside() {
        return this.mIsDrawableOutside;
    }

    @Override
    public void setZoomerScale(float scale) {
        this.mZoomerScale = scale;
        this.refresh();
    }

    @Override
    public float getZoomerScale() {
        return this.mZoomerScale;
    }

    public void enableZoomer(boolean enable) {
        this.mEnableZoomer = enable;
    }

    public boolean isEnableZoomer() {
        return this.mEnableZoomer;
    }

    public void enableOverview(boolean enableOverview) {
        this.mEnableOverview = enableOverview;
    }

    public boolean isEnableOverview() {
        return this.mEnableOverview;
    }

    public boolean isScrollingDoodle() {
        return this.mIsScrollingDoodle;
    }

    public void setScrollingDoodle(boolean scrollingDoodle) {
        this.mIsScrollingDoodle = scrollingDoodle;
        this.refresh();
    }

    @Override
    public void topItem(IDoodleItem item) {
        if (item == null) {
            throw new RuntimeException("item is null");
        }
        this.mItemStack.remove(item);
        this.mItemStack.add(item);
        this.addFlag(2);
        this.refresh();
    }

    @Override
    public void bottomItem(IDoodleItem item) {
        if (item == null) {
            throw new RuntimeException("item is null");
        }
        this.mItemStack.remove(item);
        this.mItemStack.add(0, item);
        this.addFlag(2);
        this.refresh();
    }

    @Override
    public void setDoodleMinScale(float minScale) {
        this.mMinScale = minScale;
        this.setDoodleScale(this.mScale, 0.0f, 0.0f);
    }

    @Override
    public float getDoodleMinScale() {
        return this.mMinScale;
    }

    @Override
    public void setDoodleMaxScale(float maxScale) {
        this.mMaxScale = maxScale;
        this.setDoodleScale(this.mScale, 0.0f, 0.0f);
    }

    @Override
    public float getDoodleMaxScale() {
        return this.mMaxScale;
    }

    @Override
    public float getUnitSize() {
        return this.mDoodleSizeUnit;
    }

    @Override
    public void addItem(IDoodleItem item) {
        this.addItemInner(item);
        this.mRedoItemStack.clear();
    }

    private void addItemInner(IDoodleItem item) {
        if (item == null) {
            throw new RuntimeException("item is null");
        }
        if (this != item.getDoodle()) {
            throw new RuntimeException("the object Doodle is illegal");
        }
        if (this.mItemStack.contains(item)) {
            throw new RuntimeException("the item has been added");
        }
        this.mItemStack.add(item);
        item.onAdd();
        this.mPendingItemsDrawToBitmap.add(item);
        this.addFlag(4);
        this.refresh();
    }

    @Override
    public void removeItem(IDoodleItem doodleItem) {
        if (!this.mItemStack.remove(doodleItem)) {
            return;
        }
        this.mItemStackOnViewCanvas.remove(doodleItem);
        this.mPendingItemsDrawToBitmap.remove(doodleItem);
        doodleItem.onRemove();
        this.addFlag(2);
        this.refresh();
    }

    @Override
    public int getItemCount() {
        return this.mItemStack.size();
    }

    @Override
    public List<IDoodleItem> getAllItem() {
        return new ArrayList<IDoodleItem>(this.mItemStack);
    }

    @Override
    public int getRedoItemCount() {
        return this.mRedoItemStack.size();
    }

    @Override
    public List<IDoodleItem> getAllRedoItem() {
        return new ArrayList<IDoodleItem>(this.mRedoItemStack);
    }

    @Override
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public Bitmap getDoodleBitmap() {
        return this.mBitmap;
    }

    public int getCenterWidth() {
        return this.mCenterWidth;
    }

    public int getCenterHeight() {
        return this.mCenterHeight;
    }

    public float getCenterScale() {
        return this.mCenterScale;
    }

    public float getCentreTranX() {
        return this.mCentreTranX;
    }

    public float getCentreTranY() {
        return this.mCentreTranY;
    }

    public float getRotateScale() {
        return this.mRotateScale;
    }

    public float getRotateTranX() {
        return this.mRotateTranX;
    }

    public float getRotateTranY() {
        return this.mRotateTranY;
    }

    public boolean isEditMode() {
        return this.mIsEditMode;
    }

    public void setEditMode(boolean editMode) {
        this.mIsEditMode = editMode;
        this.refresh();
    }

    private class ForegroundView
    extends View {
        public ForegroundView(Context context) {
            super(context);
            this.setLayerType(1, null);
        }

        public boolean onTouchEvent(MotionEvent event) {
            IDoodleTouchDetector detector = (IDoodleTouchDetector)DoodleView.this.mTouchDetectorMap.get(DoodleView.this.mPen);
            if (detector != null) {
                return detector.onTouchEvent(event);
            }
            if (DoodleView.this.mDefaultTouchDetector != null) {
                return DoodleView.this.mDefaultTouchDetector.onTouchEvent(event);
            }
            return false;
        }

        protected void onDraw(Canvas canvas) {
            int count = canvas.save();
            canvas.rotate((float)DoodleView.this.mDoodleRotateDegree, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.doDraw(canvas);
            canvas.restoreToCount(count);
        }

        private void doDraw(Canvas canvas) {
            if (DoodleView.this.isJustDrawOriginal) {
                return;
            }
            float left = DoodleView.this.getAllTranX();
            float top = DoodleView.this.getAllTranY();
            canvas.translate(left, top);
            float scale = DoodleView.this.getAllScale();
            canvas.scale(scale, scale);
            Bitmap bitmap = DoodleView.this.mOptimizeDrawing ? DoodleView.this.mDoodleBitmap : DoodleView.this.mBitmap;
            int saveCount = canvas.save();
            List items = DoodleView.this.mItemStack;
            if (DoodleView.this.mOptimizeDrawing) {
                items = DoodleView.this.mItemStackOnViewCanvas;
            }
            boolean canvasClipped = false;
            if (!DoodleView.this.mIsDrawableOutside) {
                canvasClipped = true;
                canvas.clipRect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            }
            for (IDoodleItem item : items) {
                if (!item.isNeedClipOutside()) {
                    if (canvasClipped) {
                        canvas.restore();
                    }
                    item.draw(canvas);
                    if (!canvasClipped) continue;
                    canvas.save();
                    canvas.clipRect(0, 0, bitmap.getWidth(), bitmap.getHeight());
                    continue;
                }
                item.draw(canvas);
            }
            for (IDoodleItem item : items) {
                if (!item.isNeedClipOutside()) {
                    if (canvasClipped) {
                        canvas.restore();
                    }
                    item.drawAtTheTop(canvas);
                    if (!canvasClipped) continue;
                    canvas.save();
                    canvas.clipRect(0, 0, bitmap.getWidth(), bitmap.getHeight());
                    continue;
                }
                item.drawAtTheTop(canvas);
            }
            canvas.restoreToCount(saveCount);
            if (DoodleView.this.mPen != null) {
                DoodleView.this.mPen.drawHelpers(canvas, DoodleView.this);
            }
            if (DoodleView.this.mShape != null) {
                DoodleView.this.mShape.drawHelpers(canvas, DoodleView.this);
            }
        }
    }

    private class BackgroundView
    extends View {
        public BackgroundView(Context context) {
            super(context);
        }

        protected void onDraw(Canvas canvas) {
            if (LogUtil.sIsLog) {
                LogUtil.d((String)DoodleView.TAG, (String)"BackgroundView>>onDraw");
            }
            int count = canvas.save();
            canvas.rotate((float)DoodleView.this.mDoodleRotateDegree, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.doDraw(canvas);
            canvas.restoreToCount(count);
        }

        private void doDraw(Canvas canvas) {
            float left = DoodleView.this.getAllTranX();
            float top = DoodleView.this.getAllTranY();
            canvas.translate(left, top);
            float scale = DoodleView.this.getAllScale();
            canvas.scale(scale, scale);
            if (DoodleView.this.isJustDrawOriginal) {
                canvas.drawBitmap(DoodleView.this.mBitmap, 0.0f, 0.0f, null);
                return;
            }
            Bitmap bitmap = DoodleView.this.mOptimizeDrawing ? DoodleView.this.mDoodleBitmap : DoodleView.this.mBitmap;
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        }
    }
}

