/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle.imagepicker;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import cn.hzw.doodle.R;
import cn.hzw.doodle.imagepicker.ImageSelectorAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImageSelectorView
extends FrameLayout
implements View.OnClickListener {
    public static final String KEY_PATH_LIST = "key_path";
    public static final int WHAT_REFRESH_PATH_LIST = 1;
    public static final String KEY_IS_MULTIPLE_CHOICE = "key_is_multiple_choice";
    public static final String KEY_MAX_COUNT = "key_max_count";
    private GridView mGridView;
    private int mCursorPosition = -1;
    private static final int CURSOR_COUNT = 100;
    private ArrayList<String> mPathList;
    private Handler mHandler;
    private ImageSelectorAdapter mAdapter;
    private boolean mIsFinishSearchImage = false;
    private boolean mIsScanning = false;
    private boolean mIsMultipleChoice = false;
    private int mMaxCount = Integer.MAX_VALUE;
    private TextView mBtnEnter;
    private ImageSelectorListener mSelectorListener;

    public ImageSelectorView(Context context, boolean isMultipleChoice, int maxCount, final List<String> pathList, ImageSelectorListener listener) {
        super(context);
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.doodle_layout_image_selector, null);
        this.addView(view, -1, -1);
        this.mIsMultipleChoice = isMultipleChoice;
        this.mMaxCount = this.mIsMultipleChoice ? maxCount : 1;
        this.mSelectorListener = listener;
        this.mGridView = (GridView)this.findViewById(R.id.doodle_list_image);
        this.mBtnEnter = (TextView)this.findViewById(R.id.btn_enter);
        this.mBtnEnter.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_back).setOnClickListener((View.OnClickListener)this);
        this.mPathList = new ArrayList();
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        if (ImageSelectorView.this.mAdapter == null) {
                            ImageSelectorView.this.mAdapter = new ImageSelectorAdapter(ImageSelectorView.this.getContext(), ImageSelectorView.this.mPathList);
                            List list = pathList;
                            if (list != null) {
                                for (int i = 0; i < list.size() && i < ImageSelectorView.this.mMaxCount; ++i) {
                                    ImageSelectorView.this.mAdapter.addSelected((String)list.get(i));
                                }
                            }
                            ImageSelectorView.this.mBtnEnter.setText((CharSequence)(ImageSelectorView.this.getContext().getString(R.string.doodle_enter) + "(" + ImageSelectorView.this.mAdapter.getSelectedSet().size() + ")"));
                            ImageSelectorView.this.mGridView.setAdapter((ListAdapter)ImageSelectorView.this.mAdapter);
                            break;
                        }
                        ImageSelectorView.this.mAdapter.refreshPathList(ImageSelectorView.this.mPathList);
                        break;
                    }
                }
            }
        };
        this.mGridView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (!ImageSelectorView.this.mIsFinishSearchImage && !ImageSelectorView.this.mIsScanning && firstVisibleItem + visibleItemCount + 10 >= ImageSelectorView.this.mPathList.size()) {
                    ImageSelectorView.this.scanImageData();
                }
            }
        });
        this.mGridView.setOnItemClickListener((AdapterView.OnItemClickListener)new ItemClickListener());
        this.scanImageData();
    }

    public void setColumnCount(int count) {
        this.mGridView.setNumColumns(count);
    }

    public int getColumnCount() {
        return this.mGridView.getNumColumns();
    }

    private synchronized void scanImageData() {
        if (this.mIsFinishSearchImage || this.mIsScanning) {
            return;
        }
        this.mIsScanning = true;
        if (!Environment.getExternalStorageState().equals("mounted")) {
            this.showToast("\u6682\u65e0\u5916\u90e8\u5b58\u50a8");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                int i;
                Uri mImageUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                ContentResolver mContentResolver = ImageSelectorView.this.getContext().getContentResolver();
                Cursor mCursor = mContentResolver.query(mImageUri, null, "mime_type=? or mime_type=?", new String[]{"image/jpeg", "image/png"}, "date_modified DESC");
                mCursor.moveToPosition(ImageSelectorView.this.mCursorPosition);
                for (i = 0; mCursor.moveToNext() && i < 100; ++i) {
                    String path = mCursor.getString(mCursor.getColumnIndex("_data"));
                    if (!new File(path).exists()) continue;
                    ImageSelectorView.this.mPathList.add(path);
                }
                mCursor.close();
                ImageSelectorView.this.mCursorPosition = ImageSelectorView.this.mCursorPosition + i;
                ImageSelectorView.this.mIsScanning = false;
                if (i < 100) {
                    ImageSelectorView.this.mIsFinishSearchImage = true;
                }
                ImageSelectorView.this.mHandler.sendEmptyMessage(1);
            }
        }).start();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_back) {
            this.mSelectorListener.onCancel();
        } else if (v.getId() == R.id.btn_enter && this.mAdapter.getSelectedSet().size() > 0) {
            Intent intent = new Intent();
            ArrayList<String> list = new ArrayList<String>();
            for (String path : this.mAdapter.getSelectedSet()) {
                list.add(path);
            }
            this.mSelectorListener.onEnter(list);
        }
    }

    private void showToast(String msg) {
        Toast.makeText((Context)this.getContext(), (CharSequence)msg, (int)0).show();
    }

    public static interface ImageSelectorListener {
        public void onCancel();

        public void onEnter(List<String> var1);
    }

    private class ItemClickListener
    implements AdapterView.OnItemClickListener {
        private View mLastSelected;

        private ItemClickListener() {
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            String path = (String)view.getTag(-2016);
            if (ImageSelectorView.this.mIsMultipleChoice) {
                if (ImageSelectorView.this.mAdapter.getSelectedSet().size() >= ImageSelectorView.this.mMaxCount) {
                    ImageSelectorView.this.showToast("\u6700\u591a\u53ea\u80fd\u9009\u62e9" + ImageSelectorView.this.mMaxCount + "\u9879");
                    return;
                }
                View selectedView = (View)view.getTag(-20161);
                if (ImageSelectorView.this.mAdapter.getSelectedSet().contains(path)) {
                    ImageSelectorView.this.mAdapter.removeSelected(path);
                    selectedView.setVisibility(8);
                } else {
                    ImageSelectorView.this.mAdapter.addSelected(path);
                    selectedView.setVisibility(0);
                }
            } else {
                View selectedView = (View)view.getTag(-20161);
                if (ImageSelectorView.this.mAdapter.getSelectedSet().contains(path)) {
                    ImageSelectorView.this.mAdapter.removeSelected(path);
                    this.mLastSelected = null;
                    selectedView.setVisibility(8);
                } else {
                    ImageSelectorView.this.mAdapter.getSelectedSet().clear();
                    ImageSelectorView.this.mAdapter.addSelected(path);
                    if (this.mLastSelected != null) {
                        this.mLastSelected.setVisibility(8);
                    }
                    selectedView.setVisibility(0);
                    this.mLastSelected = selectedView;
                }
            }
            ImageSelectorView.this.mBtnEnter.setText((CharSequence)(ImageSelectorView.this.getResources().getString(R.string.doodle_enter) + "(" + ImageSelectorView.this.mAdapter.getSelectedSet().size() + ")"));
        }
    }
}

