/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.SeekBar;
import cn.forward.androids.utils.Util;
import cn.hzw.doodle.R;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.dialog.ColorPickerView;
import cn.hzw.doodle.util.DrawUtil;

public class ColorPickerDialog
extends Dialog {
    private final boolean debug = true;
    private final String TAG = "ColorPicker";
    Context context;
    private OnColorChangedListener mListener;

    public ColorPickerDialog(Context context, OnColorChangedListener listener, int themeResId) {
        super(context, themeResId);
        this.context = context;
        this.mListener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void show(IDoodle iDoodle, Drawable drawable, int maxSize) {
        super.show();
        int height = Util.dp2px((Context)this.context, (float)220.0f);
        int width = Util.dp2px((Context)this.context, (float)180.0f);
        ViewGroup viewGroup = (ViewGroup)View.inflate((Context)this.context, (int)R.layout.doodle_color_selector_dialog, null);
        final EditText sizeView = (EditText)viewGroup.findViewById(R.id.doodle_txtview_size);
        final SeekBar seekBar = (SeekBar)viewGroup.findViewById(R.id.doodle_seekbar_size);
        seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (progress == 0) {
                    seekBar.setProgress(1);
                    return;
                }
                sizeView.setText((CharSequence)("" + progress));
                sizeView.setSelection(sizeView.getText().toString().length());
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        seekBar.setMax(maxSize);
        seekBar.setProgress((int)iDoodle.getSize());
        ViewGroup container = (ViewGroup)viewGroup.findViewById(R.id.doodle_color_selector_container);
        final ColorPickerView colorPickerView = new ColorPickerView(this.context, -16777216, height, width, null);
        if (drawable instanceof BitmapDrawable) {
            colorPickerView.setDrawable((BitmapDrawable)drawable);
        } else if (drawable instanceof ColorDrawable) {
            colorPickerView.setColor(((ColorDrawable)drawable).getColor());
        }
        container.addView((View)colorPickerView, 0, new ViewGroup.LayoutParams(height, width));
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View v) {
                ImageView imageView = (ImageView)v;
                colorPickerView.setDrawable((BitmapDrawable)imageView.getDrawable());
            }
        };
        ViewGroup shaderContainer = (ViewGroup)viewGroup.findViewById(R.id.doodle_shader_container);
        for (int i = 0; i < shaderContainer.getChildCount(); ++i) {
            shaderContainer.getChildAt(i).setOnClickListener(listener);
        }
        sizeView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                try {
                    int p = Integer.parseInt(s.toString());
                    if (p <= 0) {
                        p = 1;
                    }
                    if (p == seekBar.getProgress()) {
                        return;
                    }
                    seekBar.setProgress(p);
                    sizeView.setText((CharSequence)("" + seekBar.getProgress()));
                    sizeView.setSelection(sizeView.getText().toString().length());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        viewGroup.findViewById(R.id.doodle_txtview_reduce).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                seekBar.setProgress(Math.max(1, seekBar.getProgress() - 1));
            }
        });
        viewGroup.findViewById(R.id.doodle_txtview_add).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                seekBar.setProgress(Math.min(seekBar.getMax(), seekBar.getProgress() + 1));
            }
        });
        viewGroup.findViewById(R.id.dialog_enter_btn_01).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ColorPickerDialog.this.dismiss();
            }
        });
        viewGroup.findViewById(R.id.dialog_enter_btn_02).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (colorPickerView.getDrawable() != null) {
                    ColorPickerDialog.this.mListener.colorChanged(colorPickerView.getDrawable(), seekBar.getProgress());
                } else {
                    ColorPickerDialog.this.mListener.colorChanged(colorPickerView.getColor(), seekBar.getProgress());
                }
                ColorPickerDialog.this.dismiss();
            }
        });
        this.setContentView((View)viewGroup, new ViewGroup.LayoutParams(-1, -1));
        this.setCanceledOnTouchOutside(false);
        DrawUtil.assistActivity(this.getWindow());
    }

    public static interface OnColorChangedListener {
        public void colorChanged(int var1, int var2);

        public void colorChanged(Drawable var1, int var2);
    }
}

