/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import cn.hzw.doodle.DoodleItemBase;
import cn.hzw.doodle.DoodlePaintAttrs;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleSelectableItem;
import cn.hzw.doodle.util.DrawUtil;

public abstract class DoodleSelectableItemBase
extends DoodleItemBase
implements IDoodleSelectableItem {
    public static final int ITEM_CAN_ROTATE_BOUND = 35;
    public static final int ITEM_PADDING = 3;
    private Rect mRect = new Rect();
    private Rect mRectTemp = new Rect();
    private Paint mPaint = new Paint();
    private PointF mTemp = new PointF();
    private boolean mIsSelected = false;

    public DoodleSelectableItemBase(IDoodle doodle, int itemRotate, float x, float y) {
        this(doodle, null, itemRotate, x, y);
    }

    public DoodleSelectableItemBase(IDoodle doodle, DoodlePaintAttrs attrs, int itemRotate, float x, float y) {
        super(doodle, attrs);
        this.setLocation(x, y);
        this.setItemRotate(itemRotate);
        this.resetBoundsScaled(this.mRect);
    }

    @Override
    public void setScale(float scale) {
        super.setScale(scale);
        this.resetBoundsScaled(this.mRect);
        this.refresh();
    }

    @Override
    public Rect getBounds() {
        return this.mRect;
    }

    @Override
    public void setSize(float size) {
        super.setSize(size);
        this.resetBounds(this.getBounds());
        this.setLocation(this.getPivotX() - (float)(this.getBounds().width() / 2), this.getPivotY() - (float)(this.getBounds().height() / 2), false);
        this.resetBoundsScaled(this.getBounds());
    }

    @Override
    public boolean contains(float x, float y) {
        this.resetBoundsScaled(this.mRect);
        PointF location = this.getLocation();
        this.mTemp = DrawUtil.rotatePoint(this.mTemp, (int)(-this.getItemRotate()), x -= location.x, y -= location.y, this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
        this.mRectTemp.set(this.mRect);
        float unit = this.getDoodle().getUnitSize();
        this.mRectTemp.left = (int)((float)this.mRectTemp.left - 3.0f * unit);
        this.mRectTemp.top = (int)((float)this.mRectTemp.top - 3.0f * unit);
        this.mRectTemp.right = (int)((float)this.mRectTemp.right + 3.0f * unit);
        this.mRectTemp.bottom = (int)((float)this.mRectTemp.bottom + 3.0f * unit);
        return this.mRectTemp.contains((int)this.mTemp.x, (int)this.mTemp.y);
    }

    @Override
    public void drawBefore(Canvas canvas) {
    }

    @Override
    public void drawAfter(Canvas canvas) {
    }

    @Override
    public void drawAtTheTop(Canvas canvas) {
        int count = canvas.save();
        PointF location = this.getLocation();
        canvas.translate(location.x, location.y);
        canvas.rotate(this.getItemRotate(), this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
        this.doDrawAtTheTop(canvas);
        canvas.restoreToCount(count);
    }

    public void doDrawAtTheTop(Canvas canvas) {
        if (this.isSelected()) {
            canvas.save();
            canvas.scale(1.0f / this.getDoodle().getDoodleScale(), 1.0f / this.getDoodle().getDoodleScale(), this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
            this.mRectTemp.set(this.getBounds());
            DrawUtil.scaleRect(this.mRectTemp, this.getDoodle().getDoodleScale(), this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
            float unit = this.getDoodle().getUnitSize();
            this.mRectTemp.left = (int)((float)this.mRectTemp.left - 3.0f * unit);
            this.mRectTemp.top = (int)((float)this.mRectTemp.top - 3.0f * unit);
            this.mRectTemp.right = (int)((float)this.mRectTemp.right + 3.0f * unit);
            this.mRectTemp.bottom = (int)((float)this.mRectTemp.bottom + 3.0f * unit);
            this.mPaint.setShader(null);
            this.mPaint.setColor(0x888888);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setStrokeWidth(1.0f);
            canvas.drawRect(this.mRectTemp, this.mPaint);
            this.mPaint.setColor(-1996488705);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(2.0f * unit);
            canvas.drawRect(this.mRectTemp, this.mPaint);
            this.mPaint.setColor(0x44888888);
            this.mPaint.setStrokeWidth(0.8f * unit);
            canvas.drawRect(this.mRectTemp, this.mPaint);
            canvas.restore();
        }
    }

    @Override
    public boolean isSelected() {
        return this.mIsSelected;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.mIsSelected = isSelected;
        this.setNeedClipOutside(!isSelected);
        this.refresh();
    }

    protected void resetBoundsScaled(Rect rect) {
        this.resetBounds(rect);
        float px = this.getPivotX() - this.getLocation().x;
        float py = this.getPivotY() - this.getLocation().y;
        DrawUtil.scaleRect(rect, this.getScale(), px, py);
    }

    protected abstract void resetBounds(Rect var1);

    @Override
    public boolean isDoodleEditable() {
        return true;
    }
}

