/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import cn.hzw.doodle.CopyLocation;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodleView;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodlePen;

public enum DoodlePen implements IDoodlePen
{
    BRUSH,
    COPY,
    ERASER,
    TEXT,
    BITMAP,
    MOSAIC;

    private CopyLocation mCopyLocation;

    @Override
    public void config(IDoodleItem item, Paint paint) {
        if (this == COPY || this == ERASER) {
            IDoodle doodle = item.getDoodle();
            if (!(item.getColor() instanceof DoodleColor) || ((DoodleColor)item.getColor()).getBitmap() != doodle.getBitmap()) {
                item.setColor(new DoodleColor(doodle.getBitmap()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyLocation getCopyLocation() {
        if (this != COPY) {
            return null;
        }
        if (this.mCopyLocation == null) {
            DoodlePen doodlePen = this;
            synchronized (doodlePen) {
                if (this.mCopyLocation == null) {
                    this.mCopyLocation = new CopyLocation();
                }
            }
        }
        return this.mCopyLocation;
    }

    @Override
    public IDoodlePen copy() {
        return this;
    }

    @Override
    public void drawHelpers(Canvas canvas, IDoodle doodle) {
        if (this == COPY && doodle instanceof DoodleView && !((DoodleView)doodle).isEditMode()) {
            this.mCopyLocation.drawItSelf(canvas, doodle.getSize());
        }
    }
}

