/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import cn.hzw.doodle.core.IDoodle;

public class DoodleParams
implements Parcelable {
    public String mImagePath;
    public String mSavePath;
    public boolean mSavePathIsDir;
    public boolean mIsDrawableOutside;
    public long mChangePanelVisibilityDelay = 200L;
    public float mZoomerScale = 2.5f;
    public boolean mIsFullScreen = false;
    public float mPaintPixelSize = -1.0f;
    public float mPaintUnitSize = -1.0f;
    public float mMinScale = 0.25f;
    public float mMaxScale = 5.0f;
    public int mPaintColor = -65536;
    public boolean mSupportScaleItem = true;
    public boolean mOptimizeDrawing = true;
    public static final Parcelable.Creator<DoodleParams> CREATOR = new Parcelable.Creator<DoodleParams>(){

        public DoodleParams createFromParcel(Parcel in) {
            DoodleParams params = new DoodleParams();
            params.mImagePath = in.readString();
            params.mSavePath = in.readString();
            params.mSavePathIsDir = in.readInt() == 1;
            params.mIsDrawableOutside = in.readInt() == 1;
            params.mChangePanelVisibilityDelay = in.readLong();
            params.mZoomerScale = in.readFloat();
            params.mIsFullScreen = in.readInt() == 1;
            params.mPaintPixelSize = in.readFloat();
            params.mPaintUnitSize = in.readFloat();
            params.mMinScale = in.readFloat();
            params.mMaxScale = in.readFloat();
            params.mPaintColor = in.readInt();
            params.mSupportScaleItem = in.readInt() == 1;
            params.mOptimizeDrawing = in.readInt() == 1;
            return params;
        }

        public DoodleParams[] newArray(int size) {
            return new DoodleParams[size];
        }
    };
    private static DialogInterceptor sDialogInterceptor;

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mImagePath);
        dest.writeString(this.mSavePath);
        dest.writeInt(this.mSavePathIsDir ? 1 : 0);
        dest.writeInt(this.mIsDrawableOutside ? 1 : 0);
        dest.writeLong(this.mChangePanelVisibilityDelay);
        dest.writeFloat(this.mZoomerScale);
        dest.writeInt(this.mIsFullScreen ? 1 : 0);
        dest.writeFloat(this.mPaintPixelSize);
        dest.writeFloat(this.mPaintUnitSize);
        dest.writeFloat(this.mMinScale);
        dest.writeFloat(this.mMaxScale);
        dest.writeInt(this.mPaintColor);
        dest.writeInt(this.mSupportScaleItem ? 1 : 0);
        dest.writeInt(this.mOptimizeDrawing ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void setDialogInterceptor(DialogInterceptor interceptor) {
        sDialogInterceptor = interceptor;
    }

    public static DialogInterceptor getDialogInterceptor() {
        return sDialogInterceptor;
    }

    public static interface DialogInterceptor {
        public boolean onShow(Activity var1, IDoodle var2, DialogType var3);
    }

    public static enum DialogType {
        SAVE,
        CLEAR_ALL,
        COLOR_PICKER;

    }
}

