/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle.imagepicker;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import cn.hzw.doodle.R;
import cn.hzw.doodle.imagepicker.ImageLoader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class ImageSelectorAdapter
extends BaseAdapter {
    public static final int KEY_IMAGE = -2016;
    public static final int KEY_SELECTED_VIEW = -20161;
    private Context mContext;
    private ArrayList<String> mList;
    private LinkedHashSet<String> mSelectedSet;
    int id = 0;

    public ImageSelectorAdapter(Context context, ArrayList<String> list) {
        this.mList = new ArrayList<String>(list);
        this.mContext = context;
        this.mSelectedSet = new LinkedHashSet();
    }

    public void refreshPathList(ArrayList<String> list) {
        this.mList = new ArrayList<String>(list);
        this.notifyDataSetChanged();
    }

    public Set<String> getSelectedSet() {
        return this.mSelectedSet;
    }

    public void addSelected(String path) {
        this.mSelectedSet.add(path);
    }

    public void removeSelected(String path) {
        this.mSelectedSet.remove(path);
    }

    public int getCount() {
        return this.mList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.doodle_imageselector_item, null);
            holder = new ViewHolder();
            holder.mImage = (ImageView)convertView.findViewById(R.id.doodle_image);
            holder.mImageSelected = (ImageView)convertView.findViewById(R.id.doodle_image_selected);
            convertView.setTag((Object)holder);
            holder.mImage.setTag((Object)("" + ++this.id));
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        convertView.setTag(-2016, (Object)this.mList.get(position));
        convertView.setTag(-20161, (Object)holder.mImageSelected);
        if (this.mSelectedSet.contains(this.mList.get(position))) {
            holder.mImageSelected.setVisibility(0);
        } else {
            holder.mImageSelected.setVisibility(8);
        }
        this.display(holder.mImage, this.mList.get(position));
        return convertView;
    }

    private <T extends View> void display(T container, String uri) {
        ImageLoader.getInstance(this.mContext).display(container, uri);
    }

    private class ViewHolder {
        ImageView mImage;
        ImageView mImageSelected;

        private ViewHolder() {
        }
    }
}

