/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import cn.hzw.doodle.util.DrawUtil;

public class CopyLocation {
    private float mCopyStartX;
    private float mCopyStartY;
    private float mTouchStartX;
    private float mTouchStartY;
    private float mX;
    private float mY;
    private Paint mPaint;
    private boolean mIsRelocating = true;
    private boolean mIsCopying = false;
    private PointF mTemp = new PointF();

    public CopyLocation() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
    }

    public float getTouchStartX() {
        return this.mTouchStartX;
    }

    public float getTouchStartY() {
        return this.mTouchStartY;
    }

    public float getCopyStartX() {
        return this.mCopyStartX;
    }

    public float getCopyStartY() {
        return this.mCopyStartY;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public boolean isCopying() {
        return this.mIsCopying;
    }

    public boolean isRelocating() {
        return this.mIsRelocating;
    }

    public void setCopying(boolean copying) {
        this.mIsCopying = copying;
    }

    public void setRelocating(boolean relocating) {
        this.mIsRelocating = relocating;
    }

    public void updateLocation(float x, float y) {
        this.mX = x;
        this.mY = y;
    }

    public void setStartPosition(float touchStartX, float touchStartY) {
        this.setStartPosition(touchStartX, touchStartY, this.mX, this.mY);
    }

    public void setStartPosition(float touchStartX, float touchStartY, float copyStartX, float copyStartY) {
        this.mCopyStartX = copyStartX;
        this.mCopyStartY = copyStartY;
        this.mTouchStartX = touchStartX;
        this.mTouchStartY = touchStartY;
    }

    public void drawItSelf(Canvas canvas, float size) {
        this.mPaint.setStrokeWidth(size / 4.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-1436129690);
        DrawUtil.drawCircle(canvas, this.mX, this.mY, size / 2.0f + size / 8.0f, this.mPaint);
        this.mPaint.setStrokeWidth(size / 16.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-1426063361);
        DrawUtil.drawCircle(canvas, this.mX, this.mY, size / 2.0f + size / 32.0f, this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        if (!this.mIsCopying) {
            this.mPaint.setColor(0x44FF0000);
            DrawUtil.drawCircle(canvas, this.mX, this.mY, size / 2.0f, this.mPaint);
        } else {
            this.mPaint.setColor(0x44000088);
            DrawUtil.drawCircle(canvas, this.mX, this.mY, size / 2.0f, this.mPaint);
        }
    }

    public boolean contains(float x, float y, float mPaintSize) {
        return (this.mX - x) * (this.mX - x) + (this.mY - y) * (this.mY - y) <= mPaintSize * mPaintSize;
    }

    public CopyLocation copy() {
        CopyLocation copyLocation = new CopyLocation();
        copyLocation.mCopyStartX = this.mCopyStartX;
        copyLocation.mCopyStartY = this.mCopyStartY;
        copyLocation.mTouchStartX = this.mTouchStartX;
        copyLocation.mTouchStartY = this.mTouchStartY;
        copyLocation.mX = this.mX;
        copyLocation.mY = this.mY;
        return copyLocation;
    }

    public void reset() {
        this.mY = 0.0f;
        this.mX = 0.0f;
        this.mTouchStartY = 0.0f;
        this.mTouchStartX = 0.0f;
        this.mCopyStartY = 0.0f;
        this.mCopyStartX = 0.0f;
        this.mIsRelocating = true;
        this.mIsCopying = false;
    }
}

