/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.animation.ValueAnimator;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.MotionEvent;
import cn.forward.androids.ScaleGestureDetectorApi27;
import cn.forward.androids.TouchGestureDetector;
import cn.hzw.doodle.CopyLocation;
import cn.hzw.doodle.DoodlePath;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleRotatableItemBase;
import cn.hzw.doodle.DoodleShape;
import cn.hzw.doodle.DoodleView;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodlePen;
import cn.hzw.doodle.core.IDoodleSelectableItem;
import cn.hzw.doodle.util.DrawUtil;
import java.util.List;

public class DoodleOnTouchGestureListener
extends TouchGestureDetector.OnTouchGestureListener {
    private static final float VALUE = 1.0f;
    private float mTouchX;
    private float mTouchY;
    private float mLastTouchX;
    private float mLastTouchY;
    private float mTouchDownX;
    private float mTouchDownY;
    private Float mLastFocusX;
    private Float mLastFocusY;
    private float mTouchCentreX;
    private float mTouchCentreY;
    private float mStartX;
    private float mStartY;
    private float mRotateDiff;
    private Path mCurrPath;
    private DoodlePath mCurrDoodlePath;
    private CopyLocation mCopyLocation;
    private DoodleView mDoodle;
    private ValueAnimator mScaleAnimator;
    private float mScaleAnimTransX;
    private float mScaleAnimTranY;
    private ValueAnimator mTranslateAnimator;
    private float mTransAnimOldY;
    private float mTransAnimY;
    private IDoodleSelectableItem mSelectedItem;
    private ISelectionListener mSelectionListener;
    private boolean mSupportScaleItem = true;
    private float pendingX;
    private float pendingY;
    private float pendingScale = 1.0f;

    public DoodleOnTouchGestureListener(DoodleView doodle, ISelectionListener listener) {
        this.mDoodle = doodle;
        this.mCopyLocation = DoodlePen.COPY.getCopyLocation();
        this.mCopyLocation.reset();
        this.mCopyLocation.updateLocation(doodle.getBitmap().getWidth() / 2, doodle.getBitmap().getHeight() / 2);
        this.mSelectionListener = listener;
    }

    public void setSelectedItem(IDoodleSelectableItem selectedItem) {
        IDoodleSelectableItem old = this.mSelectedItem;
        this.mSelectedItem = selectedItem;
        if (old != null) {
            old.setSelected(false);
            if (this.mSelectionListener != null) {
                this.mSelectionListener.onSelectedItem(this.mDoodle, old, false);
            }
        }
        if (this.mSelectedItem != null) {
            this.mSelectedItem.setSelected(true);
            if (this.mSelectionListener != null) {
                this.mSelectionListener.onSelectedItem(this.mDoodle, this.mSelectedItem, true);
            }
        }
    }

    public IDoodleSelectableItem getSelectedItem() {
        return this.mSelectedItem;
    }

    public boolean onDown(MotionEvent e) {
        this.mTouchX = this.mTouchDownX = e.getX();
        this.mTouchY = this.mTouchDownY = e.getY();
        return true;
    }

    public void onScrollBegin(MotionEvent event) {
        this.mLastTouchX = this.mTouchX = event.getX();
        this.mLastTouchY = this.mTouchY = event.getY();
        this.mDoodle.setScrollingDoodle(true);
        if (this.mDoodle.isEditMode() || this.isPenEditable(this.mDoodle.getPen())) {
            if (this.mSelectedItem != null) {
                PointF xy = this.mSelectedItem.getLocation();
                this.mStartX = xy.x;
                this.mStartY = xy.y;
                if (this.mSelectedItem instanceof DoodleRotatableItemBase && ((DoodleRotatableItemBase)this.mSelectedItem).canRotate(this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY))) {
                    ((DoodleRotatableItemBase)this.mSelectedItem).setIsRotating(true);
                    this.mRotateDiff = this.mSelectedItem.getItemRotate() - DrawUtil.computeAngle(this.mSelectedItem.getPivotX(), this.mSelectedItem.getPivotY(), this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY));
                }
            } else if (this.mDoodle.isEditMode()) {
                this.mStartX = this.mDoodle.getDoodleTranslationX();
                this.mStartY = this.mDoodle.getDoodleTranslationY();
            }
        } else if (this.mDoodle.getPen() == DoodlePen.COPY && this.mCopyLocation.contains(this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY), this.mDoodle.getSize())) {
            this.mCopyLocation.setRelocating(true);
            this.mCopyLocation.setCopying(false);
        } else {
            if (this.mDoodle.getPen() == DoodlePen.COPY) {
                this.mCopyLocation.setRelocating(false);
                if (!this.mCopyLocation.isCopying()) {
                    this.mCopyLocation.setCopying(true);
                    this.mCopyLocation.setStartPosition(this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY));
                }
            }
            this.mCurrPath = new Path();
            this.mCurrPath.moveTo(this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY));
            this.mCurrDoodlePath = this.mDoodle.getShape() == DoodleShape.HAND_WRITE ? DoodlePath.toPath(this.mDoodle, this.mCurrPath) : DoodlePath.toShape(this.mDoodle, this.mDoodle.toX(this.mTouchDownX), this.mDoodle.toY(this.mTouchDownY), this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY));
            this.mDoodle.addItem(this.mCurrDoodlePath);
        }
        this.mDoodle.refresh();
    }

    public void onScrollEnd(MotionEvent e) {
        this.mLastTouchX = this.mTouchX;
        this.mLastTouchY = this.mTouchY;
        this.mTouchX = e.getX();
        this.mTouchY = e.getY();
        this.mDoodle.setScrollingDoodle(false);
        if (this.mDoodle.isEditMode() || this.isPenEditable(this.mDoodle.getPen())) {
            if (this.mSelectedItem instanceof DoodleRotatableItemBase) {
                ((DoodleRotatableItemBase)this.mSelectedItem).setIsRotating(false);
            }
            if (this.mDoodle.isEditMode()) {
                this.limitBound(true);
            }
        } else if (this.mCurrDoodlePath != null) {
            this.mCurrDoodlePath = null;
        }
        this.mDoodle.refresh();
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.mLastTouchX = this.mTouchX;
        this.mLastTouchY = this.mTouchY;
        this.mTouchX = e2.getX();
        this.mTouchY = e2.getY();
        if (this.mDoodle.isEditMode() || this.isPenEditable(this.mDoodle.getPen())) {
            if (this.mSelectedItem != null) {
                if (this.mSelectedItem instanceof DoodleRotatableItemBase && ((DoodleRotatableItemBase)this.mSelectedItem).isRotating()) {
                    this.mSelectedItem.setItemRotate(this.mRotateDiff + DrawUtil.computeAngle(this.mSelectedItem.getPivotX(), this.mSelectedItem.getPivotY(), this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY)));
                } else {
                    this.mSelectedItem.setLocation(this.mStartX + this.mDoodle.toX(this.mTouchX) - this.mDoodle.toX(this.mTouchDownX), this.mStartY + this.mDoodle.toY(this.mTouchY) - this.mDoodle.toY(this.mTouchDownY));
                }
            } else if (this.mDoodle.isEditMode()) {
                this.mDoodle.setDoodleTranslation(this.mStartX + this.mTouchX - this.mTouchDownX, this.mStartY + this.mTouchY - this.mTouchDownY);
            }
        } else if (this.mDoodle.getPen() == DoodlePen.COPY && this.mCopyLocation.isRelocating()) {
            this.mCopyLocation.updateLocation(this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY));
        } else {
            if (this.mDoodle.getPen() == DoodlePen.COPY) {
                this.mCopyLocation.updateLocation(this.mCopyLocation.getCopyStartX() + this.mDoodle.toX(this.mTouchX) - this.mCopyLocation.getTouchStartX(), this.mCopyLocation.getCopyStartY() + this.mDoodle.toY(this.mTouchY) - this.mCopyLocation.getTouchStartY());
            }
            if (this.mDoodle.getShape() == DoodleShape.HAND_WRITE) {
                this.mCurrPath.quadTo(this.mDoodle.toX(this.mLastTouchX), this.mDoodle.toY(this.mLastTouchY), this.mDoodle.toX((this.mTouchX + this.mLastTouchX) / 2.0f), this.mDoodle.toY((this.mTouchY + this.mLastTouchY) / 2.0f));
                this.mCurrDoodlePath.updatePath(this.mCurrPath);
            } else {
                this.mCurrDoodlePath.updateXY(this.mDoodle.toX(this.mTouchDownX), this.mDoodle.toY(this.mTouchDownY), this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY));
            }
        }
        this.mDoodle.refresh();
        return true;
    }

    private boolean isPenEditable(IDoodlePen pen) {
        return this.mDoodle.getPen() == DoodlePen.TEXT && pen == DoodlePen.TEXT || this.mDoodle.getPen() == DoodlePen.BITMAP && pen == DoodlePen.BITMAP;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        this.mLastTouchX = this.mTouchX;
        this.mLastTouchY = this.mTouchY;
        this.mTouchX = e.getX();
        this.mTouchY = e.getY();
        if (this.mDoodle.isEditMode()) {
            boolean found = false;
            List<IDoodleItem> items = this.mDoodle.getAllItem();
            for (int i = items.size() - 1; i >= 0; --i) {
                IDoodleSelectableItem item;
                IDoodleItem elem = items.get(i);
                if (!elem.isDoodleEditable() || !(elem instanceof IDoodleSelectableItem) || !(item = (IDoodleSelectableItem)elem).contains(this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY))) continue;
                found = true;
                this.setSelectedItem(item);
                PointF xy = item.getLocation();
                this.mStartX = xy.x;
                this.mStartY = xy.y;
                break;
            }
            if (!found && this.mSelectedItem != null) {
                IDoodleSelectableItem old = this.mSelectedItem;
                this.setSelectedItem(null);
                if (this.mSelectionListener != null) {
                    this.mSelectionListener.onSelectedItem(this.mDoodle, old, false);
                }
            }
        } else if (this.isPenEditable(this.mDoodle.getPen())) {
            if (this.mSelectionListener != null) {
                this.mSelectionListener.onCreateSelectableItem(this.mDoodle, this.mDoodle.toX(this.mTouchX), this.mDoodle.toY(this.mTouchY));
            }
        } else {
            this.onScrollBegin(e);
            e.offsetLocation(1.0f, 1.0f);
            this.onScroll(e, e, 1.0f, 1.0f);
            this.onScrollEnd(e);
        }
        this.mDoodle.refresh();
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetectorApi27 detector) {
        this.mLastFocusX = null;
        this.mLastFocusY = null;
        return true;
    }

    public boolean onScale(ScaleGestureDetectorApi27 detector) {
        this.mTouchCentreX = detector.getFocusX();
        this.mTouchCentreY = detector.getFocusY();
        if (this.mLastFocusX != null && this.mLastFocusY != null) {
            float dx = this.mTouchCentreX - this.mLastFocusX.floatValue();
            float dy = this.mTouchCentreY - this.mLastFocusY.floatValue();
            if (Math.abs(dx) > 1.0f || Math.abs(dy) > 1.0f) {
                if (this.mSelectedItem == null || !this.mSupportScaleItem) {
                    this.mDoodle.setDoodleTranslationX(this.mDoodle.getDoodleTranslationX() + dx + this.pendingX);
                    this.mDoodle.setDoodleTranslationY(this.mDoodle.getDoodleTranslationY() + dy + this.pendingY);
                }
                this.pendingY = 0.0f;
                this.pendingX = 0.0f;
            } else {
                this.pendingX += dx;
                this.pendingY += dy;
            }
        }
        if (Math.abs(1.0f - detector.getScaleFactor()) > 0.005f) {
            if (this.mSelectedItem == null || !this.mSupportScaleItem) {
                float scale = this.mDoodle.getDoodleScale() * detector.getScaleFactor() * this.pendingScale;
                this.mDoodle.setDoodleScale(scale, this.mDoodle.toX(this.mTouchCentreX), this.mDoodle.toY(this.mTouchCentreY));
            } else {
                this.mSelectedItem.setScale(this.mSelectedItem.getScale() * detector.getScaleFactor() * this.pendingScale);
            }
            this.pendingScale = 1.0f;
        } else {
            this.pendingScale *= detector.getScaleFactor();
        }
        this.mLastFocusX = Float.valueOf(this.mTouchCentreX);
        this.mLastFocusY = Float.valueOf(this.mTouchCentreY);
        return true;
    }

    public void onScaleEnd(ScaleGestureDetectorApi27 detector) {
        if (this.mDoodle.isEditMode()) {
            this.limitBound(true);
            return;
        }
        this.center();
    }

    public void center() {
        if (this.mDoodle.getDoodleScale() < 1.0f) {
            if (this.mScaleAnimator == null) {
                this.mScaleAnimator = new ValueAnimator();
                this.mScaleAnimator.setDuration(100L);
                this.mScaleAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        float value = ((Float)animation.getAnimatedValue()).floatValue();
                        float fraction = animation.getAnimatedFraction();
                        DoodleOnTouchGestureListener.this.mDoodle.setDoodleScale(value, DoodleOnTouchGestureListener.this.mDoodle.toX(DoodleOnTouchGestureListener.this.mTouchCentreX), DoodleOnTouchGestureListener.this.mDoodle.toY(DoodleOnTouchGestureListener.this.mTouchCentreY));
                        DoodleOnTouchGestureListener.this.mDoodle.setDoodleTranslation(DoodleOnTouchGestureListener.this.mScaleAnimTransX * (1.0f - fraction), DoodleOnTouchGestureListener.this.mScaleAnimTranY * (1.0f - fraction));
                    }
                });
            }
            this.mScaleAnimator.cancel();
            this.mScaleAnimTransX = this.mDoodle.getDoodleTranslationX();
            this.mScaleAnimTranY = this.mDoodle.getDoodleTranslationY();
            this.mScaleAnimator.setFloatValues(new float[]{this.mDoodle.getDoodleScale(), 1.0f});
            this.mScaleAnimator.start();
        } else {
            this.limitBound(true);
        }
    }

    public void limitBound(boolean anim) {
        if (this.mDoodle.getDoodleRotation() % 90 != 0) {
            return;
        }
        float oldX = this.mDoodle.getDoodleTranslationX();
        float oldY = this.mDoodle.getDoodleTranslationY();
        RectF bound = this.mDoodle.getDoodleBound();
        float x = this.mDoodle.getDoodleTranslationX();
        float y = this.mDoodle.getDoodleTranslationY();
        float width = (float)this.mDoodle.getCenterWidth() * this.mDoodle.getRotateScale();
        float height = (float)this.mDoodle.getCenterHeight() * this.mDoodle.getRotateScale();
        if (bound.height() <= (float)this.mDoodle.getHeight()) {
            if (this.mDoodle.getDoodleRotation() == 0 || this.mDoodle.getDoodleRotation() == 180) {
                y = (height - height * this.mDoodle.getDoodleScale()) / 2.0f;
            } else {
                x = (width - width * this.mDoodle.getDoodleScale()) / 2.0f;
            }
        } else {
            float heightDiffTop = bound.top;
            if (bound.top > 0.0f && bound.bottom >= (float)this.mDoodle.getHeight()) {
                if (this.mDoodle.getDoodleRotation() == 0 || this.mDoodle.getDoodleRotation() == 180) {
                    y = this.mDoodle.getDoodleRotation() == 0 ? (y -= heightDiffTop) : (y += heightDiffTop);
                } else {
                    x = this.mDoodle.getDoodleRotation() == 90 ? (x -= heightDiffTop) : (x += heightDiffTop);
                }
            } else if (bound.bottom < (float)this.mDoodle.getHeight() && bound.top <= 0.0f) {
                float heightDiffBottom = (float)this.mDoodle.getHeight() - bound.bottom;
                if (this.mDoodle.getDoodleRotation() == 0 || this.mDoodle.getDoodleRotation() == 180) {
                    y = this.mDoodle.getDoodleRotation() == 0 ? (y += heightDiffBottom) : (y -= heightDiffBottom);
                } else {
                    x = this.mDoodle.getDoodleRotation() == 90 ? (x += heightDiffBottom) : (x -= heightDiffBottom);
                }
            }
        }
        if (bound.width() <= (float)this.mDoodle.getWidth()) {
            if (this.mDoodle.getDoodleRotation() == 0 || this.mDoodle.getDoodleRotation() == 180) {
                x = (width - width * this.mDoodle.getDoodleScale()) / 2.0f;
            } else {
                y = (height - height * this.mDoodle.getDoodleScale()) / 2.0f;
            }
        } else {
            float widthDiffLeft = bound.left;
            if (bound.left > 0.0f && bound.right >= (float)this.mDoodle.getWidth()) {
                if (this.mDoodle.getDoodleRotation() == 0 || this.mDoodle.getDoodleRotation() == 180) {
                    x = this.mDoodle.getDoodleRotation() == 0 ? (x -= widthDiffLeft) : (x += widthDiffLeft);
                } else {
                    y = this.mDoodle.getDoodleRotation() == 90 ? (y += widthDiffLeft) : (y -= widthDiffLeft);
                }
            } else if (bound.right < (float)this.mDoodle.getWidth() && bound.left <= 0.0f) {
                float widthDiffRight = (float)this.mDoodle.getWidth() - bound.right;
                if (this.mDoodle.getDoodleRotation() == 0 || this.mDoodle.getDoodleRotation() == 180) {
                    x = this.mDoodle.getDoodleRotation() == 0 ? (x += widthDiffRight) : (x -= widthDiffRight);
                } else {
                    y = this.mDoodle.getDoodleRotation() == 90 ? (y -= widthDiffRight) : (y += widthDiffRight);
                }
            }
        }
        if (anim) {
            if (this.mTranslateAnimator == null) {
                this.mTranslateAnimator = new ValueAnimator();
                this.mTranslateAnimator.setDuration(100L);
                this.mTranslateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        float value = ((Float)animation.getAnimatedValue()).floatValue();
                        float fraction = animation.getAnimatedFraction();
                        DoodleOnTouchGestureListener.this.mDoodle.setDoodleTranslation(value, DoodleOnTouchGestureListener.this.mTransAnimOldY + (DoodleOnTouchGestureListener.this.mTransAnimY - DoodleOnTouchGestureListener.this.mTransAnimOldY) * fraction);
                    }
                });
            }
            this.mTranslateAnimator.setFloatValues(new float[]{oldX, x});
            this.mTransAnimOldY = oldY;
            this.mTransAnimY = y;
            this.mTranslateAnimator.start();
        } else {
            this.mDoodle.setDoodleTranslation(x, y);
        }
    }

    public void setSelectionListener(ISelectionListener doodleListener) {
        this.mSelectionListener = doodleListener;
    }

    public ISelectionListener getSelectionListener() {
        return this.mSelectionListener;
    }

    public void setSupportScaleItem(boolean supportScaleItem) {
        this.mSupportScaleItem = supportScaleItem;
    }

    public boolean isSupportScaleItem() {
        return this.mSupportScaleItem;
    }

    public static interface ISelectionListener {
        public void onSelectedItem(IDoodle var1, IDoodleSelectableItem var2, boolean var3);

        public void onCreateSelectableItem(IDoodle var1, float var2, float var3);
    }
}

