/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import cn.hzw.doodle.DoodlePaintAttrs;
import cn.hzw.doodle.DoodleSelectableItemBase;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.util.DrawUtil;

public abstract class DoodleRotatableItemBase
extends DoodleSelectableItemBase {
    private PointF mTemp = new PointF();
    private Rect mRectTemp = new Rect();
    private boolean mIsRotating = false;
    private Paint mPaint = new Paint();

    public DoodleRotatableItemBase(IDoodle doodle, int itemRotate, float x, float y) {
        super(doodle, itemRotate, x, y);
    }

    public DoodleRotatableItemBase(IDoodle doodle, DoodlePaintAttrs attrs, int itemRotate, float x, float y) {
        super(doodle, attrs, itemRotate, x, y);
    }

    @Override
    public void doDrawAtTheTop(Canvas canvas) {
        if (this.isSelected()) {
            canvas.save();
            canvas.scale(1.0f / this.getDoodle().getDoodleScale(), 1.0f / this.getDoodle().getDoodleScale(), this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
            this.mRectTemp.set(this.getBounds());
            DrawUtil.scaleRect(this.mRectTemp, this.getDoodle().getDoodleScale(), this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
            float unit = this.getDoodle().getUnitSize();
            this.mRectTemp.left = (int)((float)this.mRectTemp.left - 3.0f * unit);
            this.mRectTemp.top = (int)((float)this.mRectTemp.top - 3.0f * unit);
            this.mRectTemp.right = (int)((float)this.mRectTemp.right + 3.0f * unit);
            this.mRectTemp.bottom = (int)((float)this.mRectTemp.bottom + 3.0f * unit);
            this.mPaint.setShader(null);
            this.mPaint.setColor(0x888888);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setStrokeWidth(1.0f);
            canvas.drawRect(this.mRectTemp, this.mPaint);
            if (this.isRotating()) {
                this.mPaint.setColor(-1996499200);
            } else {
                this.mPaint.setColor(-1996488705);
            }
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(2.0f * unit);
            canvas.drawRect(this.mRectTemp, this.mPaint);
            this.mPaint.setColor(0x44888888);
            this.mPaint.setStrokeWidth(0.8f * unit);
            canvas.drawRect(this.mRectTemp, this.mPaint);
            if (this.isRotating()) {
                this.mPaint.setColor(-1996499200);
            } else {
                this.mPaint.setColor(-1996488705);
            }
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(2.0f * unit);
            canvas.drawLine((float)this.mRectTemp.right, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), (float)this.mRectTemp.right + 19.0f * unit, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), this.mPaint);
            canvas.drawCircle((float)this.mRectTemp.right + 27.0f * unit, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), 8.0f * unit, this.mPaint);
            this.mPaint.setColor(0x44888888);
            this.mPaint.setStrokeWidth(0.8f * unit);
            canvas.drawLine((float)this.mRectTemp.right, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), (float)this.mRectTemp.right + 19.0f * unit, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), this.mPaint);
            canvas.drawCircle((float)this.mRectTemp.right + 27.0f * unit, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), 8.0f * unit, this.mPaint);
            this.mPaint.setColor(-1);
            this.mPaint.setStrokeWidth(1.0f * unit);
            this.mPaint.setStyle(Paint.Style.STROKE);
            int length = 3;
            canvas.drawLine(this.getPivotX() - this.getLocation().x - (float)length * unit, this.getPivotY() - this.getLocation().y, this.getPivotX() - this.getLocation().x + (float)length * unit, this.getPivotY() - this.getLocation().y, this.mPaint);
            canvas.drawLine(this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y - (float)length * unit, this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y + (float)length * unit, this.mPaint);
            this.mPaint.setStrokeWidth(0.5f * unit);
            this.mPaint.setColor(-7829368);
            canvas.drawLine(this.getPivotX() - this.getLocation().x - (float)length * unit, this.getPivotY() - this.getLocation().y, this.getPivotX() - this.getLocation().x + (float)length * unit, this.getPivotY() - this.getLocation().y, this.mPaint);
            canvas.drawLine(this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y - (float)length * unit, this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y + (float)length * unit, this.mPaint);
            this.mPaint.setStrokeWidth(1.0f * unit);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(-1);
            canvas.drawCircle(this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y, unit, this.mPaint);
            canvas.restore();
        }
    }

    public boolean canRotate(float x, float y) {
        IDoodle doodle = this.getDoodle();
        PointF location = this.getLocation();
        PointF xy = DrawUtil.rotatePoint(this.mTemp, (int)(-this.getItemRotate()), x -= location.x, y -= location.y, this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
        this.mRectTemp.set(this.getBounds());
        float padding = 13.0f * this.getDoodle().getUnitSize() / this.getDoodle().getDoodleScale();
        this.mRectTemp.top = (int)((float)this.mRectTemp.top - padding);
        this.mRectTemp.right = (int)((float)this.mRectTemp.right + padding);
        this.mRectTemp.bottom = (int)((float)this.mRectTemp.bottom + padding);
        return xy.x >= (float)this.mRectTemp.right && xy.x <= (float)this.mRectTemp.right + 35.0f * doodle.getUnitSize() / this.getDoodle().getDoodleScale() && xy.y >= (float)this.mRectTemp.top && xy.y <= (float)this.mRectTemp.bottom;
    }

    public boolean isRotating() {
        return this.mIsRotating;
    }

    public void setIsRotating(boolean isRotating) {
        this.mIsRotating = isRotating;
    }
}

