/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import cn.hzw.doodle.CopyLocation;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodlePaintAttrs;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleRotatableItemBase;
import cn.hzw.doodle.DoodleShape;
import cn.hzw.doodle.DoodleView;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleColor;
import cn.hzw.doodle.util.DrawUtil;
import java.util.HashMap;
import java.util.WeakHashMap;

public class DoodlePath
extends DoodleRotatableItemBase {
    public static final int MOSAIC_LEVEL_1 = 5;
    public static final int MOSAIC_LEVEL_2 = 20;
    public static final int MOSAIC_LEVEL_3 = 50;
    private final Path mPath = new Path();
    private final Path mOriginPath = new Path();
    private PointF mSxy = new PointF();
    private PointF mDxy = new PointF();
    private Paint mPaint = new Paint();
    private CopyLocation mCopyLocation;
    private final Matrix mTransform = new Matrix();
    private Rect mRect = new Rect();
    private Matrix mBitmapColorMatrix = new Matrix();
    private RectF mBound = new RectF();
    private Path mArrowTrianglePath;
    private static WeakHashMap<IDoodle, HashMap<Integer, Bitmap>> sMosaicBitmapMap = new WeakHashMap();

    public DoodlePath(IDoodle doodle) {
        super(doodle, 0, 0.0f, 0.0f);
    }

    public DoodlePath(IDoodle doodle, DoodlePaintAttrs attrs) {
        super(doodle, attrs, 0, 0.0f, 0.0f);
    }

    public void updateXY(float sx, float sy, float dx, float dy) {
        this.mSxy.set(sx, sy);
        this.mDxy.set(dx, dy);
        this.mOriginPath.reset();
        if (DoodleShape.ARROW.equals(this.getShape())) {
            this.updateArrowPath(this.mOriginPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        } else if (DoodleShape.LINE.equals(this.getShape())) {
            this.updateLinePath(this.mOriginPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        } else if (DoodleShape.FILL_CIRCLE.equals(this.getShape()) || DoodleShape.HOLLOW_CIRCLE.equals(this.getShape())) {
            this.updateCirclePath(this.mOriginPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        } else if (DoodleShape.FILL_RECT.equals(this.getShape()) || DoodleShape.HOLLOW_RECT.equals(this.getShape())) {
            this.updateRectPath(this.mOriginPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        }
        this.adjustPath(true);
    }

    public void updatePath(Path path) {
        this.mOriginPath.reset();
        this.mOriginPath.addPath(path);
        this.adjustPath(true);
    }

    public CopyLocation getCopyLocation() {
        return this.mCopyLocation;
    }

    public Path getPath() {
        return this.mPath;
    }

    private PointF getDxy() {
        return this.mDxy;
    }

    private PointF getSxy() {
        return this.mSxy;
    }

    public static DoodlePath toShape(IDoodle doodle, float sx, float sy, float dx, float dy) {
        DoodlePath path = new DoodlePath(doodle);
        path.setPen(doodle.getPen().copy());
        path.setShape(doodle.getShape().copy());
        path.setSize(doodle.getSize());
        path.setColor(doodle.getColor().copy());
        path.updateXY(sx, sy, dx, dy);
        if (path.getPen() == DoodlePen.COPY && doodle instanceof DoodleView) {
            path.mCopyLocation = DoodlePen.COPY.getCopyLocation().copy();
        }
        return path;
    }

    public static DoodlePath toPath(IDoodle doodle, Path p) {
        DoodlePath path = new DoodlePath(doodle);
        path.setPen(doodle.getPen().copy());
        path.setShape(doodle.getShape().copy());
        path.setSize(doodle.getSize());
        path.setColor(doodle.getColor().copy());
        path.updatePath(p);
        path.mCopyLocation = doodle instanceof DoodleView ? DoodlePen.COPY.getCopyLocation().copy() : null;
        return path;
    }

    @Override
    protected void doDraw(Canvas canvas) {
        this.mPaint.reset();
        this.mPaint.setStrokeWidth(this.getSize());
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setAntiAlias(true);
        this.getPen().config(this, this.mPaint);
        this.getColor().config(this, this.mPaint);
        this.getShape().config(this, this.mPaint);
        canvas.drawPath(this.getPath(), this.mPaint);
    }

    private void resetLocationBounds(Rect rect) {
        if (this.mOriginPath == null) {
            return;
        }
        int diff = (int)(this.getSize() / 2.0f + 0.5f);
        this.mOriginPath.computeBounds(this.mBound, false);
        if (this.getShape() == DoodleShape.ARROW || this.getShape() == DoodleShape.FILL_CIRCLE || this.getShape() == DoodleShape.FILL_RECT) {
            diff = (int)this.getDoodle().getUnitSize();
        }
        rect.set((int)(this.mBound.left - (float)diff), (int)(this.mBound.top - (float)diff), (int)(this.mBound.right + (float)diff), (int)(this.mBound.bottom + (float)diff));
    }

    @Override
    protected void resetBounds(Rect rect) {
        this.resetLocationBounds(rect);
        rect.set(0, 0, rect.width(), rect.height());
    }

    @Override
    public boolean isDoodleEditable() {
        if (this.getPen() == DoodlePen.ERASER) {
            return false;
        }
        return super.isDoodleEditable();
    }

    private void updateArrowPath(Path path, float sx, float sy, float ex, float ey, float size) {
        float arrowSize = size;
        double H = arrowSize;
        double L = arrowSize / 2.0f;
        double awrad = Math.atan(L / 2.0 / H);
        double arraow_len = Math.sqrt(L / 2.0 * L / 2.0 + H * H) - 5.0;
        double[] arrXY_1 = DrawUtil.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        double[] arrXY_2 = DrawUtil.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        float x_3 = (float)((double)ex - arrXY_1[0]);
        float y_3 = (float)((double)ey - arrXY_1[1]);
        float x_4 = (float)((double)ex - arrXY_2[0]);
        float y_4 = (float)((double)ey - arrXY_2[1]);
        path.moveTo(sx, sy);
        path.lineTo(x_3, y_3);
        path.lineTo(x_4, y_4);
        path.close();
        awrad = Math.atan(L / H);
        arraow_len = Math.sqrt(L * L + H * H);
        arrXY_1 = DrawUtil.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        arrXY_2 = DrawUtil.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        x_3 = (float)((double)ex - arrXY_1[0]);
        y_3 = (float)((double)ey - arrXY_1[1]);
        x_4 = (float)((double)ex - arrXY_2[0]);
        y_4 = (float)((double)ey - arrXY_2[1]);
        if (this.mArrowTrianglePath == null) {
            this.mArrowTrianglePath = new Path();
        }
        this.mArrowTrianglePath.reset();
        this.mArrowTrianglePath.moveTo(ex, ey);
        this.mArrowTrianglePath.lineTo(x_4, y_4);
        this.mArrowTrianglePath.lineTo(x_3, y_3);
        this.mArrowTrianglePath.close();
        path.addPath(this.mArrowTrianglePath);
    }

    private void updateLinePath(Path path, float sx, float sy, float ex, float ey, float size) {
        path.moveTo(sx, sy);
        path.lineTo(ex, ey);
    }

    private void updateCirclePath(Path path, float sx, float sy, float dx, float dy, float size) {
        float radius = (float)Math.sqrt((sx - dx) * (sx - dx) + (sy - dy) * (sy - dy));
        path.addCircle(sx, sy, radius, Path.Direction.CCW);
    }

    private void updateRectPath(Path path, float sx, float sy, float dx, float dy, float size) {
        if (sx < dx) {
            if (sy < dy) {
                path.addRect(sx, sy, dx, dy, Path.Direction.CCW);
            } else {
                path.addRect(sx, dy, dx, sy, Path.Direction.CCW);
            }
        } else if (sy < dy) {
            path.addRect(dx, sy, sx, dy, Path.Direction.CCW);
        } else {
            path.addRect(dx, dy, sx, sy, Path.Direction.CCW);
        }
    }

    public static DoodleColor getMosaicColor(IDoodle doodle, int level) {
        HashMap<Integer, Object> map = sMosaicBitmapMap.get(doodle);
        if (map == null) {
            map = new HashMap();
            sMosaicBitmapMap.put(doodle, map);
        }
        Matrix matrix = new Matrix();
        matrix.setScale(1.0f / (float)level, 1.0f / (float)level);
        Bitmap mosaicBitmap = (Bitmap)map.get(level);
        if (mosaicBitmap == null) {
            mosaicBitmap = Bitmap.createBitmap((Bitmap)doodle.getBitmap(), (int)0, (int)0, (int)doodle.getBitmap().getWidth(), (int)doodle.getBitmap().getHeight(), (Matrix)matrix, (boolean)true);
            map.put(level, mosaicBitmap);
        }
        matrix.reset();
        matrix.setScale((float)level, (float)level);
        DoodleColor doodleColor = new DoodleColor(mosaicBitmap, matrix, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        doodleColor.setLevel(level);
        return doodleColor;
    }

    @Override
    public void setLocation(float x, float y, boolean changePivot) {
        super.setLocation(x, y, changePivot);
        this.adjustMosaic();
    }

    @Override
    public void setColor(IDoodleColor color) {
        super.setColor(color);
        if (this.getPen() == DoodlePen.MOSAIC) {
            this.setLocation(this.getLocation().x, this.getLocation().y, false);
        }
    }

    @Override
    public void setSize(float size) {
        super.setSize(size);
        if (this.mTransform == null) {
            return;
        }
        if (DoodleShape.ARROW.equals(this.getShape())) {
            this.mOriginPath.reset();
            this.updateArrowPath(this.mOriginPath, this.mSxy.x, this.mSxy.y, this.mDxy.x, this.mDxy.y, this.getSize());
        }
        this.adjustPath(false);
    }

    @Override
    public void setScale(float scale) {
        super.setScale(scale);
        this.adjustMosaic();
    }

    private void adjustMosaic() {
        if (this.getPen() == DoodlePen.MOSAIC && this.getColor() instanceof DoodleColor) {
            DoodleColor doodleColor = (DoodleColor)this.getColor();
            Matrix matrix = doodleColor.getMatrix();
            matrix.reset();
            matrix.preScale(1.0f / this.getScale(), 1.0f / this.getScale(), this.getPivotX(), this.getPivotY());
            matrix.preTranslate(-this.getLocation().x * this.getScale(), -this.getLocation().y * this.getScale());
            matrix.preRotate(-this.getItemRotate(), this.getPivotX(), this.getPivotY());
            matrix.preScale((float)doodleColor.getLevel(), (float)doodleColor.getLevel());
            doodleColor.setMatrix(matrix);
            this.refresh();
        }
    }

    @Override
    public void setItemRotate(float textRotate) {
        super.setItemRotate(textRotate);
        this.adjustMosaic();
    }

    private void adjustPath(boolean changePivot) {
        DoodleColor color;
        this.resetLocationBounds(this.mRect);
        this.mPath.reset();
        this.mPath.addPath(this.mOriginPath);
        this.mTransform.reset();
        this.mTransform.setTranslate((float)(-this.mRect.left), (float)(-this.mRect.top));
        this.mPath.transform(this.mTransform);
        if (changePivot) {
            this.setPivotX(this.mRect.left + this.mRect.width() / 2);
            this.setPivotY(this.mRect.top + this.mRect.height() / 2);
            this.setLocation(this.mRect.left, this.mRect.top, false);
        }
        if (this.getColor() instanceof DoodleColor && (color = (DoodleColor)this.getColor()).getType() == DoodleColor.Type.BITMAP && color.getBitmap() != null) {
            this.mBitmapColorMatrix.reset();
            if (this.getPen() == DoodlePen.MOSAIC) {
                this.adjustMosaic();
            } else {
                if (this.getPen() == DoodlePen.COPY) {
                    float transXSpan = 0.0f;
                    float transYSpan = 0.0f;
                    CopyLocation copyLocation = this.getCopyLocation();
                    if (copyLocation != null) {
                        transXSpan = copyLocation.getTouchStartX() - copyLocation.getCopyStartX();
                        transYSpan = copyLocation.getTouchStartY() - copyLocation.getCopyStartY();
                    }
                    this.resetLocationBounds(this.mRect);
                    this.mBitmapColorMatrix.setTranslate(transXSpan - (float)this.mRect.left, transYSpan - (float)this.mRect.top);
                } else {
                    this.mBitmapColorMatrix.setTranslate((float)(-this.mRect.left), (float)(-this.mRect.top));
                }
                int level = color.getLevel();
                this.mBitmapColorMatrix.preScale((float)level, (float)level);
                color.setMatrix(this.mBitmapColorMatrix);
                this.refresh();
            }
        }
        this.refresh();
    }
}

