/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.PointF;
import cn.hzw.doodle.DoodlePaintAttrs;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleColor;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodleItemListener;
import cn.hzw.doodle.core.IDoodlePen;
import cn.hzw.doodle.core.IDoodleShape;
import java.util.ArrayList;
import java.util.List;

public abstract class DoodleItemBase
implements IDoodleItem,
IDoodleItemListener {
    public static final float MIN_SCALE = 0.01f;
    public static final float MAX_SCALE = 100.0f;
    private float mItemRotate;
    private IDoodle mDoodle;
    private PointF mLocation = new PointF();
    private IDoodlePen mPen;
    private IDoodleShape mShape;
    private float mSize;
    private IDoodleColor mColor;
    private boolean mIsDrawOptimize = false;
    private boolean mIsNeedClipOutside = true;
    private float mPivotX;
    private float mPivotY;
    private float mMinScale = 0.01f;
    private float mMaxScale = 100.0f;
    private float mScale = 1.0f;
    private boolean mHasAdded = false;
    private List<IDoodleItemListener> mItemListeners = new ArrayList<IDoodleItemListener>();

    public DoodleItemBase(IDoodle doodle) {
        this(doodle, null);
    }

    public DoodleItemBase(IDoodle doodle, DoodlePaintAttrs attrs) {
        this.setDoodle(doodle);
        if (attrs != null) {
            this.mPen = attrs.pen();
            this.mShape = attrs.shape();
            this.mSize = attrs.size();
            this.mColor = attrs.color();
        }
    }

    @Override
    public void setDoodle(IDoodle doodle) {
        if (doodle != null && this.mDoodle != null) {
            throw new RuntimeException("item's doodle object is not null");
        }
        this.mDoodle = doodle;
        if (doodle == null) {
            // empty if block
        }
    }

    @Override
    public IDoodle getDoodle() {
        return this.mDoodle;
    }

    @Override
    public void setPivotX(float pivotX) {
        this.mPivotX = pivotX;
        this.onPropertyChanged(3);
    }

    @Override
    public float getPivotX() {
        return this.mPivotX;
    }

    @Override
    public void setPivotY(float pivotY) {
        this.mPivotY = pivotY;
        this.onPropertyChanged(4);
    }

    @Override
    public float getPivotY() {
        return this.mPivotY;
    }

    @Override
    public void setItemRotate(float textRotate) {
        this.mItemRotate = textRotate;
        this.onPropertyChanged(2);
        this.refresh();
    }

    @Override
    public float getItemRotate() {
        return this.mItemRotate;
    }

    @Override
    public void setLocation(float x, float y) {
        this.setLocation(x, y, true);
    }

    public void setLocation(float x, float y, boolean changePivot) {
        float diffX = x - this.mLocation.x;
        float diffY = y - this.mLocation.y;
        this.mLocation.x = x;
        this.mLocation.y = y;
        this.onPropertyChanged(7);
        if (changePivot) {
            this.mPivotX += diffX;
            this.mPivotY += diffY;
            this.onPropertyChanged(3);
            this.onPropertyChanged(4);
        }
        this.refresh();
    }

    @Override
    public PointF getLocation() {
        return this.mLocation;
    }

    @Override
    public IDoodlePen getPen() {
        return this.mPen;
    }

    @Override
    public void setPen(IDoodlePen pen) {
        this.mPen = pen;
        this.refresh();
    }

    @Override
    public IDoodleShape getShape() {
        return this.mShape;
    }

    @Override
    public void setShape(IDoodleShape shape) {
        this.mShape = shape;
        this.refresh();
    }

    @Override
    public float getSize() {
        return this.mSize;
    }

    @Override
    public void setSize(float size) {
        this.mSize = size;
        this.onPropertyChanged(5);
        this.refresh();
    }

    @Override
    public IDoodleColor getColor() {
        return this.mColor;
    }

    @Override
    public void setColor(IDoodleColor color) {
        this.mColor = color;
        this.onPropertyChanged(6);
        this.refresh();
    }

    @Override
    public void draw(Canvas canvas) {
        this.drawBefore(canvas);
        canvas.save();
        this.mLocation = this.getLocation();
        canvas.translate(this.mLocation.x, this.mLocation.y);
        float px = this.mPivotX - this.mLocation.x;
        float py = this.mPivotY - this.mLocation.y;
        canvas.rotate(this.mItemRotate, px, py);
        canvas.scale(this.mScale, this.mScale, px, py);
        this.doDraw(canvas);
        canvas.restore();
        this.drawAfter(canvas);
    }

    public void setDrawOptimize(boolean drawOptimize) {
        if (drawOptimize == this.mIsDrawOptimize) {
            return;
        }
        this.mIsDrawOptimize = drawOptimize;
    }

    @Override
    public boolean isNeedClipOutside() {
        return this.mIsNeedClipOutside;
    }

    @Override
    public void setNeedClipOutside(boolean clip) {
        this.mIsNeedClipOutside = clip;
    }

    @Override
    public void onAdd() {
        this.mHasAdded = true;
    }

    @Override
    public void onRemove() {
        this.mHasAdded = false;
    }

    @Override
    public void refresh() {
        if (this.mHasAdded && this.mDoodle != null) {
            this.mDoodle.refresh();
        }
    }

    @Override
    public boolean isDoodleEditable() {
        return false;
    }

    @Override
    public void setScale(float scale) {
        if (scale <= this.mMinScale) {
            scale = this.mMinScale;
        } else if (scale > this.mMaxScale) {
            scale = this.mMaxScale;
        }
        this.mScale = scale;
        this.onPropertyChanged(1);
        this.refresh();
    }

    @Override
    public float getScale() {
        return this.mScale;
    }

    public void setMinScale(float minScale) {
        if (this.mMinScale <= 0.0f) {
            minScale = 0.01f;
        } else if (minScale > this.mMaxScale) {
            minScale = this.mMaxScale;
        }
        this.mMinScale = minScale;
        this.setScale(this.getScale());
    }

    public float getMinScale() {
        return this.mMinScale;
    }

    public void setMaxScale(float maxScale) {
        if (maxScale <= 0.0f) {
            maxScale = 0.01f;
        } else if (maxScale < this.mMinScale) {
            maxScale = this.mMinScale;
        }
        this.mMaxScale = maxScale;
        this.setScale(this.getScale());
    }

    public float getMaxScale() {
        return this.mMaxScale;
    }

    @Override
    public void addItemListener(IDoodleItemListener listener) {
        if (listener == null || this.mItemListeners.contains(listener)) {
            return;
        }
        this.mItemListeners.add(listener);
    }

    @Override
    public void removeItemListener(IDoodleItemListener listener) {
        this.mItemListeners.remove(listener);
    }

    @Override
    public void onPropertyChanged(int property) {
        for (int i = 0; i < this.mItemListeners.size(); ++i) {
            this.mItemListeners.get(i).onPropertyChanged(property);
        }
    }

    protected void drawBefore(Canvas canvas) {
    }

    protected abstract void doDraw(Canvas var1);

    protected void drawAfter(Canvas canvas) {
    }

    @Override
    public void drawAtTheTop(Canvas canvas) {
    }
}

