/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle.util;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.FrameLayout;
import cn.forward.androids.utils.LogUtil;

public class DrawUtil {
    public static void drawArrow(Canvas canvas, float sx, float sy, float ex, float ey, Paint paint) {
        float arrowSize = paint.getStrokeWidth();
        double H = arrowSize;
        double L = arrowSize / 2.0f;
        double awrad = Math.atan(L / 2.0 / H);
        double arraow_len = Math.sqrt(L / 2.0 * L / 2.0 + H * H) - 5.0;
        double[] arrXY_1 = DrawUtil.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        double[] arrXY_2 = DrawUtil.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        float x_3 = (float)((double)ex - arrXY_1[0]);
        float y_3 = (float)((double)ey - arrXY_1[1]);
        float x_4 = (float)((double)ex - arrXY_2[0]);
        float y_4 = (float)((double)ey - arrXY_2[1]);
        Path linePath = new Path();
        linePath.moveTo(sx, sy);
        linePath.lineTo(x_3, y_3);
        linePath.lineTo(x_4, y_4);
        linePath.close();
        canvas.drawPath(linePath, paint);
        awrad = Math.atan(L / H);
        arraow_len = Math.sqrt(L * L + H * H);
        arrXY_1 = DrawUtil.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        arrXY_2 = DrawUtil.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        x_3 = (float)((double)ex - arrXY_1[0]);
        y_3 = (float)((double)ey - arrXY_1[1]);
        x_4 = (float)((double)ex - arrXY_2[0]);
        y_4 = (float)((double)ey - arrXY_2[1]);
        Path triangle = new Path();
        triangle.moveTo(ex, ey);
        triangle.lineTo(x_3, y_3);
        triangle.lineTo(x_4, y_4);
        triangle.close();
        canvas.drawPath(triangle, paint);
    }

    public static double[] rotateVec(float px, float py, double ang, boolean isChLen, double newLen) {
        double[] mathstr = new double[2];
        double vx = (double)px * Math.cos(ang) - (double)py * Math.sin(ang);
        double vy = (double)px * Math.sin(ang) + (double)py * Math.cos(ang);
        if (isChLen) {
            double d = Math.sqrt(vx * vx + vy * vy);
            vx = vx / d * newLen;
            vy = vy / d * newLen;
        }
        mathstr[0] = vx;
        mathstr[1] = vy;
        return mathstr;
    }

    public static void drawLine(Canvas canvas, float sx, float sy, float dx, float dy, Paint paint) {
        canvas.drawLine(sx, sy, dx, dy, paint);
    }

    public static void drawCircle(Canvas canvas, float cx, float cy, float radius, Paint paint) {
        canvas.drawCircle(cx, cy, radius, paint);
    }

    public static void drawRect(Canvas canvas, float sx, float sy, float dx, float dy, Paint paint) {
        if (sx < dx) {
            if (sy < dy) {
                canvas.drawRect(sx, sy, dx, dy, paint);
            } else {
                canvas.drawRect(sx, dy, dx, sy, paint);
            }
        } else if (sy < dy) {
            canvas.drawRect(dx, sy, sx, dy, paint);
        } else {
            canvas.drawRect(dx, dy, sx, sy, paint);
        }
    }

    public static float computeAngle(float px1, float py1, float px2, float py2) {
        float x = px2 - px1;
        float y = py2 - py1;
        float arc = (float)Math.atan(y / x);
        float angle = (float)((double)arc / (Math.PI * 2) * 360.0);
        if (x >= 0.0f && y == 0.0f) {
            angle = 0.0f;
        } else if (x < 0.0f && y == 0.0f) {
            angle = 180.0f;
        } else if (x == 0.0f && y > 0.0f) {
            angle = 90.0f;
        } else if (x == 0.0f && y < 0.0f) {
            angle = 270.0f;
        } else if (!(x > 0.0f) || !(y > 0.0f)) {
            if (x < 0.0f && y > 0.0f) {
                angle = 180.0f + angle;
            } else if (x < 0.0f && y < 0.0f) {
                angle = 180.0f + angle;
            } else if (x > 0.0f && y < 0.0f) {
                angle = 360.0f + angle;
            }
        }
        LogUtil.i((String)"hzw", (String)("[" + px1 + "," + py1 + "]:[" + px2 + "," + py2 + "] = " + angle));
        return angle;
    }

    public static PointF rotatePoint(PointF coords, float degree, float x, float y, float px, float py) {
        if (degree % 360.0f == 0.0f) {
            coords.x = x;
            coords.y = y;
            return coords;
        }
        float radian = (float)((double)degree * Math.PI / 180.0);
        coords.x = (float)((double)(x - px) * Math.cos(radian) - (double)(y - py) * Math.sin(radian) + (double)px);
        coords.y = (float)((double)(x - px) * Math.sin(radian) + (double)(y - py) * Math.cos(radian) + (double)py);
        return coords;
    }

    public static void main(String[] args) {
    }

    public static void assistActivity(Window activity) {
        new AndroidBug5497Workaround(activity);
    }

    public static class AndroidBug5497Workaround {
        private View mChildOfContent;
        private int usableHeightPrevious;
        private FrameLayout.LayoutParams frameLayoutParams;

        private AndroidBug5497Workaround(Window window) {
            FrameLayout content = (FrameLayout)window.findViewById(0x1020002);
            this.mChildOfContent = content.getChildAt(0);
            this.mChildOfContent.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    AndroidBug5497Workaround.this.possiblyResizeChildOfContent();
                }
            });
            this.frameLayoutParams = (FrameLayout.LayoutParams)this.mChildOfContent.getLayoutParams();
        }

        private void possiblyResizeChildOfContent() {
            int usableHeightNow = this.computeUsableHeight();
            if (usableHeightNow != this.usableHeightPrevious) {
                int usableHeightSansKeyboard = this.mChildOfContent.getRootView().getHeight();
                int heightDifference = usableHeightSansKeyboard - usableHeightNow;
                this.frameLayoutParams.height = heightDifference > usableHeightSansKeyboard / 4 ? usableHeightSansKeyboard - heightDifference : usableHeightSansKeyboard;
                this.mChildOfContent.requestLayout();
                this.usableHeightPrevious = usableHeightNow;
            }
        }

        private int computeUsableHeight() {
            Rect r = new Rect();
            this.mChildOfContent.getWindowVisibleDisplayFrame(r);
            return r.bottom;
        }
    }
}

