/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import cn.hzw.doodle.DoodleItemBase;
import cn.hzw.doodle.DoodlePaintAttrs;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleSelectableItem;
import cn.hzw.doodle.util.DrawUtil;

public abstract class DoodleSelectableItemBase
extends DoodleItemBase
implements IDoodleSelectableItem {
    public static final int ITEM_CAN_ROTATE_BOUND = 35;
    public static final int ITEM_PADDING = 3;
    private Rect mRect = new Rect();
    private Rect mRectTemp = new Rect();
    private Paint mPaint = new Paint();
    private PointF mTemp = new PointF();
    private boolean mIsSelected = false;

    public DoodleSelectableItemBase(IDoodle doodle, int itemRotate, float x, float y) {
        this(doodle, null, itemRotate, x, y);
    }

    public DoodleSelectableItemBase(IDoodle doodle, DoodlePaintAttrs attrs, int itemRotate, float x, float y) {
        super(doodle, attrs);
        this.setLocation(x, y);
        this.setItemRotate(itemRotate);
        this.resetBounds(this.mRect);
    }

    @Override
    public Rect getBounds() {
        return this.mRect;
    }

    @Override
    public void setSize(float size) {
        super.setSize(size);
        this.resetBounds(this.mRect);
    }

    @Override
    public boolean contains(float x, float y) {
        this.resetBounds(this.mRect);
        PointF location = this.getLocation();
        this.mTemp = DrawUtil.rotatePoint(this.mTemp, (int)(-this.getItemRotate()), x -= location.x, y -= location.y, this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
        this.mRectTemp.set(this.mRect);
        float unit = this.getDoodle().getUnitSize();
        this.mRectTemp.left = (int)((float)this.mRectTemp.left - 3.0f * unit);
        this.mRectTemp.top = (int)((float)this.mRectTemp.top - 3.0f * unit);
        this.mRectTemp.right = (int)((float)this.mRectTemp.right + 3.0f * unit);
        this.mRectTemp.bottom = (int)((float)this.mRectTemp.bottom + 3.0f * unit);
        return this.mRectTemp.contains((int)this.mTemp.x, (int)this.mTemp.y);
    }

    @Override
    protected void drawBefore(Canvas canvas) {
    }

    @Override
    protected void drawAfter(Canvas canvas) {
    }

    @Override
    public void drawAtTheTop(Canvas canvas) {
        canvas.save();
        PointF location = this.getLocation();
        canvas.translate(location.x, location.y);
        canvas.rotate(this.getItemRotate(), this.getPivotX() - this.getLocation().x, this.getPivotY() - this.getLocation().y);
        this.doDrawAtTheTop(canvas);
        canvas.restore();
    }

    public void doDrawAtTheTop(Canvas canvas) {
        if (this.isSelected()) {
            this.mRectTemp.set(this.getBounds());
            float unit = this.getDoodle().getUnitSize();
            this.mRectTemp.left = (int)((float)this.mRectTemp.left - 3.0f * unit);
            this.mRectTemp.top = (int)((float)this.mRectTemp.top - 3.0f * unit);
            this.mRectTemp.right = (int)((float)this.mRectTemp.right + 3.0f * unit);
            this.mRectTemp.bottom = (int)((float)this.mRectTemp.bottom + 3.0f * unit);
            this.mPaint.setShader(null);
            this.mPaint.setColor(0x888888);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setStrokeWidth(1.0f);
            canvas.drawRect(this.mRectTemp, this.mPaint);
            this.mPaint.setColor(-1996488705);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(2.0f * unit);
            canvas.drawRect(this.mRectTemp, this.mPaint);
            this.mPaint.setColor(0x44888888);
            this.mPaint.setStrokeWidth(0.8f * unit);
            canvas.drawRect(this.mRectTemp, this.mPaint);
        }
    }

    @Override
    public boolean isSelected() {
        return this.mIsSelected;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.mIsSelected = isSelected;
        this.setNeedClipOutside(!isSelected);
        this.refresh();
    }

    protected abstract void resetBounds(Rect var1);
}

