/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import cn.hzw.doodle.CopyLocation;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodleItemBase;
import cn.hzw.doodle.DoodlePath;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodlePen;

public enum DoodlePen implements IDoodlePen
{
    BRUSH,
    COPY,
    ERASER,
    TEXT(true),
    BITMAP(true);

    private boolean mIsSelectable = false;
    private CopyLocation mCopyLocation;
    private Matrix mMatrix;

    private DoodlePen() {
        this(false);
    }

    private DoodlePen(boolean isSelectable) {
        this.mIsSelectable = isSelectable;
    }

    @Override
    public void config(IDoodleItem item, Paint paint) {
        DoodleItemBase doodleItem = (DoodleItemBase)item;
        if (doodleItem.getPen() == COPY) {
            float transX = 0.0f;
            float transY = 0.0f;
            float transXSpan = 0.0f;
            float transYSpan = 0.0f;
            CopyLocation copyLocation = ((DoodlePath)item).getCopyLocation();
            if (copyLocation != null) {
                transXSpan = copyLocation.getTouchStartX() - copyLocation.getCopyStartX();
                transYSpan = copyLocation.getTouchStartY() - copyLocation.getCopyStartY();
            }
            this.mMatrix.reset();
            this.mMatrix.postTranslate(-transX + transXSpan, -transY + transYSpan);
            if (item.getColor() instanceof DoodleColor) {
                ((DoodleColor)item.getColor()).setMatrix(this.mMatrix);
            }
        }
    }

    @Override
    public boolean isSelectable() {
        return this.mIsSelectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        if (this == ERASER) {
            throw new UnsupportedOperationException("DoodlePen.ERASER is unselectable");
        }
        this.mIsSelectable = selectable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyLocation getCopyLocation() {
        if (this != COPY) {
            return null;
        }
        if (this.mCopyLocation == null) {
            DoodlePen doodlePen = this;
            synchronized (doodlePen) {
                if (this.mCopyLocation == null) {
                    this.mCopyLocation = new CopyLocation();
                    this.mMatrix = new Matrix();
                }
            }
        }
        return this.mCopyLocation;
    }

    @Override
    public void drawHelpers(Canvas canvas, IDoodle doodle) {
        if (this == COPY) {
            this.mCopyLocation.drawItSelf(canvas, doodle.getSize());
        }
    }

    @Override
    public IDoodlePen copy() {
        return this;
    }
}

