/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import cn.hzw.doodle.DoodleRotatableItemBase;
import cn.hzw.doodle.core.IDoodle;

public class DoodleBitmap
extends DoodleRotatableItemBase {
    private Bitmap mBitmap;
    private Rect mSrcRect = new Rect();
    private Rect mDstRect = new Rect();

    public DoodleBitmap(IDoodle doodle, Bitmap bitmap, float size, float x, float y) {
        super(doodle, -doodle.getDoodleRotation(), x, y);
        this.mBitmap = bitmap;
        this.setSize(size);
        this.resetBounds(this.getBounds());
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.resetBounds(this.getBounds());
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public void resetBounds(Rect rect) {
        if (this.mBitmap == null) {
            return;
        }
        float size = this.getSize();
        rect.set(0, 0, (int)size, (int)(size * (float)this.mBitmap.getHeight() / (float)this.mBitmap.getWidth()));
        this.mSrcRect.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
        this.mDstRect.set(0, 0, (int)size, (int)(size * (float)this.mBitmap.getHeight()) / this.mBitmap.getWidth());
    }

    @Override
    public void doDraw(Canvas canvas) {
        canvas.drawBitmap(this.mBitmap, this.mSrcRect, this.mDstRect, null);
    }
}

