/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import cn.hzw.doodle.DoodlePaintAttrs;
import cn.hzw.doodle.DoodleSelectableItemBase;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.util.DrawUtil;

public abstract class DoodleRotatableItemBase
extends DoodleSelectableItemBase {
    private PointF mTemp = new PointF();
    private Rect mRectTemp = new Rect();
    private boolean mIsRotating = false;
    private Paint mPaint = new Paint();

    public DoodleRotatableItemBase(IDoodle doodle, int itemRotate, float x, float y) {
        super(doodle, itemRotate, x, y);
    }

    public DoodleRotatableItemBase(IDoodle doodle, DoodlePaintAttrs attrs, int itemRotate, float x, float y) {
        super(doodle, attrs, itemRotate, x, y);
    }

    @Override
    public void doDrawSelectedBackground(Canvas canvas) {
        this.mRectTemp.set(this.getBounds());
        float unit = this.getDoodle().getUnitSize();
        this.mRectTemp.left = (int)((float)this.mRectTemp.left - 10.0f * unit);
        this.mRectTemp.top = (int)((float)this.mRectTemp.top - 10.0f * unit);
        this.mRectTemp.right = (int)((float)this.mRectTemp.right + 10.0f * unit);
        this.mRectTemp.bottom = (int)((float)this.mRectTemp.bottom + 10.0f * unit);
        this.mPaint.setShader(null);
        this.mPaint.setColor(0x33888888);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
        canvas.drawRect(this.mRectTemp, this.mPaint);
        if (this.isRotating()) {
            this.mPaint.setColor(-1996499200);
        } else {
            this.mPaint.setColor(-1996488705);
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f * unit);
        canvas.drawRect(this.mRectTemp, this.mPaint);
        this.mPaint.setColor(0x44888888);
        this.mPaint.setStrokeWidth(0.8f * unit);
        canvas.drawRect(this.mRectTemp, this.mPaint);
        if (this.isRotating()) {
            this.mPaint.setColor(-1996499200);
        } else {
            this.mPaint.setColor(-1996488705);
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f * unit);
        canvas.drawLine((float)this.mRectTemp.right, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), (float)this.mRectTemp.right + 54.0f * unit, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), this.mPaint);
        canvas.drawCircle((float)this.mRectTemp.right + 62.0f * unit, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), 8.0f * unit, this.mPaint);
        this.mPaint.setColor(0x44888888);
        this.mPaint.setStrokeWidth(0.8f * unit);
        canvas.drawLine((float)this.mRectTemp.right, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), (float)this.mRectTemp.right + 54.0f * unit, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), this.mPaint);
        canvas.drawCircle((float)this.mRectTemp.right + 62.0f * unit, (float)(this.mRectTemp.top + this.mRectTemp.height() / 2), 8.0f * unit, this.mPaint);
    }

    public boolean canRotate(float x, float y) {
        IDoodle doodle = this.getDoodle();
        PointF location = this.getLocation();
        PointF xy = DrawUtil.rotatePoint(this.mTemp, (int)(-this.getItemRotate()), x -= location.x, y -= location.y, 0.0f, 0.0f);
        this.mRectTemp.set(this.getBounds());
        float unit = doodle.getUnitSize();
        this.mRectTemp.left = (int)((float)this.mRectTemp.left - 13.0f * unit);
        this.mRectTemp.top = (int)((float)this.mRectTemp.top - 13.0f * unit);
        this.mRectTemp.right = (int)((float)this.mRectTemp.right + 13.0f * unit);
        this.mRectTemp.bottom = (int)((float)this.mRectTemp.bottom + 13.0f * unit);
        return xy.x >= (float)this.mRectTemp.right && xy.x <= (float)this.mRectTemp.right + 70.0f * doodle.getUnitSize() && xy.y >= (float)this.mRectTemp.top && xy.y <= (float)this.mRectTemp.bottom;
    }

    public boolean isRotating() {
        return this.mIsRotating;
    }

    public void setIsRotating(boolean isRotating) {
        this.mIsRotating = isRotating;
    }
}

