/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import cn.forward.androids.R;
import cn.forward.androids.utils.ColorUtil;
import cn.forward.androids.views.ScrollPickerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringScrollPicker
extends ScrollPickerView<String> {
    private int mMeasureWidth;
    private int mMeasureHeight;
    private Paint mPaint = new Paint(1);
    private int mMinTextSize = 24;
    private int mMaxTextSize = 32;
    private int mStartColor = -16777216;
    private int mEndColor = -7829368;

    public StringScrollPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StringScrollPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(-16777216);
        this.init(attrs);
        this.setData(new ArrayList<String>(Arrays.asList("one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve")));
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ScrollPickerView);
            this.mMinTextSize = typedArray.getDimensionPixelSize(R.styleable.ScrollPickerView_spv_min_text_size, this.mMinTextSize);
            this.mMaxTextSize = typedArray.getDimensionPixelSize(R.styleable.ScrollPickerView_spv_max_text_size, this.mMaxTextSize);
            this.mStartColor = typedArray.getColor(R.styleable.ScrollPickerView_spv_start_color, this.mStartColor);
            this.mEndColor = typedArray.getColor(R.styleable.ScrollPickerView_spv_end_color, this.mEndColor);
            this.setCenterItemBackground(typedArray.getColor(R.styleable.ScrollPickerView_spv_center_item_background, this.getCenterItemBackground()));
            this.setVisibleItemCount(typedArray.getInt(R.styleable.ScrollPickerView_spv_visible_item_count, this.getVisibleItemCount()));
            this.setCenterPosition(typedArray.getInt(R.styleable.ScrollPickerView_spv_center_item_position, this.getCenterPosition()));
            this.setIsCirculation(typedArray.getBoolean(R.styleable.ScrollPickerView_spv_is_circulation, this.isIsCirculation()));
            this.setDisallowInterceptTouch(typedArray.getBoolean(R.styleable.ScrollPickerView_spv_disallow_intercept_touch, this.isDisallowInterceptTouch()));
            typedArray.recycle();
        }
    }

    public void setColor(int startColor, int endColor) {
        this.mStartColor = startColor;
        this.mEndColor = endColor;
        this.invalidate();
    }

    public void setMinTestSize(int size) {
        this.mMinTextSize = size;
        this.invalidate();
    }

    public void setMaxTestSize(int size) {
        this.mMaxTextSize = size;
        this.invalidate();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mMeasureWidth = this.getMeasuredWidth();
        this.mMeasureHeight = this.getMeasuredHeight();
    }

    @Override
    public void drawItem(Canvas canvas, List<String> data, int position, int relative, float moveLength, float top) {
        String text = data.get(position);
        int itemHeight = this.getItemHeight();
        float x = 0.0f;
        if (relative == -1) {
            if (moveLength < 0.0f) {
                this.mPaint.setTextSize((float)this.mMinTextSize);
            } else {
                this.mPaint.setTextSize((float)this.mMinTextSize + (float)(this.mMaxTextSize - this.mMinTextSize) * moveLength / (float)itemHeight);
            }
        } else if (relative == 0) {
            this.mPaint.setTextSize((float)this.mMinTextSize + (float)(this.mMaxTextSize - this.mMinTextSize) * ((float)itemHeight - Math.abs(moveLength)) / (float)itemHeight);
        } else if (relative == 1) {
            if (moveLength > 0.0f) {
                this.mPaint.setTextSize((float)this.mMinTextSize);
            } else {
                this.mPaint.setTextSize((float)this.mMinTextSize + (float)(this.mMaxTextSize - this.mMinTextSize) * -moveLength / (float)itemHeight);
            }
        } else {
            this.mPaint.setTextSize((float)this.mMinTextSize);
        }
        x = ((float)this.mMeasureWidth - this.mPaint.measureText(text)) / 2.0f;
        Paint.FontMetricsInt fmi = this.mPaint.getFontMetricsInt();
        float y = top + (float)(itemHeight / 2) - (float)fmi.descent + (float)((fmi.bottom - fmi.top) / 2);
        this.computeColor(relative, itemHeight, moveLength);
        canvas.drawText(text, x, y, this.mPaint);
    }

    private void computeColor(int relative, int mItemHeight, float moveLength) {
        int color = this.mEndColor;
        if (relative == -1 || relative == 1) {
            if (relative == -1 && moveLength < 0.0f || relative == 1 && moveLength > 0.0f) {
                color = this.mEndColor;
            } else {
                float rate = ((float)mItemHeight - Math.abs(moveLength)) / (float)mItemHeight;
                color = ColorUtil.computeGradientColor(this.mStartColor, this.mEndColor, rate);
            }
        } else if (relative == 0) {
            float rate = Math.abs(moveLength) / (float)mItemHeight;
            color = ColorUtil.computeGradientColor(this.mStartColor, this.mEndColor, rate);
        }
        this.mPaint.setColor(color);
    }
}

